/*
 * Decompiled with CFR 0.152.
 */
package spiderweb;

import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.P2PVertex;
import spiderweb.visualizer.NetworkGraphVisualizer;

public class GraphPopupMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 1429587389581580356L;
    protected DefaultModalGraphMouse<P2PVertex, P2PConnection> gm;
    protected NetworkGraphVisualizer visualizer;
    protected JMenuItem balloonLayout;
    protected JMenuItem treeLayout;
    protected JMenuItem radialTreeLayout;
    protected JMenuItem treeSeparator;
    private Timer stopAnimateTimer;

    public GraphPopupMenu(NetworkGraphVisualizer visualizer, DefaultModalGraphMouse<P2PVertex, P2PConnection> gm) {
        this.visualizer = visualizer;
        this.gm = gm;
        JMenuItem picking = new JMenuItem("Picking");
        JMenuItem transforming = new JMenuItem("Transforming");
        JMenuItem hideSelected = new JMenuItem("Hide Selected");
        JMenuItem showAll = new JMenuItem("Show All");
        JMenuItem circleLayout = new JMenuItem("Circle Layout");
        JMenuItem frLayout = new JMenuItem("FR Layout");
        JMenuItem isomLayout = new JMenuItem("ISOM Layout");
        JMenuItem kkLayout = new JMenuItem("KK Layout");
        JMenuItem springLayout = new JMenuItem("Spring Layout");
        this.radialTreeLayout = new JMenuItem("Radial Tree Layout");
        this.balloonLayout = new JMenuItem("Balloon Layout");
        this.treeLayout = new JMenuItem("Tree Layout");
        this.treeSeparator = new JMenuItem("Tree Type Layouts:");
        this.treeSeparator.setEnabled(false);
        picking.addActionListener(this);
        transforming.addActionListener(this);
        hideSelected.addActionListener(this);
        showAll.addActionListener(this);
        kkLayout.addActionListener(this);
        frLayout.addActionListener(this);
        isomLayout.addActionListener(this);
        circleLayout.addActionListener(this);
        springLayout.addActionListener(this);
        this.balloonLayout.addActionListener(this);
        this.treeLayout.addActionListener(this);
        this.radialTreeLayout.addActionListener(this);
        this.add("Mouse Mode:").setEnabled(false);
        this.add(picking);
        this.add(transforming);
        this.addSeparator();
        this.add("Vertex Hiding:").setEnabled(false);
        this.add(hideSelected);
        this.add(showAll);
        this.addSeparator();
        this.add("Set Layout:").setEnabled(false);
        this.add(circleLayout);
        this.add(frLayout);
        this.add(isomLayout);
        this.add(kkLayout);
        this.add(springLayout);
        this.stopAnimateTimer = new Timer("freeze layout timer", true);
    }

    public void showPopupMenu(int x, int y) {
        this.setEnabled(true);
        if (!this.visualizer.getName().equals("Collapsed Document View")) {
            this.remove(this.treeSeparator);
            this.remove(this.balloonLayout);
            this.remove(this.treeLayout);
            this.remove(this.radialTreeLayout);
        } else {
            this.add(this.treeSeparator);
            this.add(this.balloonLayout);
            this.add(this.treeLayout);
            this.add(this.radialTreeLayout);
        }
        this.show((Component)((Object)this.visualizer), x, y);
    }

    public void popupMenuEvent(String text) {
        if (text.contains("Layout")) {
            Layout currentLayout = this.visualizer.getGraphLayout();
            Object newLayout = null;
            P2PNetworkGraph graph = (P2PNetworkGraph)this.visualizer.getGraphLayout().getGraph();
            newLayout = text.equals("FR Layout") ? new FRLayout((Graph)graph, this.visualizer.getSize()) : (text.equals("ISOM Layout") ? new ISOMLayout((Graph)graph) : (text.equals("KK Layout") ? new KKLayout((Graph)graph) : (text.equals("Spring Layout") ? new SpringLayout2((Graph)graph) : (text.equals("Balloon Layout") ? new BalloonLayout(P2PNetworkGraph.makeTreeGraph(graph)) : (text.equals("Radial Tree Layout") ? new RadialTreeLayout(P2PNetworkGraph.makeTreeGraph(graph)) : (text.equals("Tree Layout") ? new TreeLayout(P2PNetworkGraph.makeTreeGraph(graph)) : new CircleLayout((Graph)graph)))))));
            newLayout.setInitializer((Transformer)this.visualizer.getGraphLayout());
            if (!newLayout.getClass().equals(TreeLayout.class)) {
                newLayout.setSize(this.visualizer.getSize());
            }
            LayoutTransition transition = new LayoutTransition((VisualizationViewer)this.visualizer, currentLayout, (Layout)newLayout);
            Animator transitionAnimator = new Animator((IterativeContext)transition);
            transitionAnimator.start();
            this.stopAnimateTimer.schedule(new StopAnimateTask(transitionAnimator, newLayout), 5000L);
            this.visualizer.getRenderContext().getMultiLayerTransformer().setToIdentity();
        } else if (text.equals("Picking")) {
            this.gm.setMode(ModalGraphMouse.Mode.PICKING);
        } else if (text.equals("Transforming")) {
            this.gm.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        } else if (text.equals("Hide Selected")) {
            for (P2PVertex v : this.visualizer.getPickedVertexState().getPicked()) {
                v.setHidden(true);
            }
        } else if (text.equals("Show All")) {
            for (P2PVertex v : this.visualizer.getGraphLayout().getGraph().getVertices()) {
                v.setHidden(false);
            }
        } else {
            JOptionPane.showMessageDialog(this, "GraphPopupMenu.popupMenuEvent(): " + text, "Uncaught menu action", 0);
            return;
        }
        this.visualizer.repaint();
        this.setVisible(false);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String buttonText = ((AbstractButton)e.getSource()).getText();
        this.popupMenuEvent(buttonText);
    }

    private class StopAnimateTask<V, E>
    extends TimerTask {
        private Animator animatorToStop;
        private Layout<V, E> layoutToLock;

        public StopAnimateTask(Animator animatorToStop, Layout<V, E> layoutToLock) {
            this.animatorToStop = animatorToStop;
            this.layoutToLock = layoutToLock;
        }

        @Override
        public void run() {
            this.animatorToStop.stop();
            for (Object v : this.layoutToLock.getGraph().getVertices()) {
                this.layoutToLock.lock(v, true);
            }
        }
    }
}

