/*
 * Decompiled with CFR 0.152.
 */
package spiderweb;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import spiderweb.graph.LogEvent;
import spiderweb.visualizer.eventplayer.EventPlayer;

public class LogEventTable
extends JTable
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 304553330811497820L;
    public static final Object[] titles = new Object[]{"Time", "Type", "Param 1", "Param 2", "Param 3"};
    protected EventPlayer player;
    protected JButton goToRecentEventButton;
    protected JCheckBox followEventsCheckBox;

    public LogEventTable(List<LogEvent> logEvents, EventPlayer player) {
        this.player = player;
        this.init(logEvents);
    }

    private void init(List<LogEvent> logEvents) {
        Object[][] data = new Object[logEvents.size()][5];
        int i = 0;
        for (LogEvent evt : logEvents) {
            data[i] = evt.toArray();
            ++i;
        }
        this.setModel(new DefaultTableModel(data, titles));
        this.setBackground(Color.LIGHT_GRAY);
        this.setSelectionMode(1);
        this.setAutoResizeMode(4);
        this.setEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.goToRecentEventButton = new JButton("Go To Latest Event");
        this.goToRecentEventButton.addActionListener(this);
        this.followEventsCheckBox = new JCheckBox("Follow Events");
        this.setVisible(true);
    }

    public void addEvents(List<LogEvent> events) {
        DefaultTableModel table = (DefaultTableModel)this.dataModel;
        table.removeRow(table.getRowCount() - 1);
        for (LogEvent evt : events) {
            table.addRow(evt.toArray());
        }
    }

    public JPanel getInPanel() {
        JScrollPane listScroller = new JScrollPane(this);
        listScroller.setWheelScrollingEnabled(true);
        listScroller.setBorder(BorderFactory.createLoweredBevelBorder());
        listScroller.setSize(this.getWidth(), this.getHeight());
        JPanel optionsPanel = new JPanel(new GridLayout(2, 1));
        optionsPanel.add(this.goToRecentEventButton);
        optionsPanel.add(this.followEventsCheckBox);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)listScroller, "Center");
        tablePanel.add((Component)optionsPanel, "South");
        tablePanel.setBorder(BorderFactory.createTitledBorder("Log Events"));
        return tablePanel;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.isVisible()) {
            this.clearSelection();
            this.addRowSelectionInterval(0, this.player.getCurrentIndex() - 1);
            if (this.followEventsCheckBox.isSelected()) {
                this.scrollToLatest();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.scrollToLatest();
    }

    private void scrollToLatest() {
        this.scrollRectToVisible(this.getCellRect(this.player.getCurrentIndex() + 10, 0, true));
    }
}

