/*
 * Decompiled with CFR 0.152.
 */
package spiderweb;

import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections15.Transformer;
import org.jdom.JDOMException;
import spiderweb.GraphPopupMenu;
import spiderweb.LogEventTable;
import spiderweb.PlaybackPanel;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.graph.savingandloading.DocumentGraphLoader;
import spiderweb.graph.savingandloading.LoadingListener;
import spiderweb.graph.savingandloading.P2PNetworkGraphLoader;
import spiderweb.graph.savingandloading.P2PNetworkGraphSaver;
import spiderweb.networking.ConnectDialog;
import spiderweb.networking.HTTPClient;
import spiderweb.networking.NetworkGraphListener;
import spiderweb.visualizer.NetworkGraphVisualizer;
import spiderweb.visualizer.ViewState;
import spiderweb.visualizer.eventplayer.EventPlayer;
import spiderweb.visualizer.eventplayer.EventPlayerListener;
import spiderweb.visualizer.eventplayer.PlayState;
import spiderweb.visualizer.transformers.P2PVertexPlacer;

public class P2PGraphViewer
extends JApplet
implements EventPlayerListener,
NetworkGraphListener {
    private static final long serialVersionUID = -1536972184940704765L;
    public static final int DEFWIDTH = 1360;
    public static final int DEFHEIGHT = 768;
    protected List<LoadingListener> loadingListeners;
    protected LogEventTable eventTable;
    protected JPanel graphsPanel;
    protected PlaybackPanel playbackPanel;
    protected EventPlayer eventThread;
    protected Component mainPane;
    protected GraphPopupMenu popupMenu;
    protected HTTPClient networkClient;
    protected List<LogEvent> logEvents;
    protected ReferencedNetworkGraph graph;
    protected NetworkGraphVisualizer visualizer;

    public P2PGraphViewer() {
        this.init();
        this.start();
    }

    private JMenuBar createFileMenu() {
        JMenu file = new JMenu("File");
        JMenuItem connect = new JMenuItem("Connect to..");
        connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String url;
                if (P2PGraphViewer.this.eventThread != null) {
                    P2PGraphViewer.this.eventThread.pause();
                }
                if (!(url = ConnectDialog.getConnectURL()).equals("CANCELED")) {
                    P2PGraphViewer.this.networkClient.startNetwork(url);
                }
            }
        });
        file.add(connect);
        JMenuItem save = new JMenuItem("Save");
        save.addActionListener(new SaveListener());
        JMenuItem load = new JMenuItem("Load");
        load.addActionListener(new LoadListener());
        JMenuItem loadDocumentGraph = new JMenuItem("Load Document Graph");
        loadDocumentGraph.addActionListener(new LoadDocumentGraphListener());
        file.addSeparator();
        file.add(save);
        file.add(load);
        file.add(loadDocumentGraph);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (P2PGraphViewer.this.eventThread != null) {
                    P2PGraphViewer.this.eventThread.pause();
                }
                int option = JOptionPane.showConfirmDialog(null, "Would you like to save before quitting?", "Save", 1, 3);
                System.exit(0);
            }
        });
        file.addSeparator();
        file.add(exit);
        JMenu window = new JMenu("Window");
        ButtonGroup windowGroup = new ButtonGroup();
        JRadioButtonMenuItem noneItem = new JRadioButtonMenuItem("Just Graph");
        noneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                P2PGraphViewer.this.getContentPane().removeAll();
                P2PGraphViewer.this.getContentPane().add(P2PGraphViewer.this.mainPane);
                P2PGraphViewer.this.validate();
            }
        });
        window.add(noneItem);
        windowGroup.add(noneItem);
        noneItem.setSelected(true);
        JRadioButtonMenuItem logTableItem = new JRadioButtonMenuItem("Show Log Table");
        logTableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (P2PGraphViewer.this.logEvents != null) {
                    JRadioButtonMenuItem button = (JRadioButtonMenuItem)ae.getSource();
                    if (button.isSelected()) {
                        JSplitPane p = new JSplitPane(1);
                        p.setResizeWeight(0.8f);
                        p.add(P2PGraphViewer.this.mainPane);
                        p.add(P2PGraphViewer.this.eventTable.getInPanel());
                        p.setDividerSize(3);
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(p);
                        P2PGraphViewer.this.validate();
                    } else {
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(P2PGraphViewer.this.mainPane);
                        P2PGraphViewer.this.validate();
                    }
                }
            }
        });
        window.add(logTableItem);
        windowGroup.add(logTableItem);
        JRadioButtonMenuItem visualOptionsItem = new JRadioButtonMenuItem("Show Visual Options Pane");
        visualOptionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (P2PGraphViewer.this.logEvents != null) {
                    JRadioButtonMenuItem button = (JRadioButtonMenuItem)ae.getSource();
                    if (button.isSelected()) {
                        JSplitPane p = new JSplitPane(1);
                        p.setResizeWeight(0.75);
                        p.add(P2PGraphViewer.this.mainPane);
                        p.add(P2PGraphViewer.this.visualizer.getOptionsPanel());
                        p.setDividerSize(3);
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(p);
                        P2PGraphViewer.this.validate();
                    } else {
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(P2PGraphViewer.this.mainPane);
                        P2PGraphViewer.this.validate();
                    }
                }
            }
        });
        window.add(visualOptionsItem);
        windowGroup.add(visualOptionsItem);
        JMenuBar bar = new JMenuBar();
        bar.add(file);
        bar.add(window);
        bar.setVisible(true);
        return bar;
    }

    @Override
    public void init() {
        this.setPreferredSize(new Dimension(1360, 768));
        this.networkClient = new HTTPClient(this);
        this.loadingListeners = new LinkedList<LoadingListener>();
        this.graphsPanel = new JPanel(new GridLayout(1, 1));
        this.graphsPanel.setSize(800, 600);
        this.graphsPanel.setBorder(BorderFactory.createTitledBorder("Graphs"));
        this.playbackPanel = new PlaybackPanel();
        JSplitPane p = new JSplitPane(0);
        p.setResizeWeight(1.0);
        p.add(this.graphsPanel);
        p.add(this.playbackPanel);
        p.setDividerSize(0);
        p.setEnabled(false);
        this.getContentPane().setFont(new Font("Arial", 0, 12));
        this.getContentPane().setBounds(0, 0, 1360, 768);
        this.setJMenuBar(this.createFileMenu());
        this.getContentPane().add(p);
        this.setPreferredSize(new Dimension(1360, 768));
        this.mainPane = p;
        this.loadingListeners.add(this.playbackPanel);
    }

    private void startGraph() {
        FRLayout2 layout = new FRLayout2((Graph)this.graph.getFullGraph());
        layout.setInitializer((Transformer)new P2PVertexPlacer((Layout<P2PVertex, P2PConnection>)layout, new Dimension(1360, 768)));
        for (LoadingListener l : this.loadingListeners) {
            l.loadingStarted(3, "Building Visualizer");
        }
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        MouseClickListener clickListener = new MouseClickListener();
        this.visualizer = NetworkGraphVisualizer.getPersonalizedVisualizer((Layout<P2PVertex, P2PConnection>)layout, (DefaultModalGraphMouse<P2PVertex, P2PConnection>)gm, this.graph, this.graphsPanel.getWidth(), this.graphsPanel.getHeight());
        this.visualizer.addMouseListener(clickListener);
        this.popupMenu = new GraphPopupMenu(this.visualizer, (DefaultModalGraphMouse<P2PVertex, P2PConnection>)gm);
        for (LoadingListener l : this.loadingListeners) {
            l.loadingProgress(1);
        }
        if (this.logEvents.isEmpty()) {
            this.playbackPanel.getPlaybackSlider().setMaximum(0);
            this.eventThread = new EventPlayer(this.graph);
        } else {
            this.playbackPanel.getPlaybackSlider().setMaximum((int)this.logEvents.get(this.logEvents.size() - 1).getTime());
            this.eventThread = new EventPlayer(this.graph, this.logEvents, this.playbackPanel.getPlaybackSlider());
        }
        this.eventThread.addEventPlayerListener(this);
        this.eventTable = new LogEventTable(this.logEvents, this.eventThread);
        this.playbackPanel.getPlaybackSlider().addChangeListener(this.eventTable);
        for (LoadingListener l : this.loadingListeners) {
            l.loadingProgress(2);
        }
        this.graphsPanel.add((Component)((Object)this.visualizer));
        for (LoadingListener l : this.loadingListeners) {
            l.loadingComplete();
        }
        this.playbackPanel.startPlayback(this.eventThread);
        for (LoadingListener l : this.loadingListeners) {
            l.loadingProgress(3);
        }
        layout.lock(true);
        this.validate();
        this.doRepaint();
        this.eventThread.beginPlayback();
    }

    public ReferencedNetworkGraph getGraph() {
        return this.graph;
    }

    public NetworkGraphVisualizer getVisualizer() {
        return this.visualizer;
    }

    @Override
    public void stateChanged(PlayState state) {
        this.playbackPanel.updateButtons(state);
    }

    @Override
    public void doRepaint() {
        this.visualizer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void incomingLogEvents(InputStream inStream) {
        try {
            List<LogEvent> events;
            P2PNetworkGraph p2PNetworkGraph = this.graph.getFullGraph();
            synchronized (p2PNetworkGraph) {
                events = P2PNetworkGraphLoader.buildLogs(inStream, this.networkClient, this.graph);
            }
            if (!events.isEmpty()) {
                int i = 0;
                while (i < events.size()) {
                    this.graph.getFullGraph().robustGraphEvent(events, i);
                    ++i;
                }
                events.add(LogEvent.getEndEvent(events.get(events.size() - 1)));
                this.eventThread.addEvents(events);
                this.eventTable.addEvents(events);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void incomingGraph(InputStream inStream) {
        try {
            P2PNetworkGraphLoader loader = P2PNetworkGraphLoader.buildGraph(inStream, this.networkClient);
            this.getContentPane().removeAll();
            this.getContentPane().add(this.mainPane);
            this.validate();
            if (this.logEvents != null) {
                this.graphsPanel.removeAll();
                this.logEvents.clear();
                this.eventThread.stopPlayback();
                this.playbackPanel.stopPlayback();
            }
            this.logEvents = loader.getLogList();
            this.graph = loader.getGraph();
            this.startGraph();
            this.eventThread.setRobustMode(true);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        P2PGraphViewer graphViewer = new P2PGraphViewer();
        JFrame frame = new JFrame();
        frame.add(graphViewer);
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 600));
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
    }

    class LoadDocumentGraphListener
    implements ActionListener {
        LoadDocumentGraphListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Thread loadingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.eventThread != null) {
                        ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.eventThread.pause();
                    }
                    DocumentGraphLoader loader = new DocumentGraphLoader();
                    loader.addProgressListener(((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.playbackPanel);
                    if (loader.doLoad()) {
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.mainPane);
                        P2PGraphViewer.this.validate();
                        if (((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.logEvents != null) {
                            ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.graphsPanel.removeAll();
                            ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.logEvents.clear();
                            ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.eventThread.stopPlayback();
                            ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.playbackPanel.stopPlayback();
                        }
                        ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.logEvents = loader.getLogList();
                        ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.graph = loader.getGraph();
                        P2PGraphViewer.this.startGraph();
                        ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.eventThread.setRobustMode(false);
                        ((LoadDocumentGraphListener)LoadDocumentGraphListener.this).P2PGraphViewer.this.visualizer.setView(ViewState.CollapsedDocumentView);
                    }
                }
            });
            loadingThread.start();
        }
    }

    class LoadListener
    implements ActionListener {
        LoadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Thread loadingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (((LoadListener)LoadListener.this).P2PGraphViewer.this.eventThread != null) {
                        ((LoadListener)LoadListener.this).P2PGraphViewer.this.eventThread.pause();
                    }
                    P2PNetworkGraphLoader loader = new P2PNetworkGraphLoader();
                    loader.addProgressListener(((LoadListener)LoadListener.this).P2PGraphViewer.this.playbackPanel);
                    if (loader.doLoad()) {
                        P2PGraphViewer.this.getContentPane().removeAll();
                        P2PGraphViewer.this.getContentPane().add(((LoadListener)LoadListener.this).P2PGraphViewer.this.mainPane);
                        P2PGraphViewer.this.validate();
                        if (((LoadListener)LoadListener.this).P2PGraphViewer.this.logEvents != null) {
                            ((LoadListener)LoadListener.this).P2PGraphViewer.this.graphsPanel.removeAll();
                            ((LoadListener)LoadListener.this).P2PGraphViewer.this.logEvents.clear();
                            ((LoadListener)LoadListener.this).P2PGraphViewer.this.eventThread.stopPlayback();
                            ((LoadListener)LoadListener.this).P2PGraphViewer.this.playbackPanel.stopPlayback();
                        }
                        ((LoadListener)LoadListener.this).P2PGraphViewer.this.logEvents = loader.getLogList();
                        ((LoadListener)LoadListener.this).P2PGraphViewer.this.graph = loader.getGraph();
                        P2PGraphViewer.this.startGraph();
                        ((LoadListener)LoadListener.this).P2PGraphViewer.this.eventThread.setRobustMode(false);
                    }
                }
            });
            loadingThread.start();
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                P2PGraphViewer.this.popupMenu.showPopupMenu(e.getX(), e.getY());
            }
        }
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (P2PGraphViewer.this.logEvents != null) {
                P2PGraphViewer.this.eventThread.pause();
                int option = JOptionPane.showConfirmDialog(null, "Would you like to save the log events after this graph snapshot", "Save", 1, 3);
                if (option == 0) {
                    P2PNetworkGraphSaver saver = new P2PNetworkGraphSaver(P2PGraphViewer.this.graph.getDynamicGraph(), P2PGraphViewer.this.eventThread.getSaveEvents(), P2PGraphViewer.this.eventThread.getCurrentTime());
                    saver.addProgressListener(P2PGraphViewer.this.playbackPanel);
                    saver.doSave();
                } else if (option == 1) {
                    P2PNetworkGraphSaver saver = new P2PNetworkGraphSaver(P2PGraphViewer.this.graph.getDynamicGraph());
                    saver.addProgressListener(P2PGraphViewer.this.playbackPanel);
                    saver.doSave();
                }
            }
        }
    }
}

