/*
 * Decompiled with CFR 0.152.
 */
package spiderweb;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import spiderweb.graph.savingandloading.LoadingListener;
import spiderweb.visualizer.eventplayer.EventPlayer;
import spiderweb.visualizer.eventplayer.PlayState;

public class PlaybackPanel
extends JPanel
implements ActionListener,
ChangeListener,
LoadingListener {
    private static final long serialVersionUID = -4379461440497103002L;
    protected JButton fastForwardButton;
    protected JButton forwardButton;
    protected JButton pauseButton;
    protected JButton reverseButton;
    protected JButton fastReverseButton;
    protected JSlider fastSpeedSlider = new JSlider(0, 0, 100, 25);
    protected JSlider playbackSlider;
    protected JProgressBar progressBar;
    protected JPanel mainPanel;
    protected EventPlayer player;

    public PlaybackPanel() {
        this.fastSpeedSlider.setMajorTickSpacing((this.fastSpeedSlider.getMaximum() - this.fastSpeedSlider.getMinimum()) / 4);
        this.fastSpeedSlider.setFont(new Font("Arial", 0, 8));
        this.fastSpeedSlider.setPaintTicks(false);
        this.fastSpeedSlider.setPaintLabels(true);
        this.fastSpeedSlider.setForeground(Color.BLACK);
        this.fastSpeedSlider.setBorder(BorderFactory.createTitledBorder("Quick Playback Speed"));
        this.fastSpeedSlider.setEnabled(false);
        this.fastReverseButton = new JButton("<|<|");
        this.fastReverseButton.setName("Fast Reverse Button");
        this.fastReverseButton.setEnabled(false);
        this.reverseButton = new JButton("<|");
        this.reverseButton.setName("Reverse Button");
        this.reverseButton.setEnabled(false);
        this.pauseButton = new JButton("||");
        this.pauseButton.setName("Pause Button");
        this.pauseButton.setEnabled(false);
        this.forwardButton = new JButton("|>");
        this.forwardButton.setName("Forward Button");
        this.forwardButton.setEnabled(false);
        this.fastForwardButton = new JButton("|>|>");
        this.fastForwardButton.setName("Fast Forward Button");
        this.fastForwardButton.setEnabled(false);
        this.playbackSlider = new JSlider(0, 0, 100, 0);
        this.playbackSlider.setEnabled(false);
        this.progressBar = new JProgressBar(0);
        GridBagLayout southLayout = new GridBagLayout();
        GridBagConstraints southConstraints = new GridBagConstraints();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(southLayout);
        buttonPanel.add(this.fastReverseButton);
        buttonPanel.add(this.reverseButton);
        buttonPanel.add(this.pauseButton);
        buttonPanel.add(this.forwardButton);
        buttonPanel.add(this.fastForwardButton);
        southConstraints.gridwidth = 0;
        southLayout.setConstraints(this.fastSpeedSlider, southConstraints);
        buttonPanel.add(this.fastSpeedSlider);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(2, 1));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder("Playback Options"));
        this.mainPanel.add(buttonPanel);
        this.mainPanel.add(this.playbackSlider);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
    }

    public void startPlayback(EventPlayer player) {
        this.player = player;
        this.fastSpeedSlider.setEnabled(true);
        this.playbackSlider.setEnabled(true);
        this.fastSpeedSlider.addChangeListener(this);
        this.fastReverseButton.addActionListener(this);
        this.reverseButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.fastForwardButton.addActionListener(this);
        SliderListener s = new SliderListener();
        this.playbackSlider.addChangeListener(s);
        this.playbackSlider.addMouseListener(s);
    }

    public void stopPlayback() {
        this.fastSpeedSlider.removeChangeListener(this);
        this.fastReverseButton.removeActionListener(this);
        this.reverseButton.removeActionListener(this);
        this.pauseButton.removeActionListener(this);
        this.forwardButton.removeActionListener(this);
        this.fastForwardButton.removeActionListener(this);
        this.fastReverseButton.setEnabled(false);
        this.reverseButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.fastForwardButton.setEnabled(false);
        this.fastSpeedSlider.setEnabled(false);
        this.playbackSlider.setEnabled(false);
        this.playbackSlider.setValue(0);
        this.player = null;
    }

    public JSlider getPlaybackSlider() {
        return this.playbackSlider;
    }

    public void updateButtons(PlayState state) {
        this.fastReverseButton.setEnabled(true);
        this.reverseButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
        this.forwardButton.setEnabled(true);
        this.fastForwardButton.setEnabled(true);
        switch (state) {
            case FASTREVERSE: {
                this.fastReverseButton.setEnabled(false);
                break;
            }
            case REVERSE: {
                this.reverseButton.setEnabled(false);
                break;
            }
            case FASTFORWARD: {
                this.fastForwardButton.setEnabled(false);
                break;
            }
            case FORWARD: {
                this.forwardButton.setEnabled(false);
                break;
            }
            case PAUSE: {
                if (this.player.atFront()) {
                    this.fastReverseButton.setEnabled(false);
                    this.reverseButton.setEnabled(false);
                }
                this.pauseButton.setEnabled(false);
                if (!this.player.atBack()) break;
                this.forwardButton.setEnabled(false);
                this.fastForwardButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton source = (JButton)ae.getSource();
        String buttonName = source.getName();
        if (buttonName.equals("Fast Reverse Button")) {
            this.player.fastReverse();
        } else if (buttonName.equals("Reverse Button")) {
            this.player.reverse();
        } else if (buttonName.equals("Pause Button")) {
            this.player.pause();
        } else if (buttonName.equals("Forward Button")) {
            this.player.forward();
        } else if (buttonName.equals("Fast Forward Button")) {
            this.player.fastForward();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.player.setSpeedMultiplier(((JSlider)ce.getSource()).getValue());
    }

    @Override
    public void loadingStarted(int loadingAmount, String whatIsLoading) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(loadingAmount);
        this.progressBar.setName(whatIsLoading);
        this.progressBar.setValue(0);
        this.progressBar.setString(String.valueOf(whatIsLoading) + ": 0%");
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "North");
        this.validate();
    }

    @Override
    public void loadingProgress(int progress) {
        this.progressBar.setValue(progress);
        this.progressBar.setString(String.valueOf(String.format(String.valueOf(this.progressBar.getName()) + ": %.3g%n", this.progressBar.getPercentComplete() * 100.0)) + "%");
    }

    @Override
    public void loadingComplete() {
        this.remove(this.progressBar);
    }

    class SliderListener
    extends MouseAdapter
    implements ChangeListener {
        PlayState prevState = PlayState.PAUSE;

        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            if (PlaybackPanel.this.player != null) {
                JSlider source = (JSlider)ce.getSource();
                PlaybackPanel.this.player.goToTime(source.getValue());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (((JSlider)e.getSource()).isEnabled()) {
                this.prevState = PlaybackPanel.this.player.getPlayState();
                PlaybackPanel.this.player.pause();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (((JSlider)e.getSource()).isEnabled()) {
                if (this.prevState == PlayState.FASTREVERSE) {
                    PlaybackPanel.this.player.fastReverse();
                } else if (this.prevState == PlayState.REVERSE) {
                    PlaybackPanel.this.player.reverse();
                } else if (this.prevState == PlayState.FORWARD) {
                    PlaybackPanel.this.player.forward();
                } else if (this.prevState == PlayState.FASTFORWARD) {
                    PlaybackPanel.this.player.fastForward();
                } else if (this.prevState == PlayState.PAUSE) {
                    PlaybackPanel.this.player.pause();
                }
            }
        }
    }
}

