/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph;

public class LogEvent
implements Comparable<LogEvent> {
    private long time = 0L;
    private String type = "default";
    private int param1 = 0;
    private int param2 = 0;
    private int param3 = 0;

    public LogEvent(String rawEvent) {
        rawEvent.trim();
        String[] words = rawEvent.split("[:]+");
        this.time = Long.parseLong(words[0]);
        this.type = words[1];
        this.param1 = Integer.parseInt(words[2]);
        this.param2 = 0;
        this.param3 = 0;
        if (words.length == 4) {
            this.param2 = Integer.parseInt(words[3]);
        }
        if (words.length == 5) {
            this.param2 = Integer.parseInt(words[3]);
            this.param3 = Integer.parseInt(words[4]);
        }
    }

    public LogEvent(long time, String type, int param1, int param2, int param3) {
        this.time = time;
        this.type = type;
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
    }

    public static LogEvent createOpposingLogEvent(LogEvent creator, int delay) {
        return new LogEvent(creator.getTime() + (long)delay, "un" + creator.getType(), creator.getParam(1), creator.getParam(2), creator.getParam(3));
    }

    public boolean isConstructing() {
        return this.type.equals("connect") || this.type.equals("publish") || this.type.equals("online") || this.type.equals("linkdocument");
    }

    public boolean isStructural() {
        return this.isConstructing() || this.type.equals("offline") || this.type.equals("disconnect") || this.type.equals("remove") || this.type.equals("delinkdocument");
    }

    public boolean isImportantToPeer() {
        return this.type.equals("connect") || this.type.equals("publish") || this.type.equals("disconnect") || this.type.equals("remove");
    }

    public static boolean isValidEventType(String type) {
        return type.equals("start") || type.equals("end") || type.equals("online") || type.equals("offline") || type.equals("publish") || type.equals("remove") || type.equals("connect") || type.equals("disconnect") || type.equals("linkdocument") || type.equals("delinkdocument") || type.equals("query") || type.equals("unquery") || type.equals("queryhit") || type.equals("unqueryhit") || type.equals("queryedge") || type.equals("unqueryedge") || type.equals("queryreachespeer") || type.equals("unqueryreachespeer");
    }

    public boolean isColouringEvent() {
        return !this.isStructural() && LogEvent.isValidEventType(this.type);
    }

    public long getTime() {
        return this.time;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasParamTwo() {
        return LogEvent.typeHasParamTwo(this.type);
    }

    public static boolean typeHasParamTwo(String eventType) {
        return !eventType.equals("online") && !eventType.equals("offline");
    }

    public boolean hasParamThree() {
        return LogEvent.typeHasParamThree(this.type);
    }

    public static boolean typeHasParamThree(String eventType) {
        return eventType.equals("query") || eventType.equals("queryhit");
    }

    public int getParam(int which) {
        if (which == 1) {
            return this.param1;
        }
        if (which == 2) {
            return this.param2;
        }
        if (which == 3) {
            return this.param3;
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] array = new Object[]{new Long(this.time), this.type, new Integer(this.param1), new Integer(this.param2), new Integer(this.param3)};
        return array;
    }

    public String toString() {
        return String.valueOf(this.time) + ":" + this.type + ":" + this.param1 + ":" + this.param2 + ":" + this.param3;
    }

    @Override
    public int compareTo(LogEvent other) {
        if (this.time < other.time) {
            return -1;
        }
        if (this.time > other.time) {
            return 1;
        }
        if (this.type.charAt(0) < other.type.charAt(0)) {
            return -1;
        }
        if (this.type.charAt(0) < other.type.charAt(0)) {
            return 1;
        }
        return 0;
    }

    public static LogEvent getStartEvent() {
        return new LogEvent("0:start:0:0");
    }

    public static LogEvent getEndEvent(LogEvent lastEventInList) {
        return new LogEvent(String.valueOf(lastEventInList.getTime() + 100L) + ":end:0:0");
    }
}

