/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph;

public class P2PConnection {
    public static final int P2P = 0;
    public static final int P2DOC = 10;
    public static final int P2PDOC = 20;
    public static final int DOC2PDOC = 30;
    public static final int DOC2DOC = 40;
    public static final int QUERYING = 1;
    public static final int ANSWERING = 2;
    public static final int MATCHING_DOC = 11;
    private int mytypeandstate;
    private Integer key;
    private String edgeName;

    public P2PConnection(int type, Integer key) {
        this.mytypeandstate = type;
        this.key = key;
        this.edgeName = "edge " + key.toString();
    }

    public Integer getKey() {
        return this.key;
    }

    public int getType() {
        if (this.mytypeandstate < 10) {
            return 0;
        }
        if (this.mytypeandstate >= 10 && this.mytypeandstate < 20) {
            return 10;
        }
        if (this.mytypeandstate >= 20 && this.mytypeandstate < 30) {
            return 20;
        }
        return 30;
    }

    public boolean isP2P() {
        return this.getType() == 0;
    }

    public boolean isP2DOC() {
        return this.getType() == 10;
    }

    public boolean isP2PDOC() {
        return this.getType() == 20;
    }

    public boolean isDOC2PDOC() {
        return this.getType() == 30;
    }

    public void query() {
        if (this.mytypeandstate == 0) {
            this.mytypeandstate = 1;
        }
    }

    public void backToNormal() {
        if (this.isQuerying()) {
            this.mytypeandstate = 0;
        }
    }

    public boolean isQuerying() {
        return this.mytypeandstate == 1;
    }

    public boolean equals(Object other) {
        if (other instanceof P2PConnection) {
            return this.key.equals(((P2PConnection)other).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.edgeName;
    }
}

