/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph;

import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;

public class P2PNetworkGraph
extends DirectedSparseGraph<P2PVertex, P2PConnection>
implements Graph<P2PVertex, P2PConnection> {
    private static final long serialVersionUID = -5569894854823217541L;
    private int edgecounter = 0;

    protected void addPeer(int peernumber) {
        PeerVertex v1 = new PeerVertex(peernumber);
        super.addVertex((Object)v1);
    }

    protected void removePeer(int peernum) {
        PeerVertex peer = new PeerVertex(peernum);
        Collection edgeset = this.getIncidentEdges(peer);
        TreeSet<PeerDocumentVertex> docsToRemove = new TreeSet<PeerDocumentVertex>();
        for (P2PConnection e : edgeset) {
            P2PVertex node = (P2PVertex)this.getOpposite(peer, e);
            if (!(node instanceof PeerDocumentVertex)) continue;
            docsToRemove.add((PeerDocumentVertex)node);
        }
        for (PeerDocumentVertex n : docsToRemove) {
            this.removeDocument(n.getDocumentNumber(), n.getPeerNumber());
        }
        this.removeVertex(peer);
    }

    protected void addDocument(int docnumber, int peer) {
        this.addDocument(docnumber, peer, new Integer(++this.edgecounter));
        this.addPeerDocument(docnumber, peer, new Integer(++this.edgecounter), new Integer(++this.edgecounter));
    }

    protected void addPeerDocument(int docnumber, int peer, Integer peerEdgeKey, Integer docEdgeKey) {
        PeerDocumentVertex pDocV = new PeerDocumentVertex(peer, docnumber);
        this.addVertex(pDocV);
        PeerVertex vpeer = new PeerVertex(peer);
        DocumentVertex vdoc = new DocumentVertex(docnumber);
        this.addEdge(new P2PConnection(20, peerEdgeKey), vpeer, pDocV);
        this.addEdge(new P2PConnection(30, docEdgeKey), pDocV, vdoc);
    }

    protected void addDocument(int docnumber, int peer, Integer edgeKey) {
        DocumentVertex vdoc = this.getDocument(docnumber);
        if (vdoc == null) {
            vdoc = new DocumentVertex(docnumber);
            this.addVertex(vdoc);
        }
        P2PVertex vpeer = this.getVertexInGraph(new PeerVertex(peer));
        this.addEdge(new P2PConnection(10, edgeKey), vpeer, vdoc);
    }

    protected void removeDocument(int docnumber, int peer) {
        P2PVertex peerDoc = this.getVertexInGraph(new PeerDocumentVertex(peer, docnumber));
        P2PVertex publisher = this.getVertexInGraph(new PeerVertex(peer));
        P2PVertex document = this.getVertexInGraph(new DocumentVertex(docnumber));
        P2PConnection peerToPeerDocEdge = (P2PConnection)this.findEdge(publisher, peerDoc);
        P2PConnection peerToDocEdge = (P2PConnection)this.findEdge(publisher, document);
        P2PConnection docToPeerDocEdge = (P2PConnection)this.findEdge(document, peerDoc);
        this.removeEdge(peerToDocEdge);
        this.removeEdge(peerToPeerDocEdge);
        this.removeEdge(docToPeerDocEdge);
        this.removeVertex(peerDoc);
        if (document != null && this.getIncidentEdges(document).size() == 0) {
            this.removeVertex(document);
        }
    }

    protected void connectDocuments(int doc1, int doc2) {
        this.connectDocuments(doc1, doc2, new Integer(++this.edgecounter));
    }

    protected void connectDocuments(int doc1, int doc2, Integer edgeKey) {
        P2PVertex documentOne = this.getVertexInGraph(new DocumentVertex(doc1));
        P2PVertex documentTwo = this.getVertexInGraph(new DocumentVertex(doc2));
        this.addEdge(new P2PConnection(40, edgeKey), documentOne, documentTwo);
    }

    protected void disconnectDocuments(int from, int to) {
        P2PConnection edge = this.findDocumentToDocumentConnection(from, to);
        super.removeEdge((Object)edge);
    }

    protected void connectPeers(int from, int to) {
        this.connectPeers(from, to, new Integer(++this.edgecounter));
    }

    protected void connectPeers(int from, int to, Integer edgeKey) {
        P2PConnection edge = new P2PConnection(0, edgeKey);
        if (!this.containsEdge(edge)) {
            this.addEdge(edge, this.getVertexInGraph(new PeerVertex(from)), this.getVertexInGraph(new PeerVertex(to)));
        }
    }

    protected void disconnectPeers(int from, int to) {
        P2PConnection edge = this.findPeerConnection(from, to);
        super.removeEdge((Object)edge);
    }

    public P2PVertex getVertexInGraph(P2PVertex input) {
        for (P2PVertex v : this.vertices.keySet()) {
            if (!v.equals(input)) continue;
            return v;
        }
        return null;
    }

    public PeerVertex getPeer(int peerNumber) {
        return (PeerVertex)this.getVertexInGraph(new PeerVertex(peerNumber));
    }

    public DocumentVertex getDocument(int documentNumber) {
        return (DocumentVertex)this.getVertexInGraph(new DocumentVertex(documentNumber));
    }

    public PeerDocumentVertex getPeerDocument(int publisherNumber, int documentNumber) {
        return (PeerDocumentVertex)this.getVertexInGraph(new PeerDocumentVertex(publisherNumber, documentNumber));
    }

    public boolean isPeerOnline(int peerNumber) {
        return this.getPeer(peerNumber) != null;
    }

    public boolean isDocumentPublished(int documentNumber) {
        return this.getDocument(documentNumber) != null;
    }

    public P2PConnection findPeerConnection(int peerFrom, int peerTo) {
        P2PConnection connection = (P2PConnection)this.findEdge(new PeerVertex(peerFrom), new PeerVertex(peerTo));
        return connection;
    }

    public boolean arePeersConnected(int peer1, int peer2) {
        return this.findPeerConnection(peer1, peer2) != null && this.findPeerConnection(peer2, peer1) != null;
    }

    public P2PConnection findDocumentToDocumentConnection(int docFrom, int docTo) {
        P2PConnection connection = (P2PConnection)this.findEdge(new DocumentVertex(docFrom), new DocumentVertex(docTo));
        return connection;
    }

    public boolean areDocumentsConnected(int docFrom, int docTo) {
        return this.findDocumentToDocumentConnection(docFrom, docTo) != null;
    }

    public P2PConnection findPeerToDocConnection(int peer, int docnumber) {
        P2PVertex p = this.getVertexInGraph(new PeerVertex(peer));
        P2PVertex doc = this.getVertexInGraph(new DocumentVertex(docnumber));
        P2PConnection connection = (P2PConnection)this.findEdge(p, doc);
        return connection;
    }

    public P2PConnection findPeerToPeerDocConnection(int peer, int docnumber) {
        return (P2PConnection)this.findEdge(new PeerVertex(peer), new PeerDocumentVertex(peer, docnumber));
    }

    public P2PConnection findDocToPeerDocConnection(int peer, int docnumber) {
        return (P2PConnection)this.findEdge(new PeerDocumentVertex(peer, docnumber), new DocumentVertex(docnumber));
    }

    public Collection<P2PConnection> getEdges() {
        return this.edges.keySet();
    }

    public Collection<P2PVertex> getVertices() {
        return this.vertices.keySet();
    }

    public static Forest<P2PVertex, P2PConnection> makeTreeGraph(P2PNetworkGraph graph) {
        DelegateForest tree = new DelegateForest();
        for (P2PVertex documentVertex : graph.getVertices()) {
            P2PVertex opposite;
            if (!documentVertex.getClass().equals(DocumentVertex.class)) continue;
            tree.addVertex((Object)documentVertex);
            for (P2PConnection edge : graph.getOutEdges(documentVertex)) {
                opposite = (P2PVertex)graph.getOpposite(documentVertex, edge);
                if (!opposite.getClass().equals(DocumentVertex.class)) continue;
                tree.addEdge((Object)edge, (Object)documentVertex, (Object)opposite);
            }
            for (P2PConnection edge : graph.getInEdges(documentVertex)) {
                opposite = (P2PVertex)graph.getOpposite(documentVertex, edge);
                if (!opposite.getClass().equals(PeerDocumentVertex.class)) continue;
                tree.addEdge((Object)edge, (Object)documentVertex, (Object)opposite);
            }
        }
        return tree;
    }

    public void graphEvent(LogEvent evt) {
        if (evt.getType().equals("online")) {
            int peerNumber = evt.getParam(1);
            if (!this.isPeerOnline(peerNumber)) {
                this.addPeer(peerNumber);
            }
        } else if (evt.getType().equals("connect")) {
            int peer1 = evt.getParam(1);
            int peer2 = evt.getParam(2);
            if (!this.isPeerOnline(peer1)) {
                this.addPeer(peer1);
            }
            if (!this.isPeerOnline(peer2)) {
                this.addPeer(peer2);
            }
            if (!this.arePeersConnected(peer1, peer2)) {
                this.connectPeers(peer1, peer2);
                this.connectPeers(peer2, peer1);
            }
        } else if (evt.getType().equals("publish")) {
            int peer = evt.getParam(1);
            int document = evt.getParam(2);
            if (!this.isPeerOnline(peer)) {
                this.addPeer(peer);
            }
            this.addDocument(document, peer);
        } else if (evt.getType().equals("linkdocument")) {
            int doc1 = evt.getParam(1);
            int doc2 = evt.getParam(2);
            if (this.isDocumentPublished(doc1) && this.isDocumentPublished(doc2)) {
                this.connectDocuments(doc1, doc2);
            }
        }
    }

    public void graphEvent(LogEvent evt, boolean forward, P2PNetworkGraph referenceGraph) {
        if (forward) {
            if (evt.getType().equals("online")) {
                this.addPeer(evt.getParam(1));
            } else if (evt.getType().equals("offline")) {
                this.removePeer(evt.getParam(1));
            } else if (evt.getType().equals("connect")) {
                this.connectPeers(evt.getParam(1), evt.getParam(2), referenceGraph.findPeerConnection(evt.getParam(1), evt.getParam(2)).getKey());
                this.connectPeers(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerConnection(evt.getParam(2), evt.getParam(1)).getKey());
            } else if (evt.getType().equals("disconnect")) {
                this.disconnectPeers(evt.getParam(1), evt.getParam(2));
                this.disconnectPeers(evt.getParam(2), evt.getParam(1));
            } else if (evt.getType().equals("publish")) {
                this.addDocument(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerToDocConnection(evt.getParam(1), evt.getParam(2)).getKey());
                this.addPeerDocument(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerToPeerDocConnection(evt.getParam(1), evt.getParam(2)).getKey(), referenceGraph.findDocToPeerDocConnection(evt.getParam(1), evt.getParam(2)).getKey());
            } else if (evt.getType().equals("remove")) {
                this.removeDocument(evt.getParam(2), evt.getParam(1));
            } else if (evt.getType().equals("linkdocument")) {
                this.connectDocuments(evt.getParam(1), evt.getParam(2), referenceGraph.findDocumentToDocumentConnection(evt.getParam(1), evt.getParam(2)).getKey());
            } else if (evt.getType().equals("delinkdocument")) {
                this.disconnectDocuments(evt.getParam(1), evt.getParam(2));
            }
        } else if (evt.getType().equals("online")) {
            this.removePeer(evt.getParam(1));
        } else if (evt.getType().equals("offline")) {
            this.addPeer(evt.getParam(1));
        } else if (evt.getType().equals("connect")) {
            this.disconnectPeers(evt.getParam(1), evt.getParam(2));
            this.disconnectPeers(evt.getParam(2), evt.getParam(1));
        } else if (evt.getType().equals("disconnect")) {
            this.connectPeers(evt.getParam(1), evt.getParam(2), referenceGraph.findPeerConnection(evt.getParam(1), evt.getParam(2)).getKey());
            this.connectPeers(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerConnection(evt.getParam(2), evt.getParam(1)).getKey());
        } else if (evt.getType().equals("publish")) {
            this.removeDocument(evt.getParam(2), evt.getParam(1));
        } else if (evt.getType().equals("remove")) {
            this.addDocument(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerToDocConnection(evt.getParam(1), evt.getParam(2)).getKey());
            this.addPeerDocument(evt.getParam(2), evt.getParam(1), referenceGraph.findPeerToPeerDocConnection(evt.getParam(1), evt.getParam(2)).getKey(), referenceGraph.findDocToPeerDocConnection(evt.getParam(1), evt.getParam(2)).getKey());
        } else if (evt.getType().equals("linkdocument")) {
            this.disconnectDocuments(evt.getParam(1), evt.getParam(2));
        } else if (evt.getType().equals("delinkdocument")) {
            this.connectDocuments(evt.getParam(1), evt.getParam(2), referenceGraph.findDocumentToDocumentConnection(evt.getParam(1), evt.getParam(2)).getKey());
        }
    }

    public void robustGraphEvent(List<LogEvent> events, int currentIndex) {
        int peer;
        LogEvent evt = events.get(currentIndex);
        if (evt.getType().equals("online")) {
            int peerNumber = evt.getParam(1);
            if (!this.isPeerOnline(peerNumber)) {
                this.addPeer(peerNumber);
            }
        } else if (evt.getType().equals("offline")) {
            int peerNumber = evt.getParam(1);
            if (this.isPeerOnline(peerNumber)) {
                this.removePeer(peerNumber);
            }
        } else if (evt.getType().equals("connect")) {
            int peer1 = evt.getParam(1);
            int peer2 = evt.getParam(2);
            if (!this.isPeerOnline(peer1)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer1);
                this.addPeer(peer1);
            }
            if (!this.isPeerOnline(peer2)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer2);
                this.addPeer(peer2);
            }
            if (!this.arePeersConnected(peer1, peer2)) {
                this.connectPeers(peer1, peer2);
                this.connectPeers(peer2, peer1);
            }
        } else if (evt.getType().equals("disconnect")) {
            int peer1 = evt.getParam(1);
            int peer2 = evt.getParam(2);
            if (!this.isPeerOnline(peer1)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer1);
                this.addPeer(peer1);
            }
            if (!this.isPeerOnline(peer2)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer2);
                this.addPeer(peer2);
            }
            if (this.arePeersConnected(peer1, peer2)) {
                this.disconnectPeers(peer1, peer2);
                this.disconnectPeers(peer2, peer1);
            }
        } else if (evt.getType().equals("publish")) {
            int peer2 = evt.getParam(1);
            int document = evt.getParam(2);
            if (!this.isPeerOnline(peer2)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer2);
                this.addPeer(peer2);
            }
            if (!this.isDocumentPublished(document)) {
                this.addDocument(document, peer2);
            }
        } else if (evt.getType().equals("remove")) {
            int peer3 = evt.getParam(1);
            int document = evt.getParam(2);
            if (!this.isPeerOnline(peer3)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer3);
                this.addPeer(peer3);
            }
            if (this.isDocumentPublished(document)) {
                this.removeDocument(document, peer3);
            }
        } else if (evt.getType().equals("linkdocument")) {
            int doc1 = evt.getParam(1);
            int doc2 = evt.getParam(2);
            if (this.isDocumentPublished(doc1) && this.isDocumentPublished(doc2)) {
                this.connectDocuments(doc1, doc2);
            }
        } else if (evt.getType().equals("delinkdocument")) {
            int doc1 = evt.getParam(1);
            int doc2 = evt.getParam(2);
            if (this.isDocumentPublished(doc1) && this.isDocumentPublished(doc2)) {
                this.disconnectDocuments(doc1, doc2);
            }
        } else if (evt.getType().endsWith("query")) {
            int peer4 = evt.getParam(1);
            if (!this.isPeerOnline(peer4)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer4);
                this.addPeer(peer4);
            }
        } else if (evt.getType().endsWith("queryhit")) {
            int peer5 = evt.getParam(1);
            int document = evt.getParam(2);
            if (!this.isPeerOnline(peer5)) {
                P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer5);
                this.addPeer(peer5);
            }
            if (!this.isDocumentPublished(document)) {
                P2PNetworkGraph.addDocumentPublish(events, evt.getTime() - 100L, peer5, document);
                this.addDocument(document, peer5);
            }
        } else if (evt.getType().endsWith("queryreachespeer") && !this.isPeerOnline(peer = evt.getParam(1))) {
            P2PNetworkGraph.addPeerOnlineEvent(events, evt.getTime() - 100L, peer);
            this.addPeer(peer);
        }
    }

    private static void addPeerOnlineEvent(List<LogEvent> events, long timeToAddEvent, int peerNumber) {
        try {
            LogEvent eventToAdd = new LogEvent(timeToAddEvent, "online", peerNumber, 0, 0);
            P2PNetworkGraph.addEventAtProperTime(eventToAdd, events);
        }
        catch (Exception e) {
            System.out.println("Error in adding peer online event");
            e.printStackTrace();
        }
    }

    private static void addDocumentPublish(List<LogEvent> events, long timeToAddEvent, int peerNumber, int documentNumber) {
        try {
            LogEvent eventToAdd = new LogEvent(timeToAddEvent, "publish", peerNumber, documentNumber, 0);
            P2PNetworkGraph.addEventAtProperTime(eventToAdd, events);
        }
        catch (Exception e) {
            System.out.println("Error in adding document publish event");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEventAtProperTime(LogEvent eventToAdd, List<LogEvent> events) {
        List<LogEvent> list = events;
        synchronized (list) {
            if (events.isEmpty()) {
                events.add(0, eventToAdd);
            } else {
                ListIterator<LogEvent> li = events.listIterator(events.size());
                int index = events.size();
                while (li.hasPrevious()) {
                    LogEvent evt = li.previous();
                    if (evt.getTime() < eventToAdd.getTime() || index == 0) {
                        events.add(index, eventToAdd);
                        break;
                    }
                    --index;
                }
            }
        }
    }
}

