/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph;

import java.util.LinkedList;
import java.util.List;
import spiderweb.graph.P2PVertex;

public class PeerVertex
extends P2PVertex {
    private List<Integer> outgoingQueries = new LinkedList<Integer>();
    private List<Integer> incomingQueries = new LinkedList<Integer>();
    private String name;

    public PeerVertex(Integer key) {
        super(key);
        this.name = "P" + super.toString();
    }

    public PeerVertex(P2PVertex vertex) {
        super(vertex);
        if (vertex.getClass().equals(PeerVertex.class)) {
            PeerVertex pv = (PeerVertex)vertex;
            for (Integer i : pv.outgoingQueries) {
                this.outgoingQueries.add(new Integer(i));
            }
            for (Integer i : pv.incomingQueries) {
                this.incomingQueries.add(new Integer(i));
            }
        }
    }

    public boolean query(int queryMessageID) {
        return this.outgoingQueries.add(new Integer(queryMessageID));
    }

    public boolean endQuery(int queryMessageID) {
        return this.outgoingQueries.remove(new Integer(queryMessageID));
    }

    public boolean receiveQuery(int queryMessageID) {
        return this.incomingQueries.add(new Integer(queryMessageID));
    }

    public boolean endReceivedQuery(int queryMessageID) {
        return this.incomingQueries.remove(new Integer(queryMessageID));
    }

    public boolean hasOutgoingQueries() {
        return !this.outgoingQueries.isEmpty();
    }

    public boolean hasIncomingQueries() {
        return !this.incomingQueries.isEmpty();
    }

    public boolean hasOutgoingQuery(Integer queryMessageID) {
        return this.outgoingQueries.contains(queryMessageID);
    }

    public boolean hasIncomingQuery(Integer queryMessageID) {
        return this.incomingQueries.contains(queryMessageID);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

