/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph.savingandloading;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.graph.savingandloading.ExtensionFileFilter;
import spiderweb.graph.savingandloading.ProgressAdapter;

public class DocumentGraphLoader
extends ProgressAdapter {
    private P2PNetworkGraph documentGraph = new P2PNetworkGraph();

    public ReferencedNetworkGraph getGraph() {
        return new ReferencedNetworkGraph(this.documentGraph, this.documentGraph);
    }

    public List<LogEvent> getLogList() {
        ArrayList<LogEvent> logs = new ArrayList<LogEvent>();
        logs.add(LogEvent.getStartEvent());
        logs.add(LogEvent.getEndEvent((LogEvent)logs.get(0)));
        return logs;
    }

    public boolean doLoad() {
        String[] acceptedExtensions = new String[]{"doclink"};
        File file = DocumentGraphLoader.chooseLoadFile(".doclink Files", acceptedExtensions);
        if (file != null) {
            try {
                int totalLines = DocumentGraphLoader.countLines(file);
                this.graphBuilder(new BufferedReader(new FileReader(file)), totalLines);
                this.taskComplete();
                return true;
            }
            catch (Exception e) {
                this.taskComplete();
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Failure", 0);
            }
        }
        return false;
    }

    private void graphBuilder(BufferedReader linksDoc, int totalLines) {
        try {
            String str;
            int lineCount = 0;
            int edgeCount = 0;
            this.taskStarted(totalLines, "Link Document");
            while ((str = linksDoc.readLine()) != null) {
                String[] docs = str.split("\\s+");
                String firstDoc = docs[0].substring(0, docs[0].length() - 1);
                int documentToLink = Integer.parseInt(firstDoc);
                DocumentVertex docOne = new DocumentVertex(documentToLink);
                if (!this.documentGraph.containsVertex(docOne)) {
                    this.documentGraph.addVertex(docOne);
                }
                int i = 1;
                while (i < docs.length) {
                    int otherDocument = Integer.parseInt(docs[i]);
                    DocumentVertex docTwo = new DocumentVertex(otherDocument);
                    if (!this.documentGraph.containsVertex(docTwo)) {
                        this.documentGraph.addVertex(docTwo);
                    }
                    if (!this.documentGraph.areDocumentsConnected(documentToLink, otherDocument)) {
                        this.documentGraph.addEdge(new P2PConnection(40, edgeCount++), docOne, docTwo);
                    }
                    ++i;
                }
                this.progress(++lineCount);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int countLines(File fileToCount) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileToCount));
        try {
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                int i = 0;
                while (i < readChars) {
                    if (c[i] == 10) {
                        ++count;
                    }
                    ++i;
                }
            }
            int n = count;
            return n;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static File chooseLoadFile(String filterDescription, String[] acceptedExtensions) {
        JFileChooser fileNamer = new JFileChooser();
        fileNamer.setFileFilter(new ExtensionFileFilter(filterDescription, acceptedExtensions));
        int returnVal = fileNamer.showOpenDialog(null);
        if (returnVal == 0) {
            String[] stringArray = acceptedExtensions;
            int n = acceptedExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileNamer.getSelectedFile().getAbsolutePath().endsWith(extension)) {
                    return fileNamer.getSelectedFile();
                }
                ++n2;
            }
            JOptionPane.showMessageDialog(null, "Error: Incorrect extension.", "Error", 0);
            return null;
        }
        if (returnVal == -1) {
            JOptionPane.showMessageDialog(null, "Error: Could not load file.", "Error", 0);
        }
        return null;
    }
}

