/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph.savingandloading;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.graph.savingandloading.ProgressAdapter;

public class LogEventListBuilder
extends ProgressAdapter {
    private P2PNetworkGraph fullGraph;
    private ArrayList<LogEvent> logEvents;

    public LogEventListBuilder(P2PNetworkGraph fullGraph) {
        this.fullGraph = fullGraph;
    }

    public LogEventListBuilder() {
        this(new P2PNetworkGraph());
    }

    public ReferencedNetworkGraph getGraph() {
        return new ReferencedNetworkGraph(this.fullGraph);
    }

    public List<LogEvent> createList(BufferedReader logFile) {
        try {
            String str;
            P2PNetworkGraph tempGraph = new P2PNetworkGraph();
            ArrayList<LogEvent> colouringEvents = new ArrayList<LogEvent>();
            ArrayList<P2PVertex> queryPeers = new ArrayList<P2PVertex>();
            HashMap<String, List<String>> peerMap = new HashMap<String, List<String>>();
            int totalLines = Integer.parseInt(logFile.readLine());
            this.logEvents = new ArrayList(totalLines + 2);
            int lineCount = 0;
            this.taskStarted(totalLines, "LogEvents");
            this.logEvents.add(LogEvent.getStartEvent());
            while ((str = logFile.readLine()) != null) {
                this.progress(++lineCount);
                LogEvent gev = new LogEvent(str);
                if (gev.isConstructing()) {
                    this.fullGraph.graphEvent(gev);
                }
                this.createColouringEvents(gev, colouringEvents, queryPeers, tempGraph);
                this.createOfflineEvents(gev, peerMap);
                this.logEvents.add(gev);
                this.createBackOnlineEvents(gev, peerMap, tempGraph);
                if (!gev.isStructural()) continue;
                tempGraph.graphEvent(gev, true, this.fullGraph);
            }
            for (LogEvent leftOver : colouringEvents) {
                this.logEvents.add(leftOver);
            }
            this.logEvents.add(LogEvent.getEndEvent(this.logEvents.get(this.logEvents.size() - 1)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.logEvents;
    }

    private void createBackOnlineEvents(LogEvent gev, HashMap<String, List<String>> peerMap, P2PNetworkGraph tempGraph) {
        if (gev.getType().equals("online") && peerMap.containsKey(Integer.toString(gev.getParam(1)))) {
            for (String evt : peerMap.get(Integer.toString(gev.getParam(1)))) {
                LogEvent event = new LogEvent(String.valueOf(gev.getTime()) + evt);
                if (event.getType().equals("publish")) {
                    this.logEvents.add(event);
                    continue;
                }
                if (!event.getType().equals("connect") || !tempGraph.containsVertex(new PeerVertex(event.getParam(2)))) continue;
                this.logEvents.add(event);
            }
            peerMap.remove(Integer.toString(gev.getParam(1)));
        }
    }

    private void createOfflineEvents(LogEvent gev, HashMap<String, List<String>> peerMap) {
        if (gev.getType().equals("offline")) {
            PeerVertex peerGoingOffline = new PeerVertex(gev.getParam(1));
            if (!peerMap.containsKey(Integer.toString(gev.getParam(1)))) {
                peerMap.put(Integer.toString(gev.getParam(1)), new ArrayList());
            }
            for (P2PConnection edge : this.fullGraph.getIncidentEdges(peerGoingOffline)) {
                P2PVertex opposite = (P2PVertex)this.fullGraph.getOpposite(peerGoingOffline, edge);
                if (opposite.getClass().equals(PeerDocumentVertex.class)) {
                    peerMap.get(Integer.toString(gev.getParam(1))).add(":publish:" + gev.getParam(1) + ":" + ((PeerDocumentVertex)opposite).getDocumentNumber());
                    this.logEvents.add(new LogEvent(gev.getTime(), "remove", gev.getParam(1), ((PeerDocumentVertex)opposite).getDocumentNumber(), 0));
                    continue;
                }
                if (!opposite.getClass().equals(PeerVertex.class)) continue;
                peerMap.get(Integer.toString(gev.getParam(1))).add(":connect:" + gev.getParam(1) + ":" + ((PeerVertex)opposite).getKey());
            }
        }
    }

    private void createColouringEvents(LogEvent gev, List<LogEvent> colouringEvents, List<P2PVertex> queryPeers, P2PNetworkGraph tempGraph) {
        String eventType = gev.getType();
        if (eventType.equals("query") || eventType.equals("queryhit")) {
            colouringEvents.add(LogEvent.createOpposingLogEvent(gev, 2000));
            if (eventType.equals("query")) {
                queryPeers.add(new PeerVertex(gev.getParam(1)));
            }
        } else if (eventType.equals("queryreachespeer")) {
            colouringEvents.add(LogEvent.createOpposingLogEvent(gev, 750));
            PeerVertex queriedPeer = new PeerVertex(gev.getParam(1));
            for (P2PVertex querySender : queryPeers) {
                if (tempGraph.findEdge(querySender, queriedPeer) == null) continue;
                LogEvent ev = new LogEvent(gev.getTime() + 1L, "queryedge", querySender.getKey(), queriedPeer.getKey(), 0);
                colouringEvents.add(ev);
                colouringEvents.add(LogEvent.createOpposingLogEvent(ev, 750));
                break;
            }
            queryPeers.add(queriedPeer);
        }
        Collections.sort(colouringEvents);
        Iterator<LogEvent> iter = colouringEvents.iterator();
        while (iter.hasNext()) {
            LogEvent event = iter.next();
            if (event.getTime() >= gev.getTime()) break;
            this.logEvents.add(event);
            iter.remove();
        }
    }
}

