/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph.savingandloading;

import edu.uci.ics.jung.graph.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.graph.savingandloading.ExtensionFileFilter;
import spiderweb.graph.savingandloading.LoadingListener;
import spiderweb.graph.savingandloading.LogEventListBuilder;
import spiderweb.graph.savingandloading.ProgressAdapter;
import spiderweb.networking.HTTPClient;

public class P2PNetworkGraphLoader
extends ProgressAdapter {
    private List<LogEvent> logList = new ArrayList<LogEvent>();
    private ReferencedNetworkGraph graph = new ReferencedNetworkGraph();

    public boolean doLoad() {
        String[] acceptedExtensions = new String[]{"xml", "txt"};
        File file = P2PNetworkGraphLoader.chooseLoadFile(".xml and .txt Files", acceptedExtensions);
        if (file != null) {
            if (file.getAbsolutePath().endsWith(".txt")) {
                try {
                    this.taskStarted(1, "Log Files");
                    LogEventListBuilder logBuilder = new LogEventListBuilder();
                    for (LoadingListener l : this.progressListeners) {
                        logBuilder.addProgressListener(l);
                    }
                    this.logList = logBuilder.createList(new BufferedReader(new FileReader(file)));
                    this.graph = logBuilder.getGraph();
                    this.taskComplete();
                    return true;
                }
                catch (Exception e) {
                    this.taskComplete();
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Failure", 0);
                }
            } else if (file.getAbsolutePath().endsWith(".xml")) {
                try {
                    SAXBuilder builder = new SAXBuilder();
                    Document networkDoc = builder.build(file);
                    this.graphBuilder(networkDoc);
                    this.logList.add(0, LogEvent.getStartEvent());
                    this.logList.add(LogEvent.getEndEvent(this.logList.get(this.logList.size() - 1)));
                    return true;
                }
                catch (Exception e) {
                    this.taskComplete();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Failure", 0);
                }
            }
        }
        return false;
    }

    private void buildGraphVertices(Element nodeMap, P2PNetworkGraph startGraph) {
        int counter = 0;
        this.taskStarted(nodeMap.getChildren().size(), "Vertices");
        for (Object o : nodeMap.getChildren()) {
            int key;
            Element elem = (Element)o;
            String type = elem.getAttribute("type").getValue();
            if (type.equals("PeerVertex")) {
                key = Integer.parseInt(elem.getChild("key").getText());
                this.graph.getFullGraph().addVertex(new PeerVertex(key));
                startGraph.addVertex(new PeerVertex(key));
            } else if (type.equals("DocumentVertex")) {
                key = Integer.parseInt(elem.getChild("key").getText());
                this.graph.getFullGraph().addVertex(new DocumentVertex(key));
                startGraph.addVertex(new DocumentVertex(key));
            }
            this.progress(++counter);
        }
    }

    private int buildGraphEdges(Element edgeMap, P2PNetworkGraph startGraph) {
        int counter = 0;
        int edgeCounter = 0;
        this.taskStarted(edgeMap.getChildren().size(), "Edges");
        for (Object o : edgeMap.getChildren()) {
            int v2Key;
            int v1Key;
            Element elem = (Element)o;
            String type = elem.getAttribute("type").getValue();
            if (type.equals("PeerToPeer")) {
                v1Key = Integer.parseInt(elem.getChild("v1").getText());
                v2Key = Integer.parseInt(elem.getChild("v2").getText());
                P2PVertex peer1 = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(v1Key));
                P2PVertex peer2 = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(v2Key));
                startGraph.addEdge(new P2PConnection(0, edgeCounter), peer1, peer2);
                this.graph.getFullGraph().addEdge(new P2PConnection(0, edgeCounter), peer1, peer2);
                ++edgeCounter;
            } else if (type.equals("PeerToDocument")) {
                v1Key = Integer.parseInt(elem.getChild("v1").getText());
                v2Key = Integer.parseInt(elem.getChild("v2").getText()) % 1000;
                P2PVertex document = this.graph.getFullGraph().getVertexInGraph(new DocumentVertex(v2Key));
                P2PVertex peer = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(v1Key));
                Pair pair = new Pair((Object)peer, (Object)document);
                startGraph.addEdge(new P2PConnection(10, edgeCounter), pair);
                this.graph.getFullGraph().addEdge(new P2PConnection(10, edgeCounter), pair);
                ++edgeCounter;
                PeerDocumentVertex pdv = new PeerDocumentVertex(v1Key, v2Key);
                this.graph.getFullGraph().addVertex(pdv);
                startGraph.addVertex(pdv);
                startGraph.addEdge(new P2PConnection(20, edgeCounter), peer, pdv);
                this.graph.getFullGraph().addEdge(new P2PConnection(20, edgeCounter), peer, pdv);
                startGraph.addEdge(new P2PConnection(30, ++edgeCounter), pdv, document);
                this.graph.getFullGraph().addEdge(new P2PConnection(30, edgeCounter), pdv, document);
                ++edgeCounter;
            }
            this.progress(++counter);
        }
        return edgeCounter;
    }

    private void buildLogEvents(Element logElem, P2PNetworkGraph startGraph, int edgeCounter) {
        if (logElem != null) {
            this.taskStarted(logElem.getChildren().size(), "Events");
            int counter = 0;
            for (Object o : logElem.getChildren()) {
                LogEvent evt;
                Element event = (Element)o;
                String type = event.getAttribute("type").getValue();
                if (type.equals("start") || type.equals("end")) continue;
                long timeDifference = Integer.parseInt(event.getChildText("timedifference"));
                int paramOne = Integer.parseInt(event.getChildText("param1"));
                int paramTwo = 0;
                int paramThree = 0;
                if (LogEvent.typeHasParamTwo(type)) {
                    paramTwo = Integer.parseInt(event.getChildText("param2"));
                }
                if (LogEvent.typeHasParamThree(type)) {
                    paramThree = Integer.parseInt(event.getChildText("param3"));
                }
                if ((evt = new LogEvent(timeDifference, type, paramOne, paramTwo, paramThree)).isConstructing()) {
                    if (evt.getType().equals("online")) {
                        this.graph.getFullGraph().addVertex(new PeerVertex(evt.getParam(1)));
                    } else if (evt.getType().equals("connect")) {
                        P2PVertex from = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(1)));
                        P2PVertex to = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(2)));
                        if (this.graph.getFullGraph().findEdge(to, from) == null) {
                            P2PConnection edgeOne = new P2PConnection(0, edgeCounter);
                            P2PConnection edgeTwo = new P2PConnection(0, ++edgeCounter);
                            ++edgeCounter;
                            this.graph.getFullGraph().addEdge(edgeOne, from, to);
                            this.graph.getFullGraph().addEdge(edgeTwo, to, from);
                        }
                    } else if (evt.getType().equals("publish")) {
                        P2PVertex document = new DocumentVertex(evt.getParam(2));
                        PeerDocumentVertex peerDocument = new PeerDocumentVertex(evt.getParam(1), evt.getParam(2));
                        P2PVertex peer = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(1)));
                        if (!this.graph.getFullGraph().containsVertex(document)) {
                            this.graph.getFullGraph().addVertex(document);
                        } else {
                            document = this.graph.getFullGraph().getVertexInGraph(document);
                        }
                        this.graph.getFullGraph().addVertex(peerDocument);
                        if (this.graph.getFullGraph().findEdge(peer, document) == null) {
                            this.graph.getFullGraph().addEdge(new P2PConnection(10, edgeCounter), peer, document);
                            ++edgeCounter;
                        }
                        if (this.graph.getFullGraph().findEdge(peer, peerDocument) == null) {
                            this.graph.getFullGraph().addEdge(new P2PConnection(20, edgeCounter), peer, peerDocument);
                            ++edgeCounter;
                        }
                        if (this.graph.getFullGraph().findEdge(peerDocument, document) == null) {
                            this.graph.getFullGraph().addEdge(new P2PConnection(30, edgeCounter), peerDocument, document);
                            ++edgeCounter;
                        }
                    } else if (evt.getType().equals("linkdocument")) {
                        P2PVertex documentOne = this.graph.getFullGraph().getVertexInGraph(new DocumentVertex(evt.getParam(1)));
                        P2PVertex documentTwo = this.graph.getFullGraph().getVertexInGraph(new DocumentVertex(evt.getParam(2)));
                        if (this.graph.getFullGraph().findEdge(documentOne, documentTwo) == null) {
                            this.graph.getFullGraph().addEdge(new P2PConnection(40, edgeCounter), documentOne, documentTwo);
                            ++edgeCounter;
                        }
                    }
                }
                this.logList.add(evt);
                this.progress(++counter);
            }
        }
    }

    private void graphBuilder(Document networkDoc) {
        if (networkDoc.getRootElement().getName().equals("network")) {
            int edgeCounter = 0;
            P2PNetworkGraph startGraph = new P2PNetworkGraph();
            Element networkElem = networkDoc.getRootElement();
            Element graphElem = networkElem.getChild("graph");
            if (graphElem != null) {
                this.taskStarted(1, "Start Building Graph");
                this.buildGraphVertices(graphElem.getChild("nodemap"), startGraph);
                edgeCounter = this.buildGraphEdges(graphElem.getChild("edgemap"), startGraph);
            }
            this.buildLogEvents(networkElem.getChild("logevents"), startGraph, edgeCounter);
            this.graph.setDynamicGraph(startGraph);
            this.taskComplete();
        }
    }

    private void addEventsToGraph(Document networkDoc, long timeOffset) {
        if (networkDoc.getRootElement().getName().equals("network")) {
            int edgeCounter = this.graph.getFullGraph().getEdgeCount();
            Element networkElem = networkDoc.getRootElement();
            Element logElem = networkElem.getChild("logevents");
            if (logElem != null) {
                this.taskStarted(logElem.getChildren().size(), "Events");
                for (Object o : logElem.getChildren()) {
                    LogEvent evt;
                    Element event = (Element)o;
                    String type = event.getAttribute("type").getValue();
                    if (type.equals("start") || type.equals("end")) continue;
                    long timeDifference = Integer.parseInt(event.getChildText("timedifference"));
                    long eventTime = timeDifference + timeOffset;
                    int paramOne = Integer.parseInt(event.getChildText("param1"));
                    int paramTwo = 0;
                    int paramThree = 0;
                    if (LogEvent.typeHasParamTwo(type)) {
                        paramTwo = Integer.parseInt(event.getChildText("param2"));
                    }
                    if (LogEvent.typeHasParamThree(type)) {
                        paramThree = Integer.parseInt(event.getChildText("param3"));
                    }
                    if ((evt = new LogEvent(eventTime, type, paramOne, paramTwo, paramThree)).isConstructing()) {
                        if (evt.getType().equals("online")) {
                            this.graph.getFullGraph().addVertex(new PeerVertex(evt.getParam(1)));
                        } else if (evt.getType().equals("connect")) {
                            P2PVertex from = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(1)));
                            P2PVertex to = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(2)));
                            if (this.graph.getFullGraph().findEdge(to, from) == null) {
                                P2PConnection edgeOne = new P2PConnection(0, edgeCounter);
                                P2PConnection edgeTwo = new P2PConnection(0, ++edgeCounter);
                                ++edgeCounter;
                                this.graph.getFullGraph().addEdge(edgeOne, from, to);
                                this.graph.getFullGraph().addEdge(edgeTwo, to, from);
                            }
                        } else if (evt.getType().equals("publish")) {
                            P2PVertex document = new DocumentVertex(evt.getParam(2));
                            PeerDocumentVertex peerDocument = new PeerDocumentVertex(evt.getParam(1), evt.getParam(2));
                            P2PVertex peer = this.graph.getFullGraph().getVertexInGraph(new PeerVertex(evt.getParam(1)));
                            if (!this.graph.getFullGraph().containsVertex(document)) {
                                this.graph.getFullGraph().addVertex(document);
                            } else {
                                document = this.graph.getFullGraph().getVertexInGraph(document);
                            }
                            this.graph.getFullGraph().addVertex(peerDocument);
                            if (this.graph.getFullGraph().findEdge(peer, document) == null) {
                                this.graph.getFullGraph().addEdge(new P2PConnection(10, edgeCounter), peer, document);
                                ++edgeCounter;
                            }
                            if (this.graph.getFullGraph().findEdge(peer, peerDocument) == null) {
                                this.graph.getFullGraph().addEdge(new P2PConnection(20, edgeCounter), peer, peerDocument);
                                ++edgeCounter;
                            }
                            if (this.graph.getFullGraph().findEdge(peerDocument, document) == null) {
                                this.graph.getFullGraph().addEdge(new P2PConnection(30, edgeCounter), peerDocument, document);
                                ++edgeCounter;
                            }
                        } else if (evt.getType().equals("linkdocument")) {
                            P2PVertex documentOne = this.graph.getFullGraph().getVertexInGraph(new DocumentVertex(evt.getParam(1)));
                            P2PVertex documentTwo = this.graph.getFullGraph().getVertexInGraph(new DocumentVertex(evt.getParam(2)));
                            if (this.graph.getFullGraph().findEdge(documentOne, documentTwo) == null) {
                                this.graph.getFullGraph().addEdge(new P2PConnection(40, edgeCounter), documentOne, documentTwo);
                                ++edgeCounter;
                            }
                        }
                    }
                    this.logList.add(evt);
                }
            }
        }
    }

    public List<LogEvent> getLogList() {
        return this.logList;
    }

    public ReferencedNetworkGraph getGraph() {
        return this.graph;
    }

    public static File chooseLoadFile(String filterDescription, String[] acceptedExtensions) {
        JFileChooser fileNamer = new JFileChooser();
        fileNamer.setFileFilter(new ExtensionFileFilter(filterDescription, acceptedExtensions));
        int returnVal = fileNamer.showOpenDialog(null);
        if (returnVal == 0) {
            String[] stringArray = acceptedExtensions;
            int n = acceptedExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileNamer.getSelectedFile().getAbsolutePath().endsWith(extension)) {
                    return fileNamer.getSelectedFile();
                }
                ++n2;
            }
            JOptionPane.showMessageDialog(null, "Error: Incorrect extension.", "Error", 0);
            return null;
        }
        if (returnVal == -1) {
            JOptionPane.showMessageDialog(null, "Error: Could not load file.", "Error", 0);
        }
        return null;
    }

    public static P2PNetworkGraphLoader buildGraph(InputStream inStream, HTTPClient client) throws JDOMException, IOException {
        SAXBuilder parser = new SAXBuilder();
        Document doc = parser.build(inStream);
        long currentTime = doc.getRootElement().getAttribute("currentTime").getLongValue();
        client.setZeroTime(currentTime);
        P2PNetworkGraphLoader loader = new P2PNetworkGraphLoader();
        loader.logList.add(0, LogEvent.getStartEvent());
        loader.logList.add(LogEvent.getEndEvent(loader.logList.get(loader.logList.size() - 1)));
        loader.graphBuilder(doc);
        return loader;
    }

    public static List<LogEvent> buildLogs(InputStream inStream, HTTPClient client, ReferencedNetworkGraph graph) throws JDOMException, IOException {
        SAXBuilder parser = new SAXBuilder();
        Document doc = parser.build(inStream);
        long requestTime = doc.getRootElement().getAttribute("requestTime").getIntValue();
        long currentTime = doc.getRootElement().getAttribute("currentTime").getLongValue();
        client.setLatestTime(currentTime);
        P2PNetworkGraphLoader loader = new P2PNetworkGraphLoader();
        loader.graph = graph;
        loader.addEventsToGraph(doc, requestTime);
        return loader.logList;
    }
}

