/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph.savingandloading;

import edu.uci.ics.jung.graph.util.Pair;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.LogEvent;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PNetworkGraph;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.graph.savingandloading.ExtensionFileFilter;
import spiderweb.graph.savingandloading.ProgressAdapter;

public class P2PNetworkGraphSaver
extends ProgressAdapter {
    private long currentTime;
    private List<LogEvent> logList;
    private P2PNetworkGraph graph;

    public P2PNetworkGraphSaver(P2PNetworkGraph graph) {
        this(graph, null, 0L);
    }

    public P2PNetworkGraphSaver(List<LogEvent> events, long currentTime) {
        this(null, events, currentTime);
    }

    public P2PNetworkGraphSaver(P2PNetworkGraph graph, List<LogEvent> events, long currentTime) {
        this.currentTime = currentTime;
        this.logList = events;
        this.graph = graph;
    }

    public void doSave() {
        Thread saverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String path = P2PNetworkGraphSaver.chooseSaveFile().getAbsolutePath();
                if (path != null) {
                    Document doc = P2PNetworkGraphSaver.this.buildDoc();
                    if (P2PNetworkGraphSaver.this.outputDocumentToFile(doc, path)) {
                        JOptionPane.showMessageDialog(null, "Success: File Saved", "Success", 1);
                    }
                    P2PNetworkGraphSaver.this.taskComplete();
                }
            }
        });
        saverThread.start();
    }

    public static String saveGraphForWeb(P2PNetworkGraph graph, long simulationTime) {
        P2PNetworkGraphSaver saver = new P2PNetworkGraphSaver(graph);
        Document doc = saver.buildDoc();
        doc.getRootElement().setAttribute("currentTime", Long.toString(simulationTime));
        XMLOutputter outputter = new XMLOutputter();
        try {
            return outputter.outputString(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<network currentTime=\"" + simulationTime + "\"/>";
        }
    }

    public static String saveEventsForWeb(List<LogEvent> events, long requestTime, long simulationTime) {
        if (!events.isEmpty()) {
            try {
                P2PNetworkGraphSaver saver = new P2PNetworkGraphSaver(events, requestTime);
                Document doc = saver.buildDoc();
                doc.getRootElement().setAttribute("requestTime", Long.toString(requestTime));
                doc.getRootElement().setAttribute("currentTime", Long.toString(simulationTime));
                XMLOutputter outputter = new XMLOutputter();
                return outputter.outputString(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<network requestTime=\"" + requestTime + "\" currentTime=\"" + simulationTime + "\"/>";
    }

    private Document buildDoc() {
        Element networkElement = new Element("network");
        if (this.graph != null && this.graph.getVertexCount() != 0) {
            Element key;
            Element node;
            LinkedList<PeerVertex> peers = new LinkedList<PeerVertex>();
            LinkedList<DocumentVertex> documents = new LinkedList<DocumentVertex>();
            LinkedList<P2PConnection> edges = new LinkedList<P2PConnection>(this.graph.getEdges());
            int count = 0;
            this.taskStarted(this.graph.getVertices().size(), "Compiling Vertex Lists");
            for (P2PVertex vertex : this.graph.getVertices()) {
                if (vertex.getClass().equals(PeerVertex.class)) {
                    peers.addLast((PeerVertex)vertex);
                } else if (vertex.getClass().equals(DocumentVertex.class)) {
                    documents.addLast((DocumentVertex)vertex);
                }
                this.progress(count);
                ++count;
            }
            Element graphElement = new Element("graph");
            graphElement.addContent((Content)new Comment("Description of a P2PNetworkGraph"));
            Element nodemap = new Element("nodemap");
            count = 0;
            this.taskStarted(peers.size(), "Peer Vertices");
            for (PeerVertex peer : peers) {
                node = new Element("node");
                node.setAttribute("type", "PeerVertex");
                key = new Element("key");
                key.addContent(Integer.toString(peer.getKey()));
                node.addContent((Content)key);
                nodemap.addContent((Content)node);
                this.progress(count);
                ++count;
            }
            count = 0;
            this.taskStarted(documents.size(), "Document Vertices");
            for (DocumentVertex doc : documents) {
                node = new Element("node");
                node.setAttribute("type", "DocumentVertex");
                key = new Element("key");
                key.addContent(Integer.toString(doc.getDocumentNumber()));
                node.addContent((Content)key);
                nodemap.addContent((Content)node);
                this.progress(count);
                ++count;
            }
            graphElement.addContent((Content)nodemap);
            Element edgemap = new Element("edgemap");
            count = 0;
            this.taskStarted(edges.size(), "Edges");
            block8: for (P2PConnection e : edges) {
                Element edge = new Element("edge");
                switch (e.getType()) {
                    case 0: {
                        edge.setAttribute("type", "PeerToPeer");
                        break;
                    }
                    case 10: {
                        edge.setAttribute("type", "PeerToDocument");
                        break;
                    }
                    case 40: {
                        edge.setAttribute("type", "DocumentToDocument");
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                Pair ends = this.graph.getEndpoints(e);
                String key1 = Integer.toString(((P2PVertex)ends.getFirst()).getKey());
                String key2 = Integer.toString(((P2PVertex)ends.getSecond()).getKey());
                Element v1 = new Element("v1");
                v1.addContent(key1);
                edge.addContent((Content)v1);
                Element v2 = new Element("v2");
                v2.addContent(key2);
                edge.addContent((Content)v2);
                edgemap.addContent((Content)edge);
                this.progress(count);
                ++count;
            }
            graphElement.addContent((Content)edgemap);
            networkElement.addContent((Content)graphElement);
        }
        if (this.logList != null) {
            Element logEventsElement = new Element("logevents");
            int count = 0;
            this.taskStarted(this.logList.size(), "LogEvents");
            for (LogEvent ev : this.logList) {
                Element event = new Element("event");
                event.setAttribute("type", ev.getType());
                Element timeDifference = new Element("timedifference");
                timeDifference.addContent(Integer.toString((int)(ev.getTime() - this.currentTime)));
                event.addContent((Content)timeDifference);
                Element paramOne = new Element("param1");
                paramOne.addContent(Integer.toString(ev.getParam(1)));
                event.addContent((Content)paramOne);
                if (ev.hasParamTwo()) {
                    Element paramTwo = new Element("param2");
                    paramTwo.addContent(Integer.toString(ev.getParam(2)));
                    event.addContent((Content)paramTwo);
                }
                if (ev.hasParamThree()) {
                    Element paramThree = new Element("param3");
                    paramThree.addContent(Integer.toString(ev.getParam(3)));
                    event.addContent((Content)paramThree);
                }
                logEventsElement.addContent((Content)event);
                this.progress(count);
                ++count;
            }
            networkElement.addContent((Content)logEventsElement);
        }
        return new Document(networkElement);
    }

    private boolean outputDocumentToFile(Document myDocument, String path) {
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            FileWriter writer = new FileWriter(path);
            outputter.output(myDocument, (Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Failure", 0);
            return false;
        }
        return true;
    }

    public static File chooseSaveFile() {
        JFileChooser fileNamer = new JFileChooser();
        fileNamer.setFileFilter(new ExtensionFileFilter(".xml Files", "xml"));
        int returnVal = fileNamer.showSaveDialog(null);
        if (returnVal == 0) {
            if (fileNamer.getSelectedFile().getAbsolutePath().endsWith(".xml")) {
                return fileNamer.getSelectedFile();
            }
            return new File(String.valueOf(fileNamer.getSelectedFile().getAbsolutePath()) + ".xml");
        }
        if (returnVal == 1 || returnVal == -1) {
            return null;
        }
        return null;
    }
}

