/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.graph.savingandloading;

import java.util.LinkedList;
import spiderweb.graph.savingandloading.LoadingListener;

public abstract class ProgressAdapter {
    protected LinkedList<LoadingListener> progressListeners = new LinkedList();

    public boolean addProgressListener(LoadingListener listenerToAdd) {
        return this.progressListeners.add(listenerToAdd);
    }

    public boolean removeProgressListener(LoadingListener listenerToRemove) {
        return this.progressListeners.remove(listenerToRemove);
    }

    protected void taskStarted(int numberLines, String whatIsLoading) {
        for (LoadingListener l : this.progressListeners) {
            l.loadingStarted(numberLines, whatIsLoading);
        }
    }

    protected void progress(int progress) {
        for (LoadingListener l : this.progressListeners) {
            l.loadingProgress(progress);
        }
    }

    protected void taskComplete() {
        for (LoadingListener l : this.progressListeners) {
            l.loadingComplete();
        }
    }
}

