/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.networking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;

public class ConnectDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4050586871897666736L;
    public static final String CANCELED = "CANCELED";
    private JTextField serverName;
    private JTextField serverPort;
    private JLabel serverURL;
    private String returnText = "CANCELED";

    private ConnectDialog() {
        this.init();
    }

    private ConnectDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    private ConnectDialog(Frame owner) {
        super(owner);
        this.init();
    }

    private ConnectDialog(Window owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Input Server Address");
        this.setBounds(100, 100, 550, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.getContentPane().add((Component)this.getAddressPane(), "Center");
        this.getContentPane().add((Component)this.getButtonPane(), "South");
        this.setURLLabel();
    }

    public static String getConnectURL() {
        ConnectDialog cd = new ConnectDialog();
        cd.setVisible(true);
        return cd.returnText;
    }

    private JPanel getAddressPane() {
        JPanel addressPane = new JPanel();
        addressPane.setBorder(BorderFactory.createTitledBorder("Connect to:"));
        addressPane.setLayout(new GridLayout(3, 1));
        URLListener urlListener = new URLListener();
        this.serverName = new JTextField();
        this.serverName.setColumns(25);
        this.serverName.setText("134.117.60.66");
        this.serverName.setToolTipText("Server name to connect to");
        this.serverName.setBorder(new SoftBevelBorder(1));
        this.serverName.addKeyListener(urlListener);
        JPanel namePanel = new JPanel();
        namePanel.setBorder(BorderFactory.createTitledBorder("Server Name"));
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)this.serverName, "Center");
        addressPane.add((Component)namePanel, "Center");
        this.serverPort = new JTextField();
        this.serverPort.setText("8080");
        this.serverPort.setToolTipText("Server port to connect to");
        this.serverPort.setBorder(new SoftBevelBorder(1));
        this.serverPort.addKeyListener(urlListener);
        JPanel portPanel = new JPanel();
        portPanel.setBorder(BorderFactory.createTitledBorder("Server Port"));
        portPanel.setLayout(new BorderLayout());
        portPanel.add((Component)this.serverPort, "Center");
        addressPane.add((Component)portPanel, "Center");
        this.serverURL = new JLabel("http://");
        this.serverURL.setToolTipText("The URL to connect to");
        this.serverURL.setBorder(BorderFactory.createTitledBorder("Connect URL"));
        addressPane.add((Component)this.serverURL, "South");
        return addressPane;
    }

    private JPanel getButtonPane() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private void setURLLabel() {
        StringBuffer url = new StringBuffer("http://");
        url.append(this.serverName.getText());
        url.append(":");
        url.append(this.serverPort.getText());
        url.append("/graphServer");
        this.serverURL.setText(url.toString());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("OK".equals(ae.getActionCommand())) {
            this.returnText = this.serverURL.getText();
        }
        this.dispose();
    }

    private class URLListener
    extends KeyAdapter {
        private URLListener() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            ConnectDialog.this.setURLLabel();
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            ConnectDialog.this.setURLLabel();
        }
    }
}

