/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.networking;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import spiderweb.networking.NetworkGraphListener;

public class HTTPClient
implements ActionListener {
    private static int readTimeOut = 120000;
    private static int connectTimeOut = 10000;
    private static int sleepTime = 10000;
    private List<NetworkGraphListener> networkListeners = new LinkedList<NetworkGraphListener>();
    private String serverURL;
    private long latestTime = 0L;
    private long startingTime = 0L;
    private boolean connected = false;
    private Timer networkScheduler = new Timer(sleepTime, this);

    public HTTPClient() {
    }

    public HTTPClient(NetworkGraphListener listener) {
        this();
        this.addNetworkListener(listener);
    }

    public void startNetwork(String serverURL) {
        this.serverURL = serverURL;
        Thread starterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPClient.this.getGraph();
                    HTTPClient.this.connected = true;
                }
                catch (Exception e) {
                    HTTPClient.this.connected = false;
                    JOptionPane.showMessageDialog(null, "Could not open connection.", "Error", 0);
                }
                if (HTTPClient.this.connected) {
                    HTTPClient.this.networkScheduler.start();
                }
            }
        });
        starterThread.start();
    }

    public void closeNetwork() {
        this.connected = false;
        this.networkScheduler.stop();
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public void setZeroTime(long firstReceivedTime) {
        this.latestTime = firstReceivedTime;
        this.startingTime = firstReceivedTime;
    }

    public long getZeroTime() {
        return this.startingTime;
    }

    public void addNetworkListener(NetworkGraphListener listener) {
        this.networkListeners.add(listener);
    }

    protected void notifyIncomingGraph(InputStream inStream) {
        for (NetworkGraphListener l : this.networkListeners) {
            l.incomingGraph(inStream);
        }
    }

    protected void notifyIncomingLogEvents(InputStream inStream) {
        for (NetworkGraphListener l : this.networkListeners) {
            l.incomingLogEvents(inStream);
        }
    }

    private InputStream connect(String url) throws IOException {
        URLConnection conn = new URL(String.valueOf(this.serverURL) + url).openConnection();
        conn.setConnectTimeout(connectTimeOut);
        conn.setReadTimeout(readTimeOut);
        InputStream in = conn.getInputStream();
        return in;
    }

    private void getGraph() throws IOException {
        String url = "/getGraph";
        this.notifyIncomingGraph(this.connect(url));
    }

    private void getLogEvents() throws IOException {
        String url = "/getLogEvents?";
        url = this.addTimeOfLastResponse(url);
        InputStream inStream = this.connect(url);
        this.notifyIncomingLogEvents(inStream);
    }

    private String addTimeOfLastResponse(String url) {
        url = String.valueOf(url) + "&time=" + this.latestTime;
        return url;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.connected) {
            try {
                this.getLogEvents();
            }
            catch (IOException e) {
                this.connected = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                this.connected = false;
                e.printStackTrace();
            }
        }
    }
}

