/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.visualizer.EdgeShapeType;
import spiderweb.visualizer.VertexShapeType;
import spiderweb.visualizer.ViewChangeListener;
import spiderweb.visualizer.ViewState;
import spiderweb.visualizer.VisualOptionsPanel;
import spiderweb.visualizer.predicates.OptionsPredicate;
import spiderweb.visualizer.transformers.P2PEdgeShapeTransformer;
import spiderweb.visualizer.transformers.P2PEdgeStrokeTransformer;
import spiderweb.visualizer.transformers.P2PVertexFillPaintTransformer;
import spiderweb.visualizer.transformers.P2PVertexShapeTransformer;

public class NetworkGraphVisualizer
extends VisualizationViewer<P2PVertex, P2PConnection>
implements ViewChangeListener {
    public static final int DEFWIDTH = 1360;
    public static final int DEFHEIGHT = 768;
    private static final long serialVersionUID = 3695469692236559338L;
    private ReferencedNetworkGraph graph;
    private VisualOptionsPanel optionsPanel;
    private ViewState currentView;
    private OptionsPredicate includePredicate;

    public NetworkGraphVisualizer(Layout<P2PVertex, P2PConnection> layout, DefaultModalGraphMouse<P2PVertex, P2PConnection> gm, ReferencedNetworkGraph graph, int width, int height) {
        super(layout, new Dimension(width, height));
        this.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.graph = graph;
        this.optionsPanel = new VisualOptionsPanel();
        this.optionsPanel.addViewListener(this);
        this.includePredicate = new OptionsPredicate(graph);
        this.getRenderContext().setVertexIncludePredicate((Predicate)this.includePredicate);
        this.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.validate();
    }

    public NetworkGraphVisualizer(Layout<P2PVertex, P2PConnection> layout, DefaultModalGraphMouse<P2PVertex, P2PConnection> gm, ReferencedNetworkGraph graph) {
        this(layout, gm, graph, 1360, 768);
    }

    public static NetworkGraphVisualizer getPersonalizedVisualizer(Layout<P2PVertex, P2PConnection> layout, DefaultModalGraphMouse<P2PVertex, P2PConnection> gm, ReferencedNetworkGraph graph, int width, int height) {
        NetworkGraphVisualizer visualizer = new NetworkGraphVisualizer(layout, gm, graph, width, height);
        visualizer.currentView = ViewState.CollapsedPeerView;
        visualizer.optionsPanel.setView(visualizer.currentView);
        visualizer.optionsPanel.addPredicateListener(visualizer.includePredicate);
        visualizer.setForeground(Color.WHITE);
        visualizer.setBackground(Color.GRAY);
        return visualizer;
    }

    private void setSpecialTransformers(VertexShapeType peerShape, VertexShapeType documentShape, VertexShapeType peerDocumentShape, EdgeShapeType P2PEdgeShape, EdgeShapeType P2DocEdgeShape, EdgeShapeType Doc2PDocEdgeShape, EdgeShapeType P2PDocEdgeShape) {
        this.getRenderContext().setVertexShapeTransformer(new P2PVertexShapeTransformer<P2PVertex, P2PConnection>(this.graph.getFullGraph(), peerShape, documentShape, peerDocumentShape));
        this.getRenderContext().setEdgeStrokeTransformer((Transformer)new P2PEdgeStrokeTransformer());
        this.getRenderContext().setEdgeShapeTransformer((Transformer)new P2PEdgeShapeTransformer(P2PEdgeShape, P2DocEdgeShape, Doc2PDocEdgeShape, P2PDocEdgeShape));
    }

    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    public void setView(ViewState view) {
        this.setName(view.toString());
        this.currentView = view;
        switch (view) {
            case FullView: {
                this.setExcludeType(null);
                break;
            }
            case CollapsedPeerView: {
                this.setExcludeType(DocumentVertex.class);
                break;
            }
            case CollapsedDocumentView: {
                this.setCollapsedDocumentView();
                break;
            }
            case CollapsedPeerAndDocumentView: {
                this.setExcludeType(PeerDocumentVertex.class);
            }
        }
        this.repaint();
    }

    private void setCollapsedDocumentView() {
        this.includePredicate.setExcludeClass(PeerVertex.class);
        this.getRenderContext().setVertexFillPaintTransformer((Transformer)new P2PVertexFillPaintTransformer((PickedInfo<P2PVertex>)this.getPickedVertexState(), Color.RED, Color.YELLOW, Color.MAGENTA, Color.RED, Color.RED, Color.BLUE));
        this.getRenderContext().setVertexShapeTransformer(new P2PVertexShapeTransformer<P2PVertex, P2PConnection>(this.graph.getFullGraph(), VertexShapeType.ELLIPSE, VertexShapeType.PENTAGON, VertexShapeType.ELLIPSE, 25, 20, 25));
        this.getRenderContext().setEdgeShapeTransformer((Transformer)new P2PEdgeShapeTransformer(EdgeShapeType.QUAD_CURVE, EdgeShapeType.CUBIC_CURVE, EdgeShapeType.LINE, EdgeShapeType.LINE));
    }

    private void setExcludeType(Class<? extends P2PVertex> exclude) {
        this.includePredicate.setExcludeClass(exclude);
        this.getRenderContext().setVertexFillPaintTransformer((Transformer)new P2PVertexFillPaintTransformer((PickedInfo<P2PVertex>)this.getPickedVertexState()));
        this.setSpecialTransformers(VertexShapeType.ELLIPSE, VertexShapeType.PENTAGON, VertexShapeType.RECTANGLE, EdgeShapeType.QUAD_CURVE, EdgeShapeType.CUBIC_CURVE, EdgeShapeType.LINE, EdgeShapeType.LINE);
    }

    @Override
    public void viewChanged(ViewState view) {
        this.setView(view);
    }
}

