/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import spiderweb.visualizer.ViewChangeListener;
import spiderweb.visualizer.ViewState;
import spiderweb.visualizer.predicates.PredicateChangeEvent;
import spiderweb.visualizer.predicates.PredicateChangeListener;
import spiderweb.visualizer.transformers.TransformerChangeEvent;
import spiderweb.visualizer.transformers.TransformerChangeListener;

public class VisualOptionsPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 3026513624881148363L;
    private JRadioButton collapsedPeerAndDocumentView;
    private JRadioButton collapsedDocumentView;
    private JRadioButton collapsedPeerView;
    private JRadioButton fullView;
    private JCheckBox showHiddenVertices;
    private JCheckBox disregardTime;
    private JCheckBox inEdgePeerCutoff;
    private JCheckBox outEdgePeerCutoff;
    private JSpinner minimumInEdgePeerCutoff;
    private JSpinner minimumOutEdgePeerCutoff;
    private JCheckBox inEdgeDocumentCutoff;
    private JCheckBox outEdgeDocumentCutoff;
    private JSpinner minimumInEdgeDocumentCutoff;
    private JSpinner minimumOutEdgeDocumentCutoff;
    private List<ViewChangeListener> viewListeners;
    private List<PredicateChangeListener> predicateListeners;
    private List<TransformerChangeListener> transformerListeners;

    public void addViewListener(ViewChangeListener listener) {
        this.viewListeners.add(listener);
    }

    public void removeViewListener(ViewChangeListener listener) {
        this.viewListeners.remove(listener);
    }

    public void addPredicateListener(PredicateChangeListener listener) {
        this.predicateListeners.add(listener);
    }

    public void removePredicateListener(PredicateChangeListener listener) {
        this.predicateListeners.remove(listener);
    }

    public void addTransformerListener(TransformerChangeListener listener) {
        this.transformerListeners.add(listener);
    }

    public void removeTransformerListener(TransformerChangeListener listener) {
        this.transformerListeners.remove(listener);
    }

    public static void main(String[] args) {
        VisualOptionsPanel test = new VisualOptionsPanel();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)test, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(300, 720));
        frame.setDefaultCloseOperation(3);
    }

    public VisualOptionsPanel() {
        super(new BorderLayout());
        this.buildPanel();
        this.predicateListeners = new LinkedList<PredicateChangeListener>();
        this.transformerListeners = new LinkedList<TransformerChangeListener>();
        this.viewListeners = new LinkedList<ViewChangeListener>();
    }

    public void setView(ViewState view) {
        switch (view) {
            case FullView: {
                this.fullView.doClick();
                break;
            }
            case CollapsedPeerView: {
                this.collapsedPeerView.doClick();
                break;
            }
            case CollapsedDocumentView: {
                this.collapsedDocumentView.doClick();
                break;
            }
            case CollapsedPeerAndDocumentView: {
                this.collapsedPeerAndDocumentView.doClick();
            }
        }
        this.repaint();
    }

    private void buildPanel() {
        JPanel scrollablePanel = new JPanel(new BorderLayout());
        JPanel predicateOptions = new JPanel();
        scrollablePanel.add((Component)predicateOptions, "South");
        scrollablePanel.add((Component)this.getViewPanel(), "North");
        scrollablePanel.add((Component)this.getTransformerOptions(), "Center");
        scrollablePanel.add((Component)this.getPredicateOptions(), "South");
        JScrollPane listScroller = new JScrollPane(scrollablePanel);
        listScroller.setWheelScrollingEnabled(true);
        listScroller.setSize(scrollablePanel.getWidth(), scrollablePanel.getHeight());
        this.add((Component)listScroller, "Center");
    }

    private JPanel getTransformerOptions() {
        JPanel transformerOptions = new JPanel(new BorderLayout());
        transformerOptions.setBorder(BorderFactory.createTitledBorder("Transformer Options"));
        JPanel panelForProperLayout = new JPanel(new BorderLayout());
        panelForProperLayout.add((Component)this.getScalePanel(), "North");
        transformerOptions.add((Component)panelForProperLayout, "North");
        return transformerOptions;
    }

    private JPanel getPredicateOptions() {
        JPanel predicateOptions = new JPanel(new BorderLayout());
        predicateOptions.setBorder(BorderFactory.createTitledBorder("Predicate Options"));
        JPanel panelForProperLayout = new JPanel(new BorderLayout());
        panelForProperLayout.add((Component)this.getHiddenAndTimelessOptions(), "North");
        panelForProperLayout.add((Component)this.getVertexVisibilityPanel(), "Center");
        panelForProperLayout.add((Component)this.getTemperalQueryPanel(), "South");
        predicateOptions.add((Component)panelForProperLayout, "North");
        return predicateOptions;
    }

    private JPanel getHiddenAndTimelessOptions() {
        JPanel p = new JPanel(new GridLayout(2, 1));
        this.showHiddenVertices = new JCheckBox("Show Hidden Vertices");
        this.showHiddenVertices.addActionListener(this);
        this.showHiddenVertices.setToolTipText("Show Vertices hidden from the right click menu.");
        p.add(this.showHiddenVertices);
        this.disregardTime = new JCheckBox("Show Vertices Regardless of Time");
        this.disregardTime.addActionListener(this);
        this.disregardTime.setToolTipText("Show all vertices regardless of the time through playback");
        p.add(this.disregardTime);
        return p;
    }

    private JPanel getTemperalQueryPanel() {
        JPanel temperalQueryPanel = new JPanel(new BorderLayout());
        temperalQueryPanel.setBorder(BorderFactory.createTitledBorder("Temperal Graph Query"));
        temperalQueryPanel.setToolTipText("");
        JPanel timePanel = new JPanel();
        temperalQueryPanel.add((Component)timePanel, "North");
        timePanel.setLayout(new GridLayout(3, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton allTimeOption = new JRadioButton("All Time");
        allTimeOption.setSelected(true);
        timePanel.add(allTimeOption);
        buttonGroup.add(allTimeOption);
        JRadioButton anyTimeOption = new JRadioButton("Any Time");
        timePanel.add(anyTimeOption);
        buttonGroup.add(anyTimeOption);
        JPanel atTimePanel = new JPanel();
        timePanel.add(atTimePanel);
        atTimePanel.setLayout(new BorderLayout());
        JRadioButton timeEqualsOption = new JRadioButton("At Time t =");
        atTimePanel.add((Component)timeEqualsOption, "West");
        buttonGroup.add(timeEqualsOption);
        JFormattedTextField formattedTextField = new JFormattedTextField();
        formattedTextField.setText("5");
        atTimePanel.add((Component)formattedTextField, "Center");
        JTextPane regex = new JTextPane();
        regex.setBorder(BorderFactory.createBevelBorder(1));
        regex.setText("some sort of regular expression?");
        temperalQueryPanel.add((Component)regex, "South");
        return temperalQueryPanel;
    }

    private JPanel getVertexVisibilityPanel() {
        JPanel vertexVisiblityPanel = new JPanel(new GridLayout(2, 1));
        vertexVisiblityPanel.setBorder(BorderFactory.createTitledBorder("Vertex Degree Cutoff"));
        vertexVisiblityPanel.setToolTipText("Hide vertices which do not meet specified parameters");
        JPanel hidePeers = new JPanel(new GridLayout(2, 1));
        hidePeers.setName("peer degree cutoff");
        hidePeers.setBorder(BorderFactory.createTitledBorder("Peers"));
        hidePeers.setToolTipText("Hide peer vertices on select parameters");
        vertexVisiblityPanel.add(hidePeers);
        JPanel inDegreePanel = new JPanel(new BorderLayout());
        hidePeers.add(inDegreePanel);
        this.inEdgePeerCutoff = new JCheckBox("In Edge Count     X");
        this.inEdgePeerCutoff.addActionListener(this);
        this.inEdgePeerCutoff.setToolTipText("Hide Peers on the number of edges entering");
        inDegreePanel.add((Component)this.inEdgePeerCutoff, "West");
        this.minimumInEdgePeerCutoff = new JSpinner();
        this.minimumInEdgePeerCutoff.addChangeListener(this);
        inDegreePanel.add((Component)this.minimumInEdgePeerCutoff, "Center");
        this.minimumInEdgePeerCutoff.setToolTipText("minimum number of edges cutoff");
        this.minimumInEdgePeerCutoff.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        JPanel outDegreePanel = new JPanel(new BorderLayout());
        hidePeers.add(outDegreePanel);
        this.outEdgePeerCutoff = new JCheckBox("Out Edge Count  X");
        this.outEdgePeerCutoff.addActionListener(this);
        this.outEdgePeerCutoff.setToolTipText("Hide Peers on the number of edges leaving");
        outDegreePanel.add((Component)this.outEdgePeerCutoff, "West");
        this.minimumOutEdgePeerCutoff = new JSpinner();
        this.minimumOutEdgePeerCutoff.addChangeListener(this);
        outDegreePanel.add((Component)this.minimumOutEdgePeerCutoff, "Center");
        this.minimumOutEdgePeerCutoff.setToolTipText("minimum number of edges cutoff");
        this.minimumOutEdgePeerCutoff.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        JPanel hideDocuments = new JPanel(new GridLayout(2, 1));
        hideDocuments.setName("document degree cutoff");
        hideDocuments.setBorder(BorderFactory.createTitledBorder("Documents"));
        hideDocuments.setToolTipText("Hide document vertices on select parameters");
        vertexVisiblityPanel.add(hideDocuments);
        JPanel inDegreePanel2 = new JPanel(new BorderLayout());
        hideDocuments.add(inDegreePanel2);
        this.inEdgeDocumentCutoff = new JCheckBox("In Edge Count     X");
        this.inEdgeDocumentCutoff.addActionListener(this);
        this.inEdgeDocumentCutoff.setToolTipText("Hide documents on the number of edges entering");
        inDegreePanel2.add((Component)this.inEdgeDocumentCutoff, "West");
        this.minimumInEdgeDocumentCutoff = new JSpinner();
        this.minimumInEdgeDocumentCutoff.addChangeListener(this);
        inDegreePanel2.add((Component)this.minimumInEdgeDocumentCutoff, "Center");
        this.minimumInEdgeDocumentCutoff.setToolTipText("minimum number of edges cutoff");
        this.minimumInEdgeDocumentCutoff.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        JPanel outDegreePanel2 = new JPanel(new BorderLayout());
        hideDocuments.add(outDegreePanel2);
        this.outEdgeDocumentCutoff = new JCheckBox("Out Edge Count  X");
        this.outEdgeDocumentCutoff.addActionListener(this);
        this.outEdgeDocumentCutoff.setToolTipText("Hide documents on the number of edges leaving");
        outDegreePanel2.add((Component)this.outEdgeDocumentCutoff, "West");
        this.minimumOutEdgeDocumentCutoff = new JSpinner();
        this.minimumOutEdgeDocumentCutoff.addChangeListener(this);
        outDegreePanel2.add((Component)this.minimumOutEdgeDocumentCutoff, "Center");
        this.minimumOutEdgeDocumentCutoff.setToolTipText("minimum number of edges cutoff");
        this.minimumOutEdgeDocumentCutoff.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        return vertexVisiblityPanel;
    }

    private JPanel getScalePanel() {
        JPanel scaleOptions = new JPanel(new GridLayout(4, 1));
        scaleOptions.setBorder(BorderFactory.createTitledBorder("Scale Options"));
        scaleOptions.setToolTipText("Scale Vertices select parameters");
        JCheckBox scalePeers = new JCheckBox("Scale Peers");
        scalePeers.addActionListener(this);
        scalePeers.setToolTipText("Scale peer vertices on select parameters");
        scaleOptions.add(scalePeers);
        JCheckBox scaleDocuments = new JCheckBox("Scale Documents");
        scaleDocuments.addActionListener(this);
        scaleDocuments.setToolTipText("Scale document vertices on select parameters");
        scaleOptions.add(scaleDocuments);
        JPanel outEdgesPanel = new JPanel(new BorderLayout());
        scaleOptions.add(outEdgesPanel);
        JCheckBox scaleOutEdgeCount = new JCheckBox("Out Edge Count  X");
        scaleOutEdgeCount.addActionListener(this);
        scaleOutEdgeCount.setToolTipText("Scale Vertices on the edges leaving");
        outEdgesPanel.add((Component)scaleOutEdgeCount, "West");
        JSpinner outEdgeMultiplier = new JSpinner();
        outEdgeMultiplier.addChangeListener(this);
        outEdgesPanel.add((Component)outEdgeMultiplier, "Center");
        outEdgeMultiplier.setToolTipText("Multiplier for out edge scaling");
        outEdgeMultiplier.setModel(new SpinnerNumberModel(new Float(2.0f), new Float(1.0f), null, new Float(1.0f)));
        JPanel inEdgesPanel = new JPanel();
        scaleOptions.add(inEdgesPanel);
        inEdgesPanel.setLayout(new BorderLayout());
        JCheckBox scaleInEdgeCount = new JCheckBox("In Edge Count     X");
        scaleInEdgeCount.addActionListener(this);
        scaleInEdgeCount.setToolTipText("Scale Vertices on the edges entering");
        inEdgesPanel.add((Component)scaleInEdgeCount, "West");
        JSpinner inEdgeMultiplier = new JSpinner();
        inEdgeMultiplier.addChangeListener(this);
        inEdgeMultiplier.setModel(new SpinnerNumberModel(new Float(2.0f), new Float(1.0f), null, new Float(1.0f)));
        inEdgeMultiplier.setToolTipText("Multiplier for in edge scaling");
        inEdgesPanel.add((Component)inEdgeMultiplier, "Center");
        return scaleOptions;
    }

    private JPanel getViewPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel viewPanel = new JPanel(new GridLayout(4, 1));
        viewPanel.setBorder(BorderFactory.createTitledBorder("Graph View"));
        this.fullView = new JRadioButton("Full View");
        this.fullView.addActionListener(this);
        this.fullView.setToolTipText("Display all vertices which are not set to be hidden");
        viewPanel.add(this.fullView);
        buttonGroup.add(this.fullView);
        this.collapsedPeerView = new JRadioButton("Collapsed Peer View");
        this.collapsedPeerView.addActionListener(this);
        this.collapsedPeerView.setToolTipText("Display Peer and local document vertices which are not set to be hidden");
        viewPanel.add(this.collapsedPeerView);
        buttonGroup.add(this.collapsedPeerView);
        this.collapsedDocumentView = new JRadioButton("Collapsed Document View");
        this.collapsedDocumentView.addActionListener(this);
        this.collapsedDocumentView.setToolTipText("Display the root document and any local copies of that document which are not set to be hidden");
        viewPanel.add(this.collapsedDocumentView);
        buttonGroup.add(this.collapsedDocumentView);
        this.collapsedPeerAndDocumentView = new JRadioButton("Collapsed Peer and Document View");
        this.collapsedPeerAndDocumentView.setName("view");
        this.collapsedPeerAndDocumentView.addActionListener(this);
        this.collapsedPeerAndDocumentView.setToolTipText("Display Peers and root documents which are not set to be hidden");
        viewPanel.add(this.collapsedPeerAndDocumentView);
        buttonGroup.add(this.collapsedPeerAndDocumentView);
        return viewPanel;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        JSpinner source = (JSpinner)ce.getSource();
        System.out.println("state change event");
        if (source == this.minimumInEdgePeerCutoff || source == this.minimumOutEdgePeerCutoff || source == this.minimumInEdgeDocumentCutoff || source == this.minimumOutEdgeDocumentCutoff) {
            this.notifyPredicateListeners(this.generatePredicateChangeEvent());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        AbstractButton source = (AbstractButton)ae.getSource();
        System.out.println("action event");
        if (source == this.showHiddenVertices || source == this.disregardTime || source == this.inEdgePeerCutoff || source == this.outEdgePeerCutoff || source == this.inEdgeDocumentCutoff || source == this.outEdgeDocumentCutoff) {
            this.notifyPredicateListeners(this.generatePredicateChangeEvent());
        }
        if (source == this.collapsedPeerAndDocumentView || source == this.collapsedDocumentView || source == this.collapsedPeerView || source == this.fullView) {
            this.notifyViewListeners(ViewState.getFromString(source.getText()));
        }
    }

    protected PredicateChangeEvent generatePredicateChangeEvent() {
        System.out.println("generating predicate change event");
        boolean cutoffPeers = this.inEdgePeerCutoff.isSelected() || this.outEdgePeerCutoff.isSelected();
        boolean cutoffDocuments = this.inEdgeDocumentCutoff.isSelected() || this.outEdgeDocumentCutoff.isSelected();
        int peerInDegreeCutoff = (Integer)this.minimumInEdgePeerCutoff.getValue();
        int peerOutDegreeCutoff = (Integer)this.minimumOutEdgePeerCutoff.getValue();
        int documentInDegreeCutoff = (Integer)this.minimumInEdgeDocumentCutoff.getValue();
        int documentOutDegreeCutoff = (Integer)this.minimumOutEdgeDocumentCutoff.getValue();
        PredicateChangeEvent pce = new PredicateChangeEvent(this.showHiddenVertices.isSelected(), this.disregardTime.isSelected(), cutoffPeers, peerInDegreeCutoff, peerOutDegreeCutoff, cutoffDocuments, documentInDegreeCutoff, documentOutDegreeCutoff);
        return pce;
    }

    protected TransformerChangeEvent generateTransformerChangeEvent() {
        TransformerChangeEvent tce = new TransformerChangeEvent();
        return tce;
    }

    protected void notifyViewListeners(final ViewState view) {
        Runnable notify = new Runnable(){

            @Override
            public void run() {
                for (ViewChangeListener l : VisualOptionsPanel.this.viewListeners) {
                    l.viewChanged(view);
                }
            }
        };
        SwingUtilities.invokeLater(notify);
    }

    protected void notifyPredicateListeners(final PredicateChangeEvent options) {
        Runnable notify = new Runnable(){

            @Override
            public void run() {
                System.out.println("notifying " + VisualOptionsPanel.this.predicateListeners.size() + " listeners");
                for (PredicateChangeListener l : VisualOptionsPanel.this.predicateListeners) {
                    l.changeOptions(options);
                }
            }
        };
        SwingUtilities.invokeLater(notify);
    }

    protected void notifyTransformerListeners(final TransformerChangeEvent options) {
        Runnable notify = new Runnable(){

            @Override
            public void run() {
                for (TransformerChangeListener l : VisualOptionsPanel.this.transformerListeners) {
                    l.changeOptions(options);
                }
            }
        };
        SwingUtilities.invokeLater(notify);
    }
}

