/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.eventplayer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JSlider;
import javax.swing.Timer;
import spiderweb.graph.LogEvent;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.visualizer.eventplayer.EventPlayerListener;
import spiderweb.visualizer.eventplayer.PlayState;
import spiderweb.visualizer.eventplayer.TimeCounter;

public class EventPlayer
implements ActionListener {
    private Timer schedule;
    private TimeCounter timeCounter;
    private static final int speed = 33;
    private int fastMultiplier = 10;
    private PlayState state;
    private PlayState prevState;
    private List<LogEvent> myEventList;
    private List<EventPlayerListener> my_listeners;
    private int current_index;
    private ReferencedNetworkGraph graph;
    private long myTimeNow;
    JSlider playbackSlider;
    private boolean playable;
    private boolean robustMode = false;

    public EventPlayer(ReferencedNetworkGraph graph, List<LogEvent> eventlist, JSlider playbackSlider) {
        this.graph = graph;
        this.playbackSlider = playbackSlider;
        this.myEventList = eventlist;
        this.current_index = 0;
        this.state = PlayState.FORWARD;
        this.prevState = PlayState.FORWARD;
        this.timeCounter = new TimeCounter(33L, 0L, 0L, eventlist.get(eventlist.size() - 1).getTime());
        this.my_listeners = new LinkedList<EventPlayerListener>();
        this.myTimeNow = this.timeCounter.getLowerBound();
        this.playable = true;
    }

    public EventPlayer(ReferencedNetworkGraph graph) {
        this.graph = graph;
        this.playbackSlider = null;
        this.myEventList = new ArrayList<LogEvent>();
        this.current_index = 0;
        this.state = PlayState.PAUSE;
        this.prevState = PlayState.PAUSE;
        this.timeCounter = new TimeCounter(0L, 0L, 0L, 0L);
        this.my_listeners = new LinkedList<EventPlayerListener>();
        this.playable = false;
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.PAUSE);
        }
    }

    public void setRobustMode(boolean robustMode) {
        this.robustMode = robustMode;
    }

    public boolean isRobustMode() {
        return this.robustMode;
    }

    public void addEventPlayerListener(EventPlayerListener listener) {
        this.my_listeners.add(listener);
    }

    public void removeEventPlayerListener(EventPlayerListener listener) {
        this.my_listeners.remove(listener);
    }

    public void setSpeedMultiplier(int multiplier) {
        if (multiplier != this.fastMultiplier) {
            this.fastMultiplier = multiplier;
            if (this.state == PlayState.FASTFORWARD) {
                this.timeCounter.setIncrement(33 * this.fastMultiplier);
            } else if (this.state == PlayState.FASTREVERSE) {
                this.timeCounter.setIncrement(-33 * this.fastMultiplier);
            }
        }
    }

    public PlayState getPlayState() {
        return this.state;
    }

    public int getCurrentIndex() {
        return this.current_index;
    }

    public boolean isForward() {
        return this.state == PlayState.FASTFORWARD || this.state == PlayState.FORWARD;
    }

    public boolean isFast() {
        return this.state == PlayState.FASTFORWARD || this.state == PlayState.FASTREVERSE;
    }

    public boolean atFront() {
        return this.timeCounter.getTime() == this.timeCounter.getLowerBound();
    }

    public boolean atBack() {
        return this.timeCounter.getTime() == this.timeCounter.getUpperBound();
    }

    public boolean atAnEnd() {
        return this.atFront() || this.atBack();
    }

    public void fastReverse() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.FASTREVERSE);
        }
        if (this.state != PlayState.FASTREVERSE) {
            this.prevState = this.state;
            this.state = PlayState.FASTREVERSE;
            this.timeCounter.setIncrement(-33 * this.fastMultiplier);
            this.wakeup(this.prevState);
        }
    }

    public void reverse() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.REVERSE);
        }
        if (this.state != PlayState.REVERSE) {
            this.prevState = this.state;
            this.state = PlayState.REVERSE;
            this.timeCounter.setIncrement(-33L);
            this.wakeup(this.prevState);
        }
    }

    public void fastForward() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.FASTFORWARD);
        }
        if (this.state != PlayState.FASTFORWARD) {
            PlayState prevState = this.state;
            this.state = PlayState.FASTFORWARD;
            this.timeCounter.setIncrement(33 * this.fastMultiplier);
            this.wakeup(prevState);
        }
    }

    public void forward() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.FORWARD);
        }
        if (this.state != PlayState.FORWARD) {
            this.prevState = this.state;
            this.state = PlayState.FORWARD;
            this.timeCounter.setIncrement(33L);
            this.wakeup(this.prevState);
        }
    }

    private synchronized void wakeup(PlayState previousState) {
        if (previousState == PlayState.PAUSE) {
            if (this.atAnEnd()) {
                this.timeCounter.doIncrement();
            }
            this.schedule.start();
            this.notify();
        }
    }

    public synchronized void pause() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(PlayState.PAUSE);
        }
        if (this.state != PlayState.PAUSE) {
            this.prevState = this.state;
            this.state = PlayState.PAUSE;
            this.notify();
        }
    }

    public void goToTime(int value) {
        PlayState prevState = this.state;
        this.state = (long)value < this.timeCounter.getTime() ? PlayState.REVERSE : PlayState.FORWARD;
        this.timeCounter.setTime(value);
        this.state = prevState;
    }

    public void stopPlayback() {
        this.wakeup(this.state);
        this.schedule.stop();
    }

    public void doQuery(int peer, int queryString, int queryMessageID) {
        this.graph.getFullGraph().getPeer(peer).query(queryMessageID);
    }

    public void undoQuery(int peer, int queryString, int queryMessageID) {
        this.graph.getFullGraph().getPeer(peer).endQuery(queryMessageID);
    }

    public void doQueryEdge(int peerFrom, int peerTo) {
        this.graph.getFullGraph().findPeerConnection(peerFrom, peerTo).query();
    }

    public void undoQueryEdge(int peerFrom, int peerTo) {
        this.graph.getFullGraph().findPeerConnection(peerFrom, peerTo).backToNormal();
    }

    public void doQueryReachesPeer(int peer, int queryMessageID) {
        this.graph.getFullGraph().getPeer(peer).receiveQuery(queryMessageID);
    }

    public void undoQueryReachesPeer(int peer, int queryMessageID) {
        this.graph.getFullGraph().getPeer(peer).endReceivedQuery(queryMessageID);
    }

    public void doQueryHit(int peerNumber, int documentNumber, int queryMessageID) {
        this.graph.getFullGraph().getPeerDocument(peerNumber, documentNumber).setQueryHit(true);
    }

    public void undoQueryHit(int peerNumber, int documentNumber, int queryMessageID) {
        this.graph.getFullGraph().getPeerDocument(peerNumber, documentNumber).setQueryHit(false);
    }

    public void beginPlayback() {
        for (EventPlayerListener epl : this.my_listeners) {
            epl.stateChanged(this.state);
        }
        this.schedule = new Timer(33, this);
        this.schedule.start();
    }

    private List<LogEvent> getLogEventsUntil(long timeGoingTo) {
        LinkedList<LogEvent> events = new LinkedList<LogEvent>();
        if (this.myTimeNow < timeGoingTo) {
            LogEvent evt = this.myEventList.get(this.current_index);
            while (evt.getTime() < timeGoingTo) {
                ++this.current_index;
                if (this.current_index >= this.myEventList.size()) {
                    this.current_index = this.myEventList.size() - 1;
                    break;
                }
                events.add(evt);
                evt = this.myEventList.get(this.current_index);
            }
        } else {
            LogEvent evt = this.myEventList.get(this.current_index - 1);
            while (evt.getTime() > timeGoingTo) {
                --this.current_index;
                if (this.current_index >= 1) {
                    events.add(evt);
                    evt = this.myEventList.get(this.current_index - 1);
                    continue;
                }
                break;
            }
        }
        return events;
    }

    private void robustHandleLogEvent(LogEvent evt, boolean forward) {
        try {
            this.graph.graphEvent(evt, forward);
            String what = evt.getType();
            int val1 = evt.getParam(1);
            int val2 = evt.getParam(2);
            int val3 = evt.getParam(3);
            if (what.equals("query")) {
                if (forward) {
                    this.doQuery(val1, val2, val3);
                } else {
                    this.undoQuery(val1, val2, val3);
                }
            } else if (what.equals("unquery")) {
                if (forward) {
                    this.undoQuery(val1, val2, val3);
                } else {
                    this.doQuery(val1, val2, val3);
                }
            } else if (what.equals("queryhit")) {
                if (forward) {
                    this.doQueryHit(val1, val2, val3);
                } else {
                    this.undoQueryHit(val1, val2, val3);
                }
            } else if (what.equals("unqueryhit")) {
                if (forward) {
                    this.undoQueryHit(val1, val2, val3);
                } else {
                    this.doQueryHit(val1, val2, val3);
                }
            } else if (what.equals("queryreachespeer")) {
                if (forward) {
                    this.doQueryReachesPeer(val1, val2);
                } else {
                    this.undoQueryReachesPeer(val1, val2);
                }
            } else if (what.equals("unqueryreachespeer")) {
                if (forward) {
                    this.undoQueryReachesPeer(val1, val2);
                } else {
                    this.doQueryReachesPeer(val1, val2);
                }
            } else if (what.equals("queryedge")) {
                if (forward) {
                    this.doQueryEdge(val1, val2);
                } else {
                    this.undoQueryEdge(val1, val2);
                }
            } else if (what.equals("unqueryedge")) {
                if (forward) {
                    this.undoQueryEdge(val1, val2);
                } else {
                    this.doQueryEdge(val1, val2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(evt);
        }
    }

    private void handleLogEvent(LogEvent evt, boolean forward) {
        try {
            if (evt.isStructural()) {
                this.graph.graphEvent(evt, forward);
            } else {
                String what = evt.getType();
                int val1 = evt.getParam(1);
                int val2 = evt.getParam(2);
                int val3 = evt.getParam(3);
                if (what.equals("query")) {
                    if (forward) {
                        this.doQuery(val1, val2, val3);
                    } else {
                        this.undoQuery(val1, val2, val3);
                    }
                } else if (what.equals("unquery")) {
                    if (forward) {
                        this.undoQuery(val1, val2, val3);
                    } else {
                        this.doQuery(val1, val2, val3);
                    }
                } else if (what.equals("queryhit")) {
                    if (forward) {
                        this.doQueryHit(val1, val2, val3);
                    } else {
                        this.undoQueryHit(val1, val2, val3);
                    }
                } else if (what.equals("unqueryhit")) {
                    if (forward) {
                        this.undoQueryHit(val1, val2, val3);
                    } else {
                        this.doQueryHit(val1, val2, val3);
                    }
                } else if (what.equals("queryreachespeer")) {
                    if (forward) {
                        this.doQueryReachesPeer(val1, val2);
                    } else {
                        this.undoQueryReachesPeer(val1, val2);
                    }
                } else if (what.equals("unqueryreachespeer")) {
                    if (forward) {
                        this.undoQueryReachesPeer(val1, val2);
                    } else {
                        this.doQueryReachesPeer(val1, val2);
                    }
                } else if (what.equals("queryedge")) {
                    if (forward) {
                        this.doQueryEdge(val1, val2);
                    } else {
                        this.undoQueryEdge(val1, val2);
                    }
                } else if (what.equals("unqueryedge")) {
                    if (forward) {
                        this.undoQueryEdge(val1, val2);
                    } else {
                        this.doQueryEdge(val1, val2);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(evt);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block7: {
            block6: {
                long nextTime;
                if (!this.playable) break block6;
                if (this.state != PlayState.PAUSE) {
                    this.timeCounter.doIncrement();
                    if (this.atAnEnd()) {
                        this.pause();
                    }
                }
                boolean isforward = (nextTime = this.timeCounter.getTime()) > this.myTimeNow;
                List<LogEvent> events = this.getLogEventsUntil(nextTime);
                for (LogEvent evt : events) {
                    if (this.robustMode) {
                        this.robustHandleLogEvent(evt, isforward);
                        continue;
                    }
                    this.handleLogEvent(evt, isforward);
                }
                this.myTimeNow = nextTime;
                this.playbackSlider.setValue((int)this.myTimeNow);
                if (events.isEmpty()) break block7;
                for (EventPlayerListener epl : this.my_listeners) {
                    epl.doRepaint();
                }
                break block7;
            }
            for (EventPlayerListener epl : this.my_listeners) {
                epl.doRepaint();
            }
        }
    }

    public List<LogEvent> getSaveEvents() {
        ListIterator<LogEvent> i = this.myEventList.listIterator(this.current_index);
        LinkedList<LogEvent> events = new LinkedList<LogEvent>();
        while (i.hasNext()) {
            events.add(i.next());
        }
        return events;
    }

    public synchronized void addEvents(List<LogEvent> events) {
        this.myEventList.remove(this.myEventList.size() - 1);
        this.myEventList.addAll(events);
        this.playbackSlider.setMaximum((int)this.myEventList.get(this.myEventList.size() - 1).getTime());
        this.timeCounter.setUpperBound(this.myEventList.get(this.myEventList.size() - 1).getTime());
        if (this.state.equals((Object)PlayState.PAUSE)) {
            for (EventPlayerListener epl : this.my_listeners) {
                epl.stateChanged(PlayState.PAUSE);
            }
        }
    }

    public long getCurrentTime() {
        return this.myTimeNow;
    }
}

