/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.eventplayer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TimeCounter
implements ActionListener {
    private long lowerBound;
    private long upperBound;
    private long time;
    private long increment;

    public TimeCounter() {
        this(1L);
    }

    public TimeCounter(long increment) {
        this(increment, 0L);
    }

    public TimeCounter(long increment, long startTime) {
        this(increment, startTime, 0L, 100L);
    }

    public TimeCounter(long increment, long startTime, long lowerBound, long upperBound) {
        this.increment = increment;
        this.time = startTime;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public long getTime() {
        return this.time;
    }

    public synchronized void setTime(long time) {
        this.time = time;
        this.doBound();
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setIncrement(long increment) {
        this.increment = increment;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public void doIncrement() {
        this.setTime(this.time + this.increment);
        this.doBound();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.doIncrement();
    }

    private void doBound() {
        if (this.time < this.lowerBound) {
            this.time = this.lowerBound;
        } else if (this.time > this.upperBound) {
            this.time = this.upperBound;
        }
    }
}

