/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.predicates;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import org.apache.commons.collections15.Predicate;
import spiderweb.graph.DocumentVertex;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.graph.ReferencedNetworkGraph;
import spiderweb.visualizer.predicates.PredicateChangeEvent;
import spiderweb.visualizer.predicates.PredicateChangeListener;

public class OptionsPredicate
implements Predicate<Context<Graph<P2PVertex, P2PConnection>, P2PVertex>>,
PredicateChangeListener {
    protected ReferencedNetworkGraph graph;
    protected Class<? extends P2PVertex> exclude;
    protected boolean showHiddenVertices;
    protected boolean disregardTime;
    protected boolean cutoffPeers;
    protected int peerInDegreeCutoff;
    protected int peerOutDegreeCutoff;
    protected boolean cutoffDocuments;
    protected int documentInDegreeCutoff;
    protected int documentOutDegreeCutoff;

    public OptionsPredicate(ReferencedNetworkGraph graph) {
        this.graph = graph;
        this.exclude = null;
        this.showHiddenVertices = false;
    }

    public void setExcludeClass(Class<? extends P2PVertex> exclude) {
        this.exclude = exclude;
    }

    public boolean evaluate(Context<Graph<P2PVertex, P2PConnection>, P2PVertex> context) {
        int outDegree;
        int inDegree;
        if (this.disregardTime) {
            return true;
        }
        if (!this.graph.getDynamicGraph().containsVertex((P2PVertex)context.element)) {
            return false;
        }
        if (((P2PVertex)context.element).isHidden() && !this.showHiddenVertices) {
            return false;
        }
        if (((P2PVertex)context.element).getClass().equals(this.exclude)) {
            return false;
        }
        if (this.cutoffPeers && ((P2PVertex)context.element).getClass().equals(PeerVertex.class)) {
            inDegree = this.graph.getDynamicGraph().getInEdges((P2PVertex)context.element).size();
            outDegree = this.graph.getDynamicGraph().getOutEdges((P2PVertex)context.element).size();
            if (this.peerInDegreeCutoff > inDegree) {
                return false;
            }
            if (this.peerOutDegreeCutoff > outDegree) {
                return false;
            }
        }
        if (this.cutoffDocuments && ((P2PVertex)context.element).getClass().equals(DocumentVertex.class)) {
            inDegree = this.graph.getDynamicGraph().getInEdges((P2PVertex)context.element).size();
            outDegree = this.graph.getDynamicGraph().getOutEdges((P2PVertex)context.element).size();
            if (this.peerInDegreeCutoff > inDegree) {
                return false;
            }
            if (this.peerOutDegreeCutoff > outDegree) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void changeOptions(PredicateChangeEvent pce) {
        this.showHiddenVertices = pce.getShowHiddenVertices();
        this.disregardTime = pce.getDisregardTime();
        this.cutoffPeers = pce.getCutoffPeers();
        this.peerInDegreeCutoff = pce.getPeerInDegreeCutoff();
        this.peerOutDegreeCutoff = pce.getPeerOutDegreeCutoff();
        this.cutoffDocuments = pce.getCutoffDocuments();
        this.documentInDegreeCutoff = pce.getDocumentInDegreeCutoff();
        this.documentOutDegreeCutoff = pce.getDocumentOutDegreeCutoff();
    }
}

