/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.transformers;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.decorators.AbstractEdgeShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import java.awt.Shape;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.P2PConnection;
import spiderweb.graph.P2PVertex;
import spiderweb.visualizer.EdgeShapeType;

public class P2PEdgeShapeTransformer
implements Transformer<Context<Graph<P2PVertex, P2PConnection>, P2PConnection>, Shape> {
    private AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> P2PEdgeShape;
    private AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> P2DocEdgeShape;
    private AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> Doc2PDocEdgeShape;
    private AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> P2PDocEdgeShape;
    private final AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> defaultEdgeShape;

    public P2PEdgeShapeTransformer(EdgeShapeType P2PEdgeShape, EdgeShapeType P2DocEdgeShape, EdgeShapeType Doc2PDocEdgeShape, EdgeShapeType P2PDocEdgeShape) {
        this.P2PEdgeShape = this.shapeChooser(P2PEdgeShape);
        this.P2DocEdgeShape = this.shapeChooser(P2DocEdgeShape);
        this.Doc2PDocEdgeShape = this.shapeChooser(Doc2PDocEdgeShape);
        this.P2PDocEdgeShape = this.shapeChooser(P2PDocEdgeShape);
        this.defaultEdgeShape = new EdgeShape.Box();
    }

    public Shape transform(Context<Graph<P2PVertex, P2PConnection>, P2PConnection> context) {
        if (((P2PConnection)context.element).isP2P()) {
            return (Shape)this.P2PEdgeShape.transform(context);
        }
        if (((P2PConnection)context.element).isP2DOC()) {
            return (Shape)this.P2DocEdgeShape.transform(context);
        }
        if (((P2PConnection)context.element).isDOC2PDOC()) {
            return (Shape)this.Doc2PDocEdgeShape.transform(context);
        }
        if (((P2PConnection)context.element).isP2PDOC()) {
            return (Shape)this.P2PDocEdgeShape.transform(context);
        }
        return (Shape)this.defaultEdgeShape.transform(context);
    }

    private AbstractEdgeShapeTransformer<P2PVertex, P2PConnection> shapeChooser(EdgeShapeType chosenShape) {
        switch (chosenShape) {
            case BENT_LINE: {
                return new EdgeShape.BentLine();
            }
            case BOX: {
                return new EdgeShape.Box();
            }
            case CUBIC_CURVE: {
                return new EdgeShape.CubicCurve();
            }
            case LINE: {
                return new EdgeShape.Line();
            }
            case LOOP: {
                return new EdgeShape.Loop();
            }
            case ORTHOGONAL: {
                return new EdgeShape.Orthogonal();
            }
            case QUAD_CURVE: {
                return new EdgeShape.QuadCurve();
            }
            case SIMPLE_LOOP: {
                return new EdgeShape.SimpleLoop();
            }
            case WEDGE: {
                return new EdgeShape.Wedge(3);
            }
        }
        return new EdgeShape.Line();
    }
}

