/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.transformers;

import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import java.awt.Color;
import java.awt.Paint;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.P2PVertex;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;

public class P2PVertexFillPaintTransformer
extends PickableVertexPaintTransformer<P2PVertex>
implements Transformer<P2PVertex, Paint> {
    public static final Color DEF_PEER_COLOR = Color.RED;
    public static final Color DEF_PICKED_PEER_COLOR = Color.YELLOW;
    public static final Color DEF_PEER_ANSWERING_COLOR = Color.PINK;
    public static final Color DEF_PEER_QUERY_COLOR = Color.MAGENTA;
    public static final Color DEF_PEERDOC_QUERYHIT_COLOR = Color.LIGHT_GRAY;
    public static final Color DEF_PEERDOC_COLOR = Color.ORANGE;
    public static final Color DEF_DOC_COLOR = Color.BLUE;
    private Color peerColor = DEF_PEER_COLOR;
    private Color pickedPeerColor = DEF_PICKED_PEER_COLOR;
    private Color peerQueryColor = DEF_PEER_QUERY_COLOR;
    private Color peerDocQueryHitColor = DEF_PEERDOC_QUERYHIT_COLOR;
    private Color peerDocColor = DEF_PEERDOC_COLOR;
    private Color docColor = DEF_DOC_COLOR;

    public P2PVertexFillPaintTransformer(PickedInfo<P2PVertex> pi) {
        super(pi, (Paint)DEF_PEER_COLOR, (Paint)DEF_PICKED_PEER_COLOR);
    }

    public P2PVertexFillPaintTransformer(PickedInfo<P2PVertex> pi, Color peerColor, Color pickedPeerColor, Color peerQueryColor, Color peerDocQueryHitColor, Color peerDocColor, Color docColor) {
        super(pi, (Paint)peerColor, (Paint)pickedPeerColor);
        this.peerColor = peerColor;
        this.pickedPeerColor = pickedPeerColor;
        this.peerQueryColor = peerQueryColor;
        this.peerDocQueryHitColor = peerDocQueryHitColor;
        this.peerDocColor = peerDocColor;
        this.docColor = docColor;
    }

    public Paint transform(P2PVertex v) {
        if (v instanceof PeerVertex) {
            if (this.pi.isPicked((Object)v)) {
                return this.pickedPeerColor;
            }
            if (((PeerVertex)v).hasOutgoingQueries()) {
                return this.peerQueryColor;
            }
            return this.peerColor;
        }
        if (v instanceof PeerDocumentVertex) {
            if (((PeerDocumentVertex)v).isQueryHit()) {
                return this.peerDocQueryHitColor;
            }
            return this.peerDocColor;
        }
        return this.docColor;
    }
}

