/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.transformers;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import java.awt.Shape;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;
import spiderweb.visualizer.VertexShapeType;
import spiderweb.visualizer.transformers.P2PVertexSizeTransformer;

public class P2PVertexShapeTransformer<V, E>
extends AbstractVertexShapeTransformer<V>
implements Transformer<V, Shape> {
    public static final int DOC_SIZE = 20;
    public static final int PEER_SIZE = 25;
    public static final int PEER_DOC_SIZE = 15;
    private VertexShapeType peerShape;
    private VertexShapeType documentShape;
    private VertexShapeType peerDocumentShape;
    private P2PVertexSizeTransformer<V, E> sizeTransformer;

    public P2PVertexShapeTransformer(Graph<V, E> graphIn, VertexShapeType peerShape, VertexShapeType documentShape, VertexShapeType peerDocumentShape) {
        this(graphIn, peerShape, documentShape, peerDocumentShape, 25, 20, 15);
    }

    public P2PVertexShapeTransformer(Graph<V, E> graphIn, VertexShapeType peerShape, VertexShapeType documentShape, VertexShapeType peerDocumentShape, int peerSize, int documentSize, int peerDocumentSize) {
        this.sizeTransformer = new P2PVertexSizeTransformer<V, E>(peerSize, documentSize, peerDocumentSize, graphIn);
        this.setSizeTransformer(this.sizeTransformer);
        this.peerShape = peerShape;
        this.documentShape = documentShape;
        this.peerDocumentShape = peerDocumentShape;
    }

    public Shape transform(V v) {
        if (v instanceof PeerVertex) {
            return this.shapeChooser(v, this.peerShape);
        }
        if (v instanceof PeerDocumentVertex) {
            return this.shapeChooser(v, this.peerDocumentShape);
        }
        return this.shapeChooser(v, this.documentShape);
    }

    private Shape shapeChooser(V v, VertexShapeType chosenShape) {
        switch (chosenShape) {
            case ELLIPSE: {
                return this.factory.getEllipse(v);
            }
            case RECTANGLE: {
                return this.factory.getRectangle(v);
            }
            case PENTAGON: {
                return this.factory.getRegularPolygon(v, 5);
            }
            case STAR: {
                return this.factory.getRegularStar(v, 8);
            }
            case ROUND_RECTANGLE: {
                return this.factory.getRoundRectangle(v);
            }
        }
        return this.factory.getRectangle(v);
    }

    public void setScaling(boolean scale) {
        this.sizeTransformer.setScaling(scale);
    }
}

