/*
 * Decompiled with CFR 0.152.
 */
package spiderweb.visualizer.transformers;

import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;
import spiderweb.graph.PeerDocumentVertex;
import spiderweb.graph.PeerVertex;

public class P2PVertexSizeTransformer<V, E>
implements Transformer<V, Integer> {
    private int my_doc_size;
    private int my_peer_doc_size;
    private int my_peer_size;
    protected Graph<V, E> graph;
    private boolean scale = false;

    public P2PVertexSizeTransformer(int ds, int ps, int pds, Graph<V, E> graph) {
        this.my_doc_size = ds;
        this.my_peer_size = ps;
        this.my_peer_doc_size = pds;
        this.graph = graph;
    }

    public Integer transform(V vertexID) {
        if (vertexID instanceof PeerVertex) {
            if (this.scale) {
                int numConnections = this.graph.getOutEdges(vertexID).size();
                return new Integer(this.my_peer_size + numConnections * 2);
            }
            return new Integer(this.my_peer_size);
        }
        if (vertexID instanceof PeerDocumentVertex) {
            return new Integer(this.my_peer_doc_size);
        }
        if (this.scale) {
            int numConnections = this.graph.getInEdges(vertexID).size();
            return new Integer(this.my_doc_size + numConnections);
        }
        return new Integer(this.my_doc_size);
    }

    public void setScaling(boolean scale) {
        this.scale = scale;
    }
}

