/*
 * Decompiled with CFR 0.152.
 */
package org.jLOAF.inputs.complex;

import org.jLOAF.inputs.ComplexInput;
import org.jLOAF.inputs.Feature;
import org.jLOAF.inputs.Input;
import org.jLOAF.inputs.atomic.MatrixCell;
import org.jLOAF.sim.SimilarityMetricStrategy;

public class Matrix
extends ComplexInput {
    private static final long serialVersionUID = 1L;
    private static SimilarityMetricStrategy simMet;
    private int rows = 0;
    private int cols = 0;

    public Matrix(String name, double[][] matrix) {
        super(name);
        this.rows = matrix.length;
        this.cols = matrix[0].length;
        int ii = 0;
        while (ii < this.rows) {
            int jj = 0;
            while (jj < this.cols) {
                MatrixCell mc = new MatrixCell(String.valueOf(ii) + "-" + jj, new Feature(matrix[ii][jj]));
                this.add(mc);
                ++jj;
            }
            ++ii;
        }
    }

    @Override
    public double similarity(Input i) {
        if (this.simStrategy != null) {
            return this.simStrategy.similarity(this, i);
        }
        if (Matrix.isClassStrategySet()) {
            return Matrix.similarity(this, i);
        }
        return super.similarity(i);
    }

    private static double similarity(Input complexInput, Input i) {
        return simMet.similarity(complexInput, i);
    }

    public static boolean isClassStrategySet() {
        return simMet != null;
    }

    public static void setClassSimilarityMetric(SimilarityMetricStrategy s) {
        simMet = s;
    }
}

