/*
 * Decompiled with CFR 0.152.
 */
package org.jLOAF.Tetris;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;
import org.jLOAF.Tetris.TetrisAction;
import org.jLOAF.Tetris.TetrisInput;
import org.jLOAF.action.Action;
import org.jLOAF.action.AtomicAction;
import org.jLOAF.casebase.Case;
import org.jLOAF.casebase.CaseBase;
import org.jLOAF.inputs.Feature;
import org.jLOAF.inputs.Input;
import org.jLOAF.inputs.complex.Matrix;

public class LogFile2CaseBase {
    private String m_logFileName;
    private String m_outputFileName;
    private CaseBase m_casebase;

    public static void main(String[] args) {
        String inFile = "log.txt";
        String outFile = "tetris.cb";
        LogFile2CaseBase lf2cb = new LogFile2CaseBase(inFile, outFile);
        try {
            lf2cb.parseLogFile();
        }
        catch (IOException e) {
            System.err.println("Error parsing log file: " + e.getMessage());
            return;
        }
        System.out.println("Writing Cases to file...");
        try {
            lf2cb.writeCaseBaseFile();
        }
        catch (IOException e) {
            System.err.println("Error writing to output file: " + e.getMessage());
        }
        System.out.println("Finished!");
    }

    public LogFile2CaseBase(String logFile, String caseBaseFile) {
        if (logFile == null || caseBaseFile == null) {
            throw new IllegalArgumentException("Null parameters given to constructor.");
        }
        this.m_logFileName = logFile;
        this.m_outputFileName = caseBaseFile;
        this.m_casebase = new CaseBase();
    }

    public void parseLogFile() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.m_logFileName));
        String line = null;
        System.out.println("Reading log data...");
        while ((line = in.readLine()) != null) {
            int ii;
            if (line.equals("") || line.equals("\n")) continue;
            Scanner s = new Scanner(line);
            s.useDelimiter("\\?");
            String board = s.next();
            String piece = s.next();
            int x = new Integer(s.next());
            int y = new Integer(s.next());
            int rot = new Integer(s.next());
            double score = new Double(s.next());
            TetrisAction tetrisact = new TetrisAction();
            AtomicAction acts = new AtomicAction("TetrisFeatures");
            Feature f_x = new Feature((double)x);
            Feature f_y = new Feature((double)y);
            Feature f_rot = new Feature((double)rot);
            Feature f_score = new Feature(score);
            acts.addFeature(f_x);
            acts.addFeature(f_y);
            acts.addFeature(f_rot);
            acts.addFeature(f_score);
            tetrisact.add((Action)acts);
            TetrisInput ti = new TetrisInput();
            double[][] boardMat = new double[20][10];
            Scanner scn = new Scanner(board);
            scn.useDelimiter(",");
            int cnt = 0;
            while (scn.hasNext()) {
                String currRow = scn.next();
                if (cnt > 3) {
                    Scanner s2 = new Scanner(currRow);
                    s2.useDelimiter("-");
                    ii = 0;
                    while (ii < 10) {
                        boardMat[cnt - 4][ii] = new Double(s2.next());
                        ++ii;
                    }
                }
                ++cnt;
            }
            Matrix tb = new Matrix("TetrisBoard", boardMat);
            double[][] pieceMat = new double[4][4];
            ii = 0;
            while (ii < pieceMat.length) {
                int jj = 0;
                while (jj < pieceMat[0].length) {
                    pieceMat[ii][jj] = 0.0;
                    ++jj;
                }
                ++ii;
            }
            scn = new Scanner(piece);
            scn.useDelimiter("-");
            String v1 = scn.next();
            pieceMat[new Integer((String)v1.substring((int)0, (int)1)).intValue()][new Integer((String)v1.substring((int)1, (int)2)).intValue()] = 1.0;
            String v2 = scn.next();
            pieceMat[new Integer((String)v2.substring((int)0, (int)1)).intValue()][new Integer((String)v2.substring((int)1, (int)2)).intValue()] = 1.0;
            String v3 = scn.next();
            pieceMat[new Integer((String)v3.substring((int)0, (int)1)).intValue()][new Integer((String)v3.substring((int)1, (int)2)).intValue()] = 1.0;
            String v4 = scn.next();
            pieceMat[new Integer((String)v4.substring((int)0, (int)1)).intValue()][new Integer((String)v4.substring((int)1, (int)2)).intValue()] = 1.0;
            Matrix tp = new Matrix("TetrisPiece", pieceMat);
            ti.add((Input)tb);
            ti.add((Input)tp);
            Case c = new Case((Input)ti, (Action)tetrisact);
            this.m_casebase.add(c);
        }
        System.out.println("Finished reading log file.");
        System.out.println(String.valueOf(this.m_casebase.getSize()) + " Cases were extracted.");
        in.close();
    }

    public void writeCaseBaseFile() throws IOException {
        CaseBase.save((CaseBase)this.m_casebase, (String)this.m_outputFileName);
    }
}

