/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

public final class Board {
    private int width;
    private int height;
    private int[] widths;
    private int[] heights;
    private boolean[][] grid;
    private int[] xwidths;
    private int[] xheights;
    private boolean[][] xgrid;
    private int scol;
    private int ecol;
    private boolean fast_undo = true;
    private boolean committed;
    private boolean DEBUG = false;
    public static final int PLACE_OK = 0;
    public static final int PLACE_ROW_FILLED = 1;
    public static final int PLACE_OUT_BOUNDS = 2;
    public static final int PLACE_BAD = 3;

    public Board(int aWidth, int aHeight) {
        this.width = aWidth;
        this.height = aHeight;
        this.grid = new boolean[this.width][this.height];
        this.widths = new int[this.height];
        this.heights = new int[this.width];
        this.xgrid = new boolean[this.width][this.height];
        this.xwidths = new int[this.height];
        this.xheights = new int[this.width];
        this.committed = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxHeight() {
        int max = 0;
        int i = 0;
        while (i < this.width) {
            if (this.heights[i] > max) {
                max = this.heights[i];
            }
            ++i;
        }
        return max;
    }

    public void sanityCheck() {
        if (this.DEBUG) {
            int temp = 0;
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    if (this.grid[j][i]) {
                        ++temp;
                    }
                    ++j;
                }
                if (temp != this.widths[i]) {
                    throw new RuntimeException("Widths[] array is CrAzY!");
                }
                temp = 0;
                ++i;
            }
            temp = 0;
            int max = 0;
            int i2 = 0;
            while (i2 < this.width) {
                int j = this.height - 1;
                while (j >= 0) {
                    if (this.grid[i2][j]) {
                        temp = j + 1;
                        if (j + 1 <= max) break;
                        max = j + 1;
                        break;
                    }
                    --j;
                }
                if (temp != this.heights[i2]) {
                    throw new RuntimeException("Heights[] array is CrAzY!");
                }
                temp = 0;
                ++i2;
            }
            if (this.getMaxHeight() != max) {
                throw new RuntimeException("HieghtMax is CRAzY!!!!");
            }
        }
    }

    public int dropHeight(Piece piece, int x) {
        int high = 10000;
        int result = 0;
        int[] skirt = piece.getSkirt();
        int i = x;
        while (i < x + piece.getWidth()) {
            int temp = skirt[i - x] - this.heights[i];
            if (temp < high) {
                high = temp;
                result = i;
            }
            ++i;
        }
        return this.heights[result] - skirt[result - x];
    }

    public int getColumnHeight(int x) {
        return this.heights[x];
    }

    public int getRowWidth(int y) {
        return this.widths[y];
    }

    public final boolean getGrid(int x, int y) {
        if (x < 0 || x > this.width) {
            return true;
        }
        if (y < 0 || y > this.height) {
            return true;
        }
        return this.grid[x][y];
    }

    public int place(Piece piece, int x, int y) {
        int puty;
        int putx;
        Point[] body = piece.getBody();
        boolean row_filled = false;
        if (!this.committed) {
            throw new RuntimeException("Trying to place on uncommited board!!!");
        }
        this.committed = false;
        this.backup();
        int i = 0;
        while (i < body.length) {
            putx = x + body[i].x;
            puty = y + body[i].y;
            if (putx < 0 || putx >= this.width) {
                return 2;
            }
            if (puty < 0 || puty >= this.height) {
                return 2;
            }
            if (this.grid[putx][puty]) {
                return 3;
            }
            ++i;
        }
        i = 0;
        while (i < body.length) {
            putx = x + body[i].x;
            puty = y + body[i].y;
            this.grid[putx][puty] = true;
            int n = puty;
            this.widths[n] = this.widths[n] + 1;
            if (puty + 1 > this.heights[putx]) {
                this.heights[putx] = puty + 1;
            }
            if (this.widths[puty] >= this.width) {
                row_filled = true;
            }
            ++i;
        }
        this.sanityCheck();
        if (row_filled) {
            return 1;
        }
        return 0;
    }

    public boolean clearRows() {
        boolean cleared = false;
        if (this.committed) {
            this.backup();
        }
        this.committed = false;
        int i = 0;
        while (i < this.height) {
            if (this.widths[i] >= this.width) {
                cleared = true;
                int j = 0;
                while (j < this.width) {
                    System.arraycopy(this.grid[j], i + 1, this.grid[j], i, this.height - 1 - i);
                    this.grid[j][this.height - 1] = false;
                    ++j;
                }
                System.arraycopy(this.widths, i + 1, this.widths, i, this.height - 1 - i);
                this.widths[this.height - 1] = 0;
                --i;
            }
            ++i;
        }
        if (cleared) {
            this.recalcHeights();
        }
        this.sanityCheck();
        return cleared;
    }

    private void recalcHeights() {
        boolean sent = false;
        int i = 0;
        while (i < this.width) {
            sent = false;
            int j = this.height - 1;
            while (j >= 0) {
                if (this.grid[i][j] && !sent) {
                    this.heights[i] = j + 1;
                    sent = true;
                }
                --j;
            }
            if (!sent) {
                this.heights[i] = 0;
            }
            ++i;
        }
    }

    public void undo() {
        if (!this.committed) {
            int[] temp = this.widths;
            this.widths = this.xwidths;
            this.xwidths = temp;
            temp = this.heights;
            this.heights = this.xheights;
            this.xheights = temp;
            boolean[][] temp2 = this.grid;
            this.grid = this.xgrid;
            this.xgrid = temp2;
            this.committed = true;
        }
        this.sanityCheck();
    }

    private void backup() {
        int i = 0;
        while (i < this.width) {
            System.arraycopy(this.grid[i], 0, this.xgrid[i], 0, this.height);
            ++i;
        }
        System.arraycopy(this.widths, 0, this.xwidths, 0, this.height);
        System.arraycopy(this.heights, 0, this.xheights, 0, this.width);
    }

    public void commit() {
        if (!this.committed) {
            this.committed = true;
        }
    }

    public String toString() {
        String s = new String();
        int ii = this.height - 1;
        while (ii >= 0) {
            String sub_s = new String();
            int jj = 0;
            while (jj < this.width) {
                sub_s = this.grid[jj][ii] ? String.valueOf(sub_s) + "1" : String.valueOf(sub_s) + "0";
                if (jj != this.width - 1) {
                    sub_s = String.valueOf(sub_s) + "-";
                }
                ++jj;
            }
            if (ii != 0) {
                sub_s = String.valueOf(sub_s) + ",";
            }
            s = String.valueOf(s) + sub_s;
            --ii;
        }
        return s;
    }
}

