/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class FunBrain
implements Brain {
    private BufferedWriter bf;

    public FunBrain() {
        try {
            this.bf = new BufferedWriter(new FileWriter("log.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Brain.Move bestMove(Board board, Piece piece, int limitHeight, Brain.Move move) {
        Point[] p_val = piece.getBody();
        String p_string = new String();
        int ii = 0;
        while (ii < p_val.length) {
            p_string = String.valueOf(p_string) + p_val[ii].x + p_val[ii].y;
            if (ii != p_val.length - 1) {
                p_string = String.valueOf(p_string) + "-";
            }
            ++ii;
        }
        String logVal = String.valueOf(board.toString()) + "?" + p_string;
        if (move == null) {
            move = new Brain.Move();
        }
        double bestScore = 1.0E20;
        int bestX = 0;
        int bestY = 0;
        int rotations = 0;
        int bestrot = 0;
        Piece bestPiece = null;
        Piece current = piece;
        do {
            int yBound = limitHeight - current.getHeight() + 1;
            int xBound = board.getWidth() - current.getWidth() + 1;
            int x = 0;
            while (x < xBound) {
                int y = board.dropHeight(current, x);
                if (y < yBound) {
                    int result = board.place(current, x, y);
                    if (result <= 1) {
                        double score;
                        if (result == 1) {
                            board.clearRows();
                        }
                        if ((score = this.rateBoard(board)) < bestScore) {
                            bestScore = score;
                            bestX = x;
                            bestY = y;
                            bestrot = rotations;
                            bestPiece = current;
                        }
                    }
                    board.undo();
                }
                ++x;
            }
            current = current.nextRotation();
            ++rotations;
        } while (current != piece);
        if (bestPiece == null) {
            return null;
        }
        move.x = bestX;
        move.y = bestY;
        move.rots = bestrot;
        move.piece = bestPiece;
        move.score = bestScore;
        logVal = String.valueOf(logVal) + "?" + move.x;
        logVal = String.valueOf(logVal) + "?" + move.y;
        logVal = String.valueOf(logVal) + "?" + bestrot;
        logVal = String.valueOf(logVal) + "?" + move.score;
        logVal = String.valueOf(logVal) + "\n";
        try {
            this.bf.write(logVal);
            this.bf.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return move;
    }

    public double rateBoard(Board board) {
        int width = board.getWidth();
        int maxHeight = board.getMaxHeight();
        int sumHeight = 0;
        int holes = 0;
        int x = 0;
        while (x < width) {
            int colHeight = board.getColumnHeight(x);
            sumHeight += colHeight;
            int y = colHeight - 2;
            while (y >= 0) {
                if (!board.getGrid(x, y)) {
                    ++holes;
                }
                --y;
            }
            ++x;
        }
        double avgHeight = (double)sumHeight / (double)width;
        return (double)(8 * maxHeight) + 40.0 * avgHeight + 1.25 * (double)holes;
    }

    protected void close() throws Throwable {
        this.bf.flush();
        this.bf.close();
    }
}

