/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextArea;

public class JBrainTetris
extends JTetris {
    public Brain mBrain = new JIFSABrain();
    public static JTextArea publictext;
    private Brain.Move mMove = new Brain.Move();
    private int cur_count = -1;
    protected JSlider adversary;
    protected JLabel adStat;
    protected JSlider happy;
    protected JLabel adHappy;
    protected JCheckBox brainPlay;
    protected String adversaryOn = "Malice Mode On >:-(";
    protected String adversaryOff = "Malice Mode Off";
    protected String happyOn = "Happy Mode On :-)";
    protected String happyOff = "Happy Mode Off";

    public JBrainTetris(int width, int height) {
        super(width, height);
    }

    @Override
    public void stopGame() {
        super.stopGame();
        this.startButton.doClick();
    }

    @Override
    public void tick(int verb) {
        if (this.brainPlay.isSelected()) {
            this.board.undo();
            if (verb == 4) {
                if (this.cur_count != this.count) {
                    this.mMove = this.mBrain.bestMove(this.board, this.currentPiece, this.board.getHeight() - 4, this.mMove);
                    this.cur_count = this.count;
                }
                if (this.mMove == null || this.currentPiece == null) {
                    this.stopGame();
                    return;
                }
                if (this.mMove.rots > 0) {
                    Point[] prev = this.currentPiece.getBody();
                    super.tick(0);
                    Point[] after = this.currentPiece.getBody();
                    Piece pv = new Piece(prev);
                    Piece af = new Piece(after);
                    if (!pv.equals(af)) {
                        --this.mMove.rots;
                    }
                }
                if (this.currentX < this.mMove.x) {
                    super.tick(2);
                }
                if (this.currentX > this.mMove.x) {
                    super.tick(1);
                }
            }
        }
        super.tick(verb);
    }

    @Override
    public Container createControlPanel() {
        Container panel2 = Box.createVerticalBox();
        panel2 = super.createControlPanel();
        this.brainPlay = new JCheckBox("Use AI", false);
        if (this.testMode) {
            this.brainPlay.setSelected(true);
        }
        panel2.add(this.brainPlay);
        publictext = new JTextArea();
        panel2.add(publictext);
        this.adversary = new JSlider(0, 100, 0);
        this.adversary.setPreferredSize(new Dimension(100, 15));
        this.adStat = new JLabel(this.adversaryOff);
        this.happy = new JSlider(0, 100, 0);
        this.happy.setPreferredSize(new Dimension(100, 15));
        this.adHappy = new JLabel(this.happyOff);
        return panel2;
    }

    @Override
    public Piece pickNextPiece() {
        if (this.adversary.getValue() == 0 && this.happy.getValue() == 0) {
            this.adStat.setText(this.adversaryOff);
            this.adHappy.setText(this.happyOff);
            return super.pickNextPiece();
        }
        if (this.adversary.getValue() != 0 && this.happy.getValue() != 0) {
            this.adversary.setValue(0);
            this.adversary.repaint();
        }
        if (this.random.nextInt(100) <= this.adversary.getValue()) {
            this.adStat.setText(this.adversaryOn);
            return this.getWorstPiece(true);
        }
        this.adStat.setText(this.adversaryOff);
        if (this.random.nextInt(100) <= this.happy.getValue()) {
            this.adHappy.setText(this.happyOn);
            return this.getWorstPiece(false);
        }
        this.adHappy.setText(this.happyOff);
        return super.pickNextPiece();
    }

    private Piece getWorstPiece(boolean hurt_player) {
        Brain.Move wMove = null;
        int index = 0;
        int i = 0;
        while (i < this.pieces.length) {
            Brain.Move tMove = this.mBrain.bestMove(this.board, this.pieces[i], this.board.getHeight() - 4, null);
            if (i == 0) {
                wMove = tMove;
            }
            if (tMove == null) {
                return this.pieces[i];
            }
            if (hurt_player && tMove.score >= wMove.score || !hurt_player && tMove.score <= wMove.score) {
                wMove = tMove;
                index = i;
            }
            ++i;
        }
        return this.pieces[index];
    }
}

