/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTetris
extends JComponent {
    public static final int WIDTH = 10;
    public static final int HEIGHT = 20;
    public static final int TOP_SPACE = 4;
    protected boolean testMode = false;
    public final int TEST_LIMIT = 100;
    protected boolean DRAW_OPTIMIZE = true;
    protected Board board;
    protected Piece[] pieces;
    protected Piece currentPiece;
    protected int currentX;
    protected int currentY;
    protected boolean moved;
    protected Piece newPiece;
    protected int newX;
    protected int newY;
    protected boolean gameOn;
    protected int count;
    protected long startTime;
    protected Random random;
    protected JLabel countLabel;
    protected JLabel timeLabel;
    protected JButton startButton;
    protected JButton stopButton;
    protected Timer timer;
    protected JSlider speed;
    public final int DELAY = 400;
    public static final int ROTATE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int DROP = 3;
    public static final int DOWN = 4;

    JTetris(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.gameOn = false;
        this.pieces = Piece.getPieces();
        this.board = new Board(10, 24);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(1);
            }
        }, "left", KeyStroke.getKeyStroke('4'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(1);
            }
        }, "left", KeyStroke.getKeyStroke('j'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(2);
            }
        }, "right", KeyStroke.getKeyStroke('6'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(2);
            }
        }, "right", KeyStroke.getKeyStroke('l'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(0);
            }
        }, "rotate", KeyStroke.getKeyStroke('5'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(0);
            }
        }, "rotate", KeyStroke.getKeyStroke('k'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(3);
            }
        }, "drop", KeyStroke.getKeyStroke('0'), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(3);
            }
        }, "drop", KeyStroke.getKeyStroke('n'), 2);
        this.timer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.tick(4);
            }
        });
    }

    public void startGame() {
        this.board = new Board(10, 24);
        this.repaint();
        this.count = 0;
        this.gameOn = true;
        this.random = this.testMode ? new Random(0L) : new Random();
        this.enableButtons();
        this.timeLabel.setText(" ");
        this.addNewPiece();
        this.timer.start();
        this.startTime = System.currentTimeMillis();
    }

    private void enableButtons() {
        this.startButton.setEnabled(!this.gameOn);
        this.stopButton.setEnabled(this.gameOn);
    }

    public void stopGame() {
        this.gameOn = false;
        this.enableButtons();
        this.timer.stop();
        long delta = (System.currentTimeMillis() - this.startTime) / 10L;
        this.timeLabel.setText(String.valueOf(Double.toString((double)delta / 100.0)) + " seconds");
    }

    public int setCurrent(Piece piece, int x, int y) {
        int result = this.board.place(piece, x, y);
        if (result <= 1) {
            if (this.currentPiece != null) {
                this.repaintPiece(this.currentPiece, this.currentX, this.currentY);
            }
            this.currentPiece = piece;
            this.currentX = x;
            this.currentY = y;
            this.repaintPiece(this.currentPiece, this.currentX, this.currentY);
        } else {
            this.board.undo();
        }
        return result;
    }

    public Piece pickNextPiece() {
        int pieceNum = (int)((double)this.pieces.length * this.random.nextDouble());
        Piece piece = this.pieces[pieceNum];
        return piece;
    }

    public void addNewPiece() {
        ++this.count;
        if (this.testMode && this.count == 101) {
            this.stopGame();
            return;
        }
        Piece piece = this.pickNextPiece();
        int px = (this.board.getWidth() - piece.getWidth()) / 2;
        int py = this.board.getHeight() - piece.getHeight();
        this.board.commit();
        this.currentPiece = null;
        int result = this.setCurrent(piece, px, py);
        if (result > 1) {
            this.stopGame();
        }
        this.countLabel.setText(Integer.toString(this.count));
    }

    public void computeNewPosition(int verb) {
        this.newPiece = this.currentPiece;
        this.newX = this.currentX;
        this.newY = this.currentY;
        switch (verb) {
            case 1: {
                --this.newX;
                break;
            }
            case 2: {
                ++this.newX;
                break;
            }
            case 0: {
                this.newPiece = this.newPiece.nextRotation();
                this.newX += (this.currentPiece.getWidth() - this.newPiece.getWidth()) / 2;
                this.newY += (this.currentPiece.getHeight() - this.newPiece.getHeight()) / 2;
                break;
            }
            case 4: {
                --this.newY;
                break;
            }
            case 3: {
                this.newY = this.board.dropHeight(this.newPiece, this.newX);
                break;
            }
            default: {
                throw new RuntimeException("Bad verb");
            }
        }
    }

    public void tick(int verb) {
        boolean failed;
        if (!this.gameOn) {
            return;
        }
        if (this.currentPiece != null) {
            this.board.undo();
        }
        this.computeNewPosition(verb);
        int result = this.setCurrent(this.newPiece, this.newX, this.newY);
        if (result == 1) {
            this.repaint();
        }
        boolean bl = failed = result >= 2;
        if (failed && this.currentPiece != null) {
            this.board.place(this.currentPiece, this.currentX, this.currentY);
        }
        if (failed && verb == 4 && !this.moved) {
            if (this.board.clearRows()) {
                this.repaint();
            }
            if (this.board.getMaxHeight() > this.board.getHeight() - 4) {
                this.stopGame();
            } else {
                this.addNewPiece();
            }
        }
        this.moved = !failed && verb != 4;
    }

    public void repaintPiece(Piece piece, int x, int y) {
        if (this.DRAW_OPTIMIZE) {
            int px = this.xPixel(x);
            int py = this.yPixel(y + piece.getHeight() - 1);
            int pwidth = this.xPixel(x + piece.getWidth()) - px;
            int pheight = this.yPixel(y - 1) - py;
            this.repaint(px, py, pwidth, pheight);
        } else {
            this.repaint();
        }
    }

    private final float dX() {
        return (float)(this.getWidth() - 2) / (float)this.board.getWidth();
    }

    private final float dY() {
        return (float)(this.getHeight() - 2) / (float)this.board.getHeight();
    }

    private final int xPixel(int x) {
        return Math.round(1.0f + (float)x * this.dX());
    }

    private final int yPixel(int y) {
        return Math.round((float)(this.getHeight() - 1) - (float)(y + 1) * this.dY());
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int spacerY = this.yPixel(this.board.getHeight() - 4 - 1);
        g.drawLine(0, spacerY, this.getWidth() - 1, spacerY);
        Rectangle clip = null;
        if (this.DRAW_OPTIMIZE) {
            clip = g.getClipBounds();
        }
        int dx = Math.round(this.dX() - 2.0f);
        int dy = Math.round(this.dY() - 2.0f);
        int bWidth = this.board.getWidth();
        int bHeight = this.board.getHeight();
        int x = 0;
        while (x < bWidth) {
            int left = this.xPixel(x);
            int right = this.xPixel(x + 1) - 1;
            if (!this.DRAW_OPTIMIZE || clip == null || right >= clip.x && left < clip.x + clip.width) {
                int yHeight = this.board.getColumnHeight(x);
                int y = 0;
                while (y < yHeight) {
                    if (this.board.getGrid(x, y)) {
                        boolean filled;
                        boolean bl = filled = this.board.getRowWidth(y) == bWidth;
                        if (filled) {
                            g.setColor(Color.green);
                        }
                        g.fillRect(left + 1, this.yPixel(y) + 1, dx, dy);
                        if (filled) {
                            g.setColor(Color.black);
                        }
                    }
                    ++y;
                }
            }
            ++x;
        }
    }

    public void updateTimer() {
        double value = (double)this.speed.getValue() / (double)this.speed.getMaximum();
        this.timer.setDelay((int)(400.0 - value * 400.0));
    }

    public Container createControlPanel() {
        Box panel = Box.createVerticalBox();
        this.countLabel = new JLabel("0");
        panel.add(this.countLabel);
        this.timeLabel = new JLabel(" ");
        panel.add(this.timeLabel);
        panel.add(Box.createVerticalStrut(12));
        this.startButton = new JButton("Start");
        panel.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ii = 0;
                while (ii < 50) {
                    JTetris.this.startGame();
                    ++ii;
                }
            }
        });
        this.stopButton = new JButton("Stop");
        panel.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTetris.this.stopGame();
            }
        });
        this.enableButtons();
        JPanel row = new JPanel();
        panel.add(Box.createVerticalStrut(12));
        row.add(new JLabel("Speed:"));
        this.speed = new JSlider(0, 200, 75);
        this.speed.setPreferredSize(new Dimension(100, 15));
        if (this.testMode) {
            this.speed.setValue(200);
        }
        this.updateTimer();
        row.add(this.speed);
        panel.add(row);
        this.speed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTetris.this.updateTimer();
            }
        });
        return panel;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Tetris");
        JComponent container = (JComponent)frame.getContentPane();
        container.setLayout(new BorderLayout());
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int pixels = 16;
        JBrainTetris tetris = new JBrainTetris(162, 386);
        container.add((Component)tetris, "Center");
        if (args.length != 0 && args[0].equals("test")) {
            tetris.testMode = true;
        }
        Container panel = ((JTetris)tetris).createControlPanel();
        panel.add(Box.createVerticalStrut(12));
        JButton quit = new JButton("Quit");
        panel.add(quit);
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        container.add((Component)panel, "East");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

