/*
 * Decompiled with CFR 0.152.
 */
public class LameBrain
implements Brain {
    @Override
    public Brain.Move bestMove(Board board, Piece piece, int limitHeight, Brain.Move move) {
        if (move == null) {
            move = new Brain.Move();
        }
        double bestScore = 1.0E20;
        int bestX = 0;
        int bestY = 0;
        int rotations = 0;
        int bestrot = 0;
        Piece bestPiece = null;
        Piece current = piece;
        do {
            int yBound = limitHeight - current.getHeight() + 1;
            int xBound = board.getWidth() - current.getWidth() + 1;
            int x = 0;
            while (x < xBound) {
                int y = board.dropHeight(current, x);
                if (y < yBound) {
                    int result = board.place(current, x, y);
                    if (result <= 1) {
                        double score;
                        if (result == 1) {
                            board.clearRows();
                        }
                        if ((score = this.rateBoard(board)) < bestScore) {
                            bestScore = score;
                            bestX = x;
                            bestY = y;
                            bestrot = rotations;
                            bestPiece = current;
                        }
                    }
                    board.undo();
                }
                ++x;
            }
            current = current.nextRotation();
            ++rotations;
        } while (current != piece);
        if (bestPiece == null) {
            return null;
        }
        move.x = bestX;
        move.y = bestY;
        move.rots = bestrot;
        move.piece = bestPiece;
        move.score = bestScore;
        return move;
    }

    public double rateBoard(Board board) {
        int width = board.getWidth();
        int maxHeight = board.getMaxHeight();
        int sumHeight = 0;
        int holes = 0;
        int x = 0;
        while (x < width) {
            int colHeight = board.getColumnHeight(x);
            sumHeight += colHeight;
            int y = colHeight - 2;
            while (y >= 0) {
                if (!board.getGrid(x, y)) {
                    ++holes;
                }
                --y;
            }
            ++x;
        }
        double avgHeight = (double)sumHeight / (double)width;
        return (double)(8 * maxHeight) + 40.0 * avgHeight + 1.25 * (double)holes;
    }
}

