/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Piece {
    private Point[] body;
    private int[] skirt;
    private int width;
    private int height;
    private Piece next;
    private static Piece[] pieces;

    public Piece(Point[] points) {
        this.body = new Point[points.length];
        int i = 0;
        while (i < points.length) {
            this.body[i] = new Point();
            this.body[i] = points[i];
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Point[] getBody() {
        return this.body;
    }

    public int[] getSkirt() {
        return this.skirt;
    }

    public Piece nextRotation() {
        return this.next;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Piece)) {
            return false;
        }
        if (((Piece)obj).body.length != this.body.length) {
            return false;
        }
        HashSet<Point> setA = new HashSet<Point>();
        HashSet<Point> setB = new HashSet<Point>();
        int i = 0;
        while (i < this.body.length) {
            setA.add(((Piece)obj).body[i]);
            setB.add(this.body[i]);
            ++i;
        }
        boolean res = setA.equals(setB);
        return setA.equals(setB);
    }

    public static Piece[] getPieces() {
        if (pieces == null) {
            pieces = new Piece[]{Piece.pieceRow(new Piece(Piece.parsePoints("0 0 0 1 0 2 0 3"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 0 0 1 0 2 1 0"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 0 1 0 1 1 1 2"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 0 1 0 1 1 2 1"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 1 1 1 1 0 2 0"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 0 0 1 1 0 1 1"))), Piece.pieceRow(new Piece(Piece.parsePoints("0 0 1 0 1 1 2 0")))};
        }
        return pieces;
    }

    private static Point[] parsePoints(String string) {
        Vector<Point> points = new Vector<Point>();
        StringTokenizer tok = new StringTokenizer(string);
        try {
            while (tok.hasMoreTokens()) {
                int x = Integer.parseInt(tok.nextToken());
                int y = Integer.parseInt(tok.nextToken());
                points.addElement(new Point(x, y));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse x,y string:" + string);
        }
        Object[] array = new Point[points.size()];
        points.copyInto(array);
        return array;
    }

    private static Piece pieceRow(Piece root) {
        Piece temp = root;
        Piece prev = root;
        while (true) {
            prev = temp;
            prev.setPieceDims();
            prev.setPieceSkirt();
            temp = new Piece(prev.body);
            temp = temp.rotatePiece();
            if (temp.equals(root)) break;
            prev.next = temp;
        }
        prev.next = root;
        return root;
    }

    private Piece rotatePiece() {
        Piece piece = null;
        Point[] temp = new Point[this.body.length];
        int i = 0;
        while (i < this.body.length) {
            temp[i] = new Point();
            temp[i].x = this.body[i].y;
            temp[i].y = this.body[i].x;
            ++i;
        }
        piece = new Piece(temp);
        piece.setPieceDims();
        i = 0;
        while (i < piece.body.length) {
            temp[i].x = piece.width - 1 - piece.body[i].x;
            temp[i].y = piece.body[i].y;
            ++i;
        }
        piece = new Piece(temp);
        return piece;
    }

    private void setPieceDims() {
        int wmax = -1;
        int hmax = -1;
        int i = 0;
        while (i < this.body.length) {
            if (this.body[i].x > wmax) {
                wmax = this.body[i].x;
            }
            if (this.body[i].y > hmax) {
                hmax = this.body[i].y;
            }
            ++i;
        }
        this.width = wmax + 1;
        this.height = hmax + 1;
    }

    private void setPieceSkirt() {
        int wmax = this.width;
        this.skirt = new int[wmax];
        int i = 0;
        while (i < wmax) {
            Point temp = null;
            int hmax = 10000;
            int j = 0;
            while (j < this.body.length) {
                if (this.body[j].x == i && this.body[j].y < hmax) {
                    hmax = this.body[j].y;
                    temp = this.body[j];
                }
                ++j;
            }
            this.skirt[i] = temp.y;
            ++i;
        }
    }
}

