/*
 * GUIManager.java
 *
 * history:
 * 2001.04.25 alokem creation
 *
 */

import java.io.*;
import java.net.*;
import java.util.*;
import magenta.*;

/**
 * class GUIManager -
 *  An example management application that implements a simple 
 *  interactive command-line interface for a Magenta Agent.  This class 
 *  can also be used as a template for user defined management applications.
 *  This is the main vehicle for customizing Magenta.
 *
 *  A user defined management application (userapp) must contain the
 *  "implements Manager" clause in its declaration.
 *  By extension this requires that the userapp implement the
 *  log and handleEvent methods:
 *  - The log method allows the userapp to receive and handle internal 
 *    debugging messages from the agent.
 *  - The handleEvent method allows the userapp to receive and handle 
 *    event reports received by the agent.
 *  
 *  A userapp contains a main() method which instantiates an Agent class and
 *  passes it to the userapp's constructor.  The userapp constructor will 
 *  install itself as the Agent's management app using the Agent's 
 *  setManager method.
 *
 * @version
 * 2001.04.25 alokem creation
 */
public class GUIManager extends Agent {
  GUIManagerFrame myGUIManagerFrame;

  public
  GUIManager(String path, String name){
    super(path, name);

    myGUIManagerFrame =
      new GUIManagerFrame(this);
  }

  public void
  log(String message) {
    myGUIManagerFrame.displayNotification("log: " + message);
  }

  public String
  handleEvent(String message) {
    log("event - " + message);
    return new String("success");
  }

  public String
  setHostInfo(String newHostInfo) {
    String result = super.setHostInfo(newHostInfo);
    myGUIManagerFrame.setTitle("GUIManagerFrame - " + 
     this.getHostName() + ":" + 
     this.getPort());
    return result;
  }

  public String
  setAddToList(String hostToAdd) {
    if (hostToAdd != null) {
      myGUIManagerFrame.addToList(hostToAdd);
      return new String("success");
    } else {
      return new String("failure null host specified");
    }
  }

  public static void main(String[] args) 	{
    // detects which port the com manager should listen at
    String hostInfo;
    if (args.length < 1) {
      hostInfo = Agent.DEFAULTHOSTPORT;
    } else {
      hostInfo = args[0];
    }

    // create the manager
    GUIManager theManager = 
      new GUIManager("", ObjectManager.rootGdmoName);
    theManager.setHostInfo(hostInfo);
  } // GUIManager::main
} // class GUIManager