import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.StringTokenizer; 
import magenta.*;

/**
 * class GUIManagerFrame
 *
 * history:
 * 2001.02.22 matt ladd creation
 */


public class GUIManagerFrame 
 extends JFrame
 implements ActionListener 
{

DefaultListModel listModel = new DefaultListModel();
JTextField textField = new JTextField("");;
JTextPane textPane = new JTextPane();
JList list = new JList(listModel);
JButton b1 = new JButton("");
JButton b2 = new JButton("");
JButton b3 = new JButton("");
JButton b4 = new JButton("");

//this variable keeps track of the Agent the instance of GUIManagerFrame belongs to
private Agent myAgent;

String userInput;

//this variable will be of type Agent once we define it
String selectedMagenta;

final static String HELP = "Help";
final static String CLEAR = "Clear";
final static String INPUT = "Input";
final static String LIST = "List";

public GUIManagerFrame(Agent agent) {
  //set the myAgent variable to recognize the agent the GUIManagerFrame belongs to
  myAgent = agent;

  //set up the container to use GridBagLayout
  Container contentPane= getContentPane();
  GridBagLayout gridbag = new GridBagLayout();
  GridBagConstraints c = new GridBagConstraints();
  contentPane.setLayout (gridbag);
  c.fill = GridBagConstraints.HORIZONTAL;
  
  //create menu buttons and text fields to occupy window 
  b1.setText("File");
  c.weightx = 0.5;
  c.gridx = 0;
  c.gridy = 0;
  gridbag.setConstraints(b1, c);
  contentPane.add(b1);

  //set up for b2
  b2.setText("Edit");
  c.gridx = 1;
  c.gridy = 0;
  gridbag.setConstraints(b2, c);
  contentPane.add(b2);

  //set up for b3
  b3.setText("Help");
  b3.setActionCommand(HELP);
  b3.addActionListener(this);
  c.gridx = 2;
  c.gridy = 0;
  gridbag.setConstraints(b3, c);
  contentPane.add(b3);

  //Set up textPane to display info to user.
  c.ipady = 200;  //add 200 to the minimum height (i.e. make it taller)
  c.weightx = 0.0;
  c.gridwidth = 3;  //component covers three grids
  c.gridx = 0;
  c.gridy = 1;
  JScrollPane textScrollPane = new JScrollPane(textPane);
  gridbag.setConstraints(textScrollPane, c);
  contentPane.add(textScrollPane);
//  gridbag.setConstraints(textPane, c);
//  contentPane.add(textPane);

  //set up for b4
  b4.setText("Clear");
  b4.setActionCommand(CLEAR);
  b4.addActionListener(this);
  c.ipady = 0; //reset to default
  c.gridx = 1;
  c.gridwidth = 1;
  c.gridy = 2;
  gridbag.setConstraints(b4, c);
  contentPane.add(b4);

  //set up for JList that holds list of available Magentas
  list.addListSelectionListener(
    new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
	  selectedMagenta = "success";
	  textPaneAppend(selectedMagenta);
	}
    });

  c.ipady = 20;
  c.weightx = 0.0;
  c.gridwidth = 3;
  c.gridx = 0;
  c.gridy = 3;
  //add a scroll bar to the list
  JScrollPane listScrollPane = new JScrollPane(list);
  gridbag.setConstraints(listScrollPane, c);
  contentPane.add(listScrollPane);
 
  //JTextField textField = new JTextField("");
  c.ipady = 0;  //reset to default
  c.weightx = 0.0;
  c.gridwidth = 3;  //component covers three grids
  c.gridx = 0;
  c.gridy = 4;
  textField.setActionCommand(INPUT);
  textField.addActionListener(this);
  gridbag.setConstraints(textField, c);
  contentPane.add(textField);

  addWindowListener(new WindowAdapter() {
    public void windowClosing(WindowEvent e) {
      System.exit(0);
    }
   });

  this.setTitle("GUIManagerFrame - " + 
   myAgent.getHostName() + ":" + 
   myAgent.getPort());
  this.pack();
  this.setVisible(true);
  }

  private void textPaneAppend(String str){
    textPane.setText(textPane.getText() + "\n" + str);
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand() == HELP) {
      textPaneAppend("This service is unavailable at present.");
    } else if (e.getActionCommand() == CLEAR) {
      textPane.setText("");

   /* insert code to set variable "magenta"
    * equal to the selected value in the list
    * } else if (e.getActionCommand() == LIST) {
    */

    } else if (e.getActionCommand() == INPUT) {
	userInput = textField.getText();
	//display the input command to the user
	displayNotification("you entered: " + userInput);
      //parse the command line and handle it appropriately
	parseQuery(userInput);
	//clear the text field
      //textField.setText("");
    } else {
	//clear the text field
      textField.setText("");  
    }
  }

  public void valueChanged(ListSelectionEvent e) {
  
  }

  public void displayNotification(String message) {
    textPaneAppend(message);
  }

  public void parseQuery(String query) { 
  
    StringTokenizer tokenizer = new StringTokenizer(query," ");
    /*String agent = tokenizer.nextToken();
     *replace above line to take destination Magenta from JList
     */
    String agent = (String)list.getSelectedValue();
    textPaneAppend("selected " + agent);
    String message = tokenizer.nextToken("");
    ComManager myComManager = myAgent.getComManager();
    String reply = "Error Error Error";
    try {
      AgentProxy agentHandle = 
        (AgentProxy)myAgent.getObjectManager().getObject(agent);
      if (agent != null) {
        reply = myComManager.send(agentHandle, message);
      } else {
        reply = new String("error: no such agent");
      }
    }
    catch (Exception e) { textPaneAppend("Error");};
    textPaneAppend("reply: " + reply);
  }
  
  public void addToList(String elementToAdd) {
    listModel.addElement(elementToAdd);
  }

} // GUIManagerFrame