/*
 * 1.2 version.
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.applet.*;
import java.util.*;
import magenta.*;

public class NqueensViewer extends Applet {
    final static Color bg = Color.white;
    final static Color fg = Color.black;
    final static Color red = Color.red;
    final static Color white = Color.white;

    private Nqueens nqueensServer;

    public
    NqueensViewer(Nqueens theServer) {
      super();
      nqueensServer = theServer;
    }

    public void init() {
        //Initialize drawing colors
        setBackground(bg);
        setForeground(fg);
    }

    public void paint(Graphics g) {
      int step = 70;
      int stretch = 5;
      int xb, yb, x, y;
      String pos;
      StringTokenizer tokenizer;

      // get iterator over list of queen positions from the server
      Iterator qIterator = nqueensServer.queenIterator();
      // for each queen
      while (qIterator.hasNext()) {
        // read row (y) and column (x)      
        pos = (String)qIterator.next();
        tokenizer = new StringTokenizer(pos, ",");

        if (tokenizer.hasMoreElements()) {
          y = Integer.parseInt(tokenizer.nextToken());
          if (tokenizer.hasMoreElements()) {
            x = Integer.parseInt(tokenizer.nextToken());
            xb = (x + 1) * step; yb = (y + 1) * step;
            g.setColor(red);
            g.drawLine(xb - (3 * stretch), yb - (4 * stretch), xb + (3 * stretch), yb - (4 * stretch));
            g.drawLine(xb + (3 * stretch), yb - (4 * stretch), xb - (6 * stretch), yb + (4 * stretch));
            g.drawLine(xb - (6 * stretch), yb + (4 * stretch), xb + (6 * stretch), yb + (4 * stretch));
            g.drawLine(xb + (6 * stretch), yb + (4 * stretch), xb - (3 * stretch), yb - (4 * stretch));
            g.drawLine(xb, yb + (4 * stretch), xb - (3 * stretch), yb + (8 * stretch));
            g.drawLine(xb, yb + (4 * stretch), xb + (3 * stretch), yb + (8 * stretch));
          } // x is valid
        } // y is valid
      } // for each queen position

      return;
    } // NqueensViewer::paint

} // class NqueensViewer
