import java.lang.*;
import java.util.*;
import magenta.*;

/**
 * class Printer
 */
public class Printer extends GdmoObject {

  private Boolean printerOnline = new Boolean(true);
  private Boolean printerBusy = new Boolean(false);

  public Printer(String path, String name){
    super(path, name);
  }

  public String toString() {
    return new String(super.toString() + " printerOnline: " + printerOnline + " printerBusy: " + printerBusy);
  }

  /**
   * setStatus
   *
   * note that argument is of type String (this is all we can get
   * over the wire) so the routine has to convert it into its
   * own data representation (Boolean).
   *
   * return value indicates whether the argument can be
   * converted into the correct datatype.
   */

  public String setStatus(String newStatus) {
    if (newStatus.compareTo("true") == 0) {
      printerOnline = new Boolean(true);
    } else if (newStatus.compareTo("false") == 0) {
      printerOnline = new Boolean(false);
    } else {
      // value specified was neither true nor false, return
      // FALSE to indicate bad input
      return new String("failure value must be one of true or false");
    }

    // return TRUE to indicate good input
    return new String("success");
  }

  public Boolean getStatus(){
    return printerOnline;
  }
} // class Printer