/*
 * AgentProxy.java
 *
 * history:
 * 2001.04.25 alokem creation
 */

package magenta;

import java.lang.*;
import java.util.*;

/**
 * class AgentProxy -
 *  GdmoObject that represents a remote agent.  This class (or a descended 
 *  class) is expected as an argument to ComManager's send method since 
 *  it encapsulates all the information required to send a TCP/IP message to 
 *  a remote agent.  
 *
 *  <p>The root/observers subtree also should contain objects of type 
 *  AgentProxy.  These remote agents will be notified when objects are created, 
 *  deleted or changed.
 *
 *  <p>
 *  This class can be used as a template for creation of a GdmoObject.
 *  It consists of the following sections - examine the source code for
 *  details:
 *
 *  <ul>
 *  <li><b>member variables</b> - 
 *  the internal state of the object
 *
 *  <li><b>required GdmoObject constructor</b> - 
 *  constructor of the form <code>ObjectName(path, name)</code> is required 
 *  since a GdmoObject is instantiated at a specific path in the ObjectTree
 *  and with a specific name.
 *
 *  <li><b>member access methods</b> -
 *  This section contains set and get methods for the GdmoObject's attributes
 *  which can be called from remote agents.  The naming of the methods is important!  
 *  It must consist of "set" or "get" followed by the exact name of the attribute - 
 *  it is case sensitive.
 *  The correct signature is also required for access methods to be visible to 
 *  the ComManager:
 *
 *  <ul>
 *   <li>Set methods should take a String which can then be massaged to
 *   the internal data representation.  Set methods should return a String
 *   indicating whether the attribute was correctly set (success) or
 *   failed (failure).
 *   <li>Get methods should return a String representing the value of the attribute.
 *   This should be in the same format that the Set method would expect.
 *  </ul>
 *
 *  <li><b>display method</b> -
 *  toString method used to display information about this object.
 *  </ul>
 *
 *  <dl>
 *  <b>GdmoObject attributes:</b>
 *   <dd>HostInfo - string in form "hostname:port" where this agent 
 *        can be contacted</dd>
 *  </dl>
 *
 * @author aloke mukherjee
 * @version
 * 2001.04.25 alokem creation
 */
public class AgentProxy extends GdmoObject {

  //---------------------------------------------------------- member variables

  /** hostname:port info for the remote agent which this proxy represents */
  private String hostInfo;

  //------------------------------------------ required GdmoObject constructors

  // other constructors could be implemented but they will not be callable by
  // the ComManager
	
  /** 
   * AgentProxy constructor -
   *  create an AgentProxy in the Object tree.
   */
  public AgentProxy(String path, String name){
    super(path, name);
  } // AgentProxy(path, name)

  //---------------------------------------------------- member access methods

  /** 
   * AgentProxy::setHostInfo -
   *  set the hostname:port of the proxy.
   *
   * @param newHostInfo   string containing the hostname:port info.
   *
   * @return 
   * "success" if value was set successfully, otherwise "failure"
   *
   * @version
   * 2001.04.25 alokem creation
   */
  public String setHostInfo(String newHostInfo) {
    // can erase newhostinfo by setting it to null
    if (newHostInfo == null) {
      hostInfo = null;
      return new String("success");
    }

    if (newHostInfo.indexOf(":") == -1) {
      return new String("failure HostInfo should be in format hostname:port");
    } else {
      hostInfo = newHostInfo;
      return new String("success");
    }
  } // AgentProxy::setHostInfo

  /**
   * AgentProxy::getHostInfo -
   *  access method for hostInfo member.
   *
   * @return 
   * the hostname:port of the remote agent which this proxy represents
   *
   * @version
   * 2001.04.25 alokem creation
   */
  public String getHostInfo() {
    return hostInfo;
  } // AgentProxy::getHostInfo

  //----------------------------------------------------------- display method

  /**
	 * AgentProxy::toString -
	 *  display the GdmoObject attributes of this object.
	 *
	 * @return 
   * string describing this object
	 *
	 * @version
	 * 2001.04.25 alokem creation
	 */
  public String toString() {
    return new String(super.toString() + " HostInfo: " + hostInfo);
  } // AgentProxy::toString

} // class AgentProxy
