/*
 * CLIManager.java
 * 
 * usage: java CLIManager [hostname:port [startupfile]]
 * 
 * hostname:port    host:port that this Agent will listen on -
 *                  defaults to localhost:4444
 * startupfile      file containing magenta commands to process
 *                  same syntax as command line
 *
 * history:
 * 2001.04.25 alokem creation
 * 2001.11.10 alokem add startupfile option
 */

package magenta;

import java.io.*;
import java.net.*;
import java.util.*;
import magenta.*;

/**
 * class CLIManager -
 *  An example management application that implements a simple 
 *  interactive command-line interface for a Magenta Agent.  This class 
 *  can also be used as a template for user defined management applications.
 *  This is the main vehicle for customizing Magenta.
 *
 *  A user defined management application (userapp) must contain the
 *  "extends Agent" clause in its declaration.  In general a userapp will
 *  probably override the handleEvent method and the log method.
 *
 *  - The log method allows the userapp to receive and handle internal 
 *    debugging messages from the agent.  An example application would be
 *    to display the messages to a GUI or store the messages to a file for
 *    offline analysis.
 *
 *  - The handleEvent method allows the userapp to receive and handle 
 *    event reports received by the agent.  This would often be used
 *    to allow the userapp to react to changes in its environment - e.g.
 *    allow a chess queen to react to threats from other pieces.
 *  
 *  To allow a userapp to be invoked from the command line you must
 *  include a main() method which would instantiate itself as is done
 *  in this object.
 *
 * @version
 * 2001.04.25 alokem creation
 * 2001.11.10 alokem update comment to reflect design
 */
public class CLIManager extends Agent {

  /// handle to internal CLIManagerThread
  private CLIManagerThread myCLIManagerThread;

  /**
   * CLIManager constructor -
   *  create a CLIManager, start the main thread for command processing.
   *
   * @param path    gdmo path for this object
   * @param name    name for this object
   *
   * @version
   * 2001.11.10 alokem add comment
   */
  public
  CLIManager(String path, String name){
    super(path, name);

    myCLIManagerThread =
      new CLIManagerThread(this);
    myCLIManagerThread.start();
  } // CLIManager ctor

  /**
   * main method -
   *  parse command line arguments and instantiate the CLIManager.
   *  
   * @param args  command-line arguments
   *
   * @version
   * 2001.11.10 alokem initial comment
   * 2001.11.10 alokem allow user to specify a file containing a list of
   *  commands to process
   */
  public static void main(String[] args) 	{
    // detects which port the com manager should listen at
    String hostInfo;

    // file containing commands to process
    String startupFile;

    if (args.length < 1) {
      hostInfo = Agent.DEFAULTHOSTPORT;
    } else {
      hostInfo = args[0];
    }

    if (args.length < 2) {
      startupFile = null;
    } else {
      startupFile = args[1];
    }

    // create the manager
    CLIManager theManager = 
      new CLIManager("", ObjectManager.rootGdmoName);
    theManager.setHostInfo(hostInfo);

    // source the startup file
    if (startupFile != null) {
      theManager.log(theManager.myCLIManagerThread.processFile(startupFile));
    }
  } // CLIManager::main
} // class CLIManager