/*
 * ComManagerThread.java
 *
 * history:
 * 2001.04.28 alokem creation
 */

package magenta;

import java.net.*;
import java.io.*;

/**
 * class ComManagerThread -
 *  handle incoming messages from a single client.
 *
 * @author  aloke mukherjee
 * @version 
 * 2001.04.25 alokem creation
 */
public class ComManagerThread extends Thread {
  /** socket for reading incoming message */
  private Socket socket = null;

  /** so we can invoke processMessage */
  private ComManager myComManager = null;

  /**
   * ComManagerThread constructor -
   *  set member variables.
   *
   * @param socket  socket for incoming messages
   * @param cm      handle on ComManager
   *
   * @version
   * 2001.04.25 alokem creation
   */
  public ComManagerThread(Socket socket, ComManager cm) {
	  super("ComManagerThread");
	  this.socket = socket;
    myComManager = cm;
  } // ComManagerThread constructor

  /**
   * ComManagerThread::run -
   *  read and process message from socket.
   *
   * @version
   * 2001.04.25 alokem creation
   */
  public void run() {
  	try {
      // FIXME slow the simulation down a bit
      try { sleep(100); } catch (InterruptedException e) {};

	    BufferedReader in = new BufferedReader(
				    new InputStreamReader(
				    socket.getInputStream()));

	    String inputCmd, result;

      inputCmd = in.readLine();

      result = myComManager.processMessage(inputCmd);

      // only send back the result if the sender cares (i.e. it wasn't an event)
      if (result.compareTo("eventreport") != 0) {
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        out.println(result);
	      out.close();
      }

 	    in.close();
	    socket.close();
  	} catch (IOException e) {
	    e.printStackTrace();
	  } // end try
  } // ComManagerThread::run
} // class ComManagerThread
