import java.lang.*;
import java.util.*;
import magenta.*;

/**
 * class community
 */
public class community extends GdmoObject {

  Vector propertyList;
  Hashtable propertyValue;

  public community(String path, String name){
    super(path, name);

    propertyList = new Vector();
    propertyValue = new Hashtable();

    propertyList.add("name");
    propertyList.add("description");
    propertyList.add("keywords");
    propertyList.add("category");
    propertyList.add("security");
    propertyList.add("protocol");
    propertyList.add("schema");
    propertyList.add("stylesheet");
    propertyList.add("url");
  }

  /**
   * community::set -
   *  overloaded version of GdmoObject::set that handles
   *  sets of properties that do not have corresponding methods.
   *
   * @param attributeName   attribute of this object to set
   * @param attributeValue  value to set attribute to
   *
   * @returns 
   *
   * @version
   * 2001.11.12 alokem add event notification
   */
  public String 
  set(String attributeName, String attributeValue) {
    String retval;

    // first look for setAttributeName method
    retval = super.set(attributeName, attributeValue);
    
    // if not found, check if attribute exists and set it
    // if found
    if (retval == null) {
      if (propertyList.contains(attributeName)) {
        propertyValue.put(attributeName, attributeValue);
        retval = new String("success");
        setChanged();
        notifyObservers(attributeName + ObjectManager.requestDelimiter + 
         attributeValue.toString());
      } // attribute found in property list
    } // if setAttributeName method not found

    return retval;
  } // community::set

  public Object
  get(String attributeName) {
    Object retval;

    // first look for getAttributeName method
    retval = super.get(attributeName);

    // if not found, check if attribute exists and get the
    // value if found
    if (retval == null) {
      if (propertyList.contains(attributeName)) {
        retval = propertyValue.get(attributeName);
        if (retval == null) {
          retval = new String("(null)");
        } // if value has not been set
      } // if this is a valid property
    } // no method getAttributeName was found

    return retval;
  } // community::get

  public String toString() {
    String retval = new String(super.toString());
    Iterator propertyIter = propertyList.iterator();

    while (propertyIter.hasNext()) {
      String property = (String)propertyIter.next();
      retval = retval + " " + property + ": " + get(property);
    }

    return retval;
  }

} // class community
