/*
 * Decompiled with CFR 0.152.
 */
package javax.infobus;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusMember;
import javax.infobus.InfoBusMembershipException;

public class InfoBusMemberSupport
implements InfoBusMember {
    static final byte Copyright_1997_1998_Lotus_Development_Corporation_All_Rights_Reserved = 1;
    protected InfoBus m_infoBus;
    protected PropertyChangeSupport m_propSupport;
    protected VetoableChangeSupport m_vetoSupport;
    protected InfoBusMember m_sourceRef;
    protected Object m_syncLock;

    public InfoBusMemberSupport(InfoBusMember infoBusMember) {
        this.m_sourceRef = infoBusMember != null ? infoBusMember : this;
        this.m_propSupport = new PropertyChangeSupport(this.m_sourceRef);
        this.m_vetoSupport = new VetoableChangeSupport(this.m_sourceRef);
        this.m_syncLock = new Object();
    }

    public InfoBusMemberSupport() {
        this(null);
    }

    public void setInfoBus(InfoBus infoBus) throws PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.m_vetoSupport.fireVetoableChange("InfoBus", this.m_infoBus, infoBus);
            InfoBus infoBus2 = this.m_infoBus;
            this.m_infoBus = infoBus;
            this.m_propSupport.firePropertyChange("InfoBus", infoBus2, infoBus);
            if (this.m_infoBus != null) {
                this.m_infoBus.register(this.m_sourceRef);
            }
            return;
        }
    }

    public InfoBus getInfoBus() {
        return this.m_infoBus;
    }

    public void joinInfoBus(String string) throws InfoBusMembershipException, PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (string == null) {
                throw new NullPointerException("joinInfoBus needs a String or Component argument");
            }
            if (this.getInfoBus() != null) {
                throw new InfoBusMembershipException("InfoBus property already set");
            }
            InfoBus infoBus = InfoBus.get(string);
            try {
                infoBus.join(this.m_sourceRef);
            }
            finally {
                Object var6_4 = null;
                infoBus.release();
            }
            return;
        }
    }

    public void joinInfoBus(Component component) throws InfoBusMembershipException, PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (component == null) {
                throw new NullPointerException("joinInfoBus needs a String or Component argument");
            }
            if (this.getInfoBus() != null) {
                throw new InfoBusMembershipException("InfoBus property already set");
            }
            InfoBus infoBus = InfoBus.get(component);
            try {
                infoBus.join(this.m_sourceRef);
            }
            finally {
                Object var6_4 = null;
                infoBus.release();
            }
            return;
        }
    }

    public void leaveInfoBus() throws InfoBusMembershipException, PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (this.getInfoBus() == null) {
                throw new InfoBusMembershipException("InfoBus property already set to NULL");
            }
            this.getInfoBus().leave(this.m_sourceRef);
            return;
        }
    }

    public void addInfoBusVetoableListener(VetoableChangeListener vetoableChangeListener) {
        this.m_vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeInfoBusVetoableListener(VetoableChangeListener vetoableChangeListener) {
        this.m_vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addInfoBusPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeInfoBusPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

