/*
 * Decompiled with CFR 0.152.
 */
package javax.infobus;

import java.util.Enumeration;
import java.util.Vector;
import javax.infobus.DefaultController;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataController;
import javax.infobus.InfoBusMembershipException;

class PrioritizedDCList
implements Cloneable {
    static final byte Copyright_1997_1998_Lotus_Development_Corporation_All_Rights_Reserved = 1;
    private Vector m_controllerList;
    private Vector m_priorityList;
    private InfoBus m_parentIB;
    private transient Object m_syncLock;

    PrioritizedDCList(int n, int n2, InfoBus infoBus) {
        this.m_parentIB = infoBus;
        this.m_controllerList = new Vector(n, n2);
        this.m_priorityList = new Vector(n, n2);
        this.m_syncLock = new Object();
    }

    void addDataController(InfoBusDataController infoBusDataController, int n) throws InfoBusMembershipException {
        int n2 = n < 1 && !(infoBusDataController instanceof DefaultController) ? 1 : (n > 5 && n != 6 ? 5 : n);
        if (this.m_controllerList.contains(infoBusDataController)) {
            throw new InfoBusMembershipException("Attempt to add DataController already present on InfoBus;  InfoBus:  " + this.m_parentIB.getName() + ", controller: " + infoBusDataController.toString());
        }
        int n3 = this.m_priorityList.size();
        int n4 = 0;
        boolean bl = false;
        while (!bl && n4 < n3) {
            Integer n5 = (Integer)this.m_priorityList.elementAt(n4);
            if (n5 < n) {
                bl = true;
                continue;
            }
            ++n4;
        }
        this.m_controllerList.insertElementAt(infoBusDataController, n4);
        this.m_priorityList.insertElementAt(new Integer(n2), n4);
    }

    void removeDataController(InfoBusDataController infoBusDataController) {
        int n = this.m_controllerList.indexOf(infoBusDataController);
        if (n < 0) {
            return;
        }
        this.m_controllerList.removeElementAt(n);
        this.m_priorityList.removeElementAt(n);
    }

    Vector getDCclone() {
        Object object = this.m_syncLock;
        synchronized (object) {
            Vector vector = (Vector)this.m_controllerList.clone();
            Object var3_3 = null;
            return vector;
        }
    }

    public Object clone() {
        Object object = this.m_syncLock;
        synchronized (object) {
            PrioritizedDCList prioritizedDCList = null;
            try {
                prioritizedDCList = (PrioritizedDCList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.out.println("InfoBus internal error [PrioritizedDCList] : " + cloneNotSupportedException.toString());
            }
            prioritizedDCList.m_controllerList = (Vector)this.m_controllerList.clone();
            prioritizedDCList.m_priorityList = (Vector)this.m_priorityList.clone();
            PrioritizedDCList prioritizedDCList2 = prioritizedDCList;
            Object var3_5 = null;
            return prioritizedDCList2;
        }
    }

    int size() {
        return this.m_controllerList.size();
    }

    InfoBusDataController controllerAt(int n) {
        return (InfoBusDataController)this.m_controllerList.elementAt(n);
    }

    int priorityAt(int n) {
        Integer n2 = (Integer)this.m_priorityList.elementAt(n);
        return n2;
    }

    Enumeration elements() {
        return this.m_controllerList.elements();
    }
}

