import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
//import swap.beanbox.*;


public class NewGameBoardBean2 extends Canvas implements Runnable, PropertyChangeListener,
                                                               MouseListener {
                                                                
    static final long serialVersionUID = 5212051876891061773L;                                                                
    private int newDim = 10;
	private int newWidth = 300, cellWidth = newWidth / newDim;
	private Point upperLeftPoint;	
	private boolean[][] status, statusBackup;	
	private transient Thread aThread;
	private int newRate = 400;
	private PropertyChangeSupport changes = new PropertyChangeSupport(this);	
	private boolean running = false;
	
	public long getSerialVersionUID(){
	    return serialVersionUID;
	}
		
	public int getNewDim() {return newDim;}
	public void setNewDim(int aNewDim) {
	    int oldNewDim = newDim;
	    newDim = aNewDim;
	    changes.firePropertyChange("NewDim", oldNewDim, newDim);
	}
	
	public void swapSetNewDim(int aNewDim) {setNewDim(aNewDim);}
	
	public int getNewWidth() {return newWidth;}
	public void setNewWidth(int aNewWidth) {
	    int oldNewWidth = newWidth;
	    newWidth = aNewWidth;
	    changes.firePropertyChange("NewWidth", oldNewWidth, newWidth);
    }
    
    public void swapSetNewWidth(int aNewWidth) {setNewWidth(aNewWidth);}
    
    public int getNewRate() {return newRate;}
	public void setNewRate(int aRate) {newRate = aRate;}
	
	public void swapSetNewRate(int aRate) {setNewRate(aRate);}
	
	public boolean isRunning() {return running;}
	public void setRunning (boolean aRunning) {
	    boolean oldRunning = running;
	    synchronized (this) {
	        running = aRunning;	        
	        changes.firePropertyChange("Running", oldRunning, running);	        
	    }
	}
	
	public void swapSetRunning (boolean aRunning) {
	    setRunning(aRunning);
	}
	
	public boolean[][] swapGetStatus() {
	    return status;
	}
	
	public synchronized void swapSetStatus(boolean[][] s) {
	    // This is a two-newDimal array, but both dimension has the same value
	    /*if (running) {
	        setRunning(false);
	    }*/
	    
	    for (int i = 0; i < s.length; i++) {
	        for (int j = 0; j < s[i].length; j++) {
	            status[i][j] = s[i][j];
	        }
	    }
	}
	
	public void swapMethod() {
	    repaint();
	}
	    
	public void addPropertyChangeListener (PropertyChangeListener l){
	    changes.addPropertyChangeListener(l);
	}
	
	public void removePropertyChangeListener (PropertyChangeListener l){
	    changes.removePropertyChangeListener(l);
	}
	
	public void propertyChange(PropertyChangeEvent evt){	    
	    if(evt.getPropertyName().equals("NewDim")){	       
	        synchronized (this) {
	            cellWidth = newWidth / newDim;
	            initializeStatus();
	            running = false;
	        }	       
	    }
	   if(evt.getPropertyName().equals("NewWidth")){	        
	        setSize(newWidth,newWidth);
	        setBackground(Color.white);
	        cellWidth = newWidth / newDim;	        
	    }
	    if (evt.getPropertyName().equals("Running")){	       
	        synchronized (this) {	            
	            if (running){	                
	                notify();
	            }
	        }
	    }
	}
	
	public void mouseClicked  (MouseEvent event) {}
	public void mouseEntered  (MouseEvent event) {}
	public void mouseExited   (MouseEvent event) {}
	public void mouseReleased (MouseEvent event) {}
	public void mousePressed  (MouseEvent event) {
	    if (!running){
	        int x = event.getX();
		    int y = event.getY();
		    int columnNum = (x - upperLeftPoint.x) / cellWidth;
		    int rowNum = (y - upperLeftPoint.y) /cellWidth;
		    if (!(rowNum < 0 || rowNum >= newDim ||columnNum < 0 ||columnNum >= newDim)){
			    if(status[rowNum][columnNum])
				    status[rowNum][columnNum] = false;
			    else
				    status[rowNum][columnNum] = true;
			    repaint();
		    }
	    }
	}
	public NewGameBoardBean2(){
	    setSize(newWidth,newWidth);
	    addPropertyChangeListener(this);
	    addMouseListener(this);
	    setBackground(Color.white);
	    initializeStatus();
	    aThread = new Thread(this);
	    aThread.start();
	}
	
	private void initializeStatus(){
	    status = new boolean[newDim][newDim];
	    statusBackup = new boolean[newDim][newDim];
	    for(int i = 0; i < newDim; i++){
	        for(int j = 0; j < newDim; j++){
	            status[i][j] = false;	           
	        }
	    }  
	}
	
	private void genenewRateNewLife(){
	    int aan;
	    //int rowStart, rowEnd, columnStart, columnEnd;
	     for(int i = 0; i < newDim; i++){
	        for(int j = 0; j < newDim; j++){
	            statusBackup[i][j] = status[i][j];
	        }
	    }
	    for(int i = 0; i < newDim; i++){
	        for(int j = 0; j < newDim; j++){	            
	            aan = 0;
	            for (int row_i = -1; row_i < 2; row_i++){	                
	                if ((i + row_i) >= 0 && (i + row_i) < newDim) {	                    
	                    for (int column_j = -1; column_j < 2; column_j++) {	                       
	                        if ((j + column_j) >= 0 && (j + column_j) < newDim) {	                           
	                            if (status[i + row_i][j + column_j]) {
	                                aan++;
	                            }
	                        }
	                    }
	                }
	            }
	            if(status[i][j]){
	                aan--;
	                if(aan < 2 || aan > 3)
	                statusBackup[i][j] = false;
	            }
	            else{
	                if(aan == 3)
	                statusBackup[i][j] = true;
	            }
	        }
	    }
	    for(int i = 0; i < newDim; i++){
	        for(int j = 0; j < newDim; j++){
	            status[i][j] = statusBackup[i][j];
	        }
	    }
	}
	
	private int get(int benchmark, int b){
	    if (benchmark == 0){
	        if (b < benchmark)
	            return benchmark;
	        else
	            return b;
	    }
	    else{
	        if (b > benchmark)
	            return benchmark;
	        else
	            return b;
	    }
	}
	
	public void paint(Graphics g){
		drawLines();
		int x = upperLeftPoint.x;
		int y = upperLeftPoint.y;
		for(int i = 0; i < newDim; i++){
			for(int j = 0; j < newDim; j++){
				if (status[i][j]){
				    g.setColor(new Color((float)Math.random(),
				                         (float)Math.random(),
				                         (float)Math.random()));
					g.fill3DRect(x, y, cellWidth, cellWidth, true);
				}
				x = x + cellWidth;
			}
			y = y + cellWidth;
			x = upperLeftPoint.x;
		}
	}
	
	private void drawLines(){
		Graphics g = getGraphics();
		upperLeftPoint = getLocation();
		
		int x = upperLeftPoint.x;
		int y = upperLeftPoint.y;
		for(int i = 0; i <= newDim; i++){
			g.drawLine(x, y, x, y + newWidth);
			x = x + cellWidth;
		}
		
		x = upperLeftPoint.x;
		y = upperLeftPoint.y;
		for(int i = 0; i <= newDim; i++){
			g.drawLine(x, y, x + newWidth, y);
			y = y + cellWidth;
		}
	}
	
	/*public synchronized void start () {
	    if (aThread == null) {
	        aThread = new Thread (this);
	        aThread.start();
	    }
	    running = true;
	    notify();
	}*/
	
	public synchronized void newStart () {
	    if (aThread == null) {
	        aThread = new Thread (this);
	        aThread.start();
	    }
	    running = true;
	    notify();
	}
	
	
	public void stop () {
	    running = false;
	}
	
	public void run(){
	    int count = 0;
	    try{
	        while(true){
	            synchronized (this){
	                while (!running){
	                    wait();
	                }
	            }
	            repaint();
	            genenewRateNewLife();
	            Thread.sleep(newRate);
	        }
	    }
	    catch(Exception e){
	    }
	}
}
	            
	
	