package carleton.swapbox;

import java.util.*;
import java.lang.reflect.Method;
import java.io.*;
import org.xml.sax.*;
import org.w3c.dom.*; 
import javax.xml.parsers.*;
import sun.beanbox.*;

public abstract class AbstractSwapManager implements Serializable, TimerRequester{
    /**
      * Wrapper is an existed class in beanbox package. It provides many
      * facilities to manipulate behaviors at beans, e.g., add/remove
      * listeners, displaying focus box and so on
      */
    protected Wrapper newWrapper;
    protected Wrapper oldWrapper;
    protected AdapterCenter ac = AdapterCenter.getInstance();
    
    /** bb is used when the old bean is being purged off from displaying
      * beanbox. It has nothing to do with the swap transaction itself.
      */
    // private SwapBox bb;
    protected boolean expire;
    // protected SwapConfiguration config;
    protected Document document;
    
    public void setOldWrapper(Wrapper w) {
        oldWrapper = w;
    }
    
    public void setNewWrapper(Wrapper w) {
        newWrapper = w;
    }
           
    public synchronized void timeUp() {
        expire = true;
    }
    
    /**
      * Return true if class a is either equivalent to class b, or if
      * class a is a subclass of class b.
      * Note that either or both "Class" object may represent interfaces.
      * @param a the class to be compared
      * @param b the benchmark class
      */
    protected static boolean isSubclass (Class a, Class b) {
        /**
          * We rely on the fact that for any given java class or primitive type
          * there is a unique Class object, so we can use object equivalence in
          * the comparisons.
          */
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class interfaces[] = x.getInterfaces();
                for (int i = 0; i < interfaces.length; i++) {
                    if (interfaces[i] == b) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    
    protected void createListenersForNewBean() {
        Object oldBean = oldWrapper.getBean();
        Object newBean = newWrapper.getBean();
        
        //SwapReport aReport = ac.report(newBean, oldBean);
        //AdapterCenter ac = AdapterCenter.getInstance();
        SwapReport aReport = ac.report(newBean, oldBean);
        
        Vector v = aReport.getUnchangedEvents(); // array may be better because it is type safe
        //System.out.println("I am at the createListernersForNewBean position 1");
        //System.out.println("The size of unchanged eevnts is: " + v.size());
        ac.addInvalidWrapper(newWrapper, oldWrapper);
        for (int i = 0 ; i < v.size(); i++){
            SwapEventInfo sei = (SwapEventInfo)v.elementAt(i);
            // In  order to achieve block effect, we block the service of the old bean here rather 
            // than later after creating adapters for the new bean. This can demonstrate our 
            // block strategy does work. In the real case, it is better to block the service of the
            // old bean after creating the adapters for the new bean, because it is a time-consuming
            // job and swap transaction is time sensitive.
            // <p>
            // Only if the adapter is the target does it need to block the service.
            if (sei.isTarget(oldBean)) {
                SwapHookupManager.hookup(sei.getEvent(), sei.getListenerMethod(), sei.getSource(),
                                     newWrapper, sei.getTargetMethod(), sei.getEventName(), true);
                //ac.addInvalidWrapper(newWrapper, oldWrapper);

			} else {
				SwapHookupManager.hookup(sei.getEvent(), sei.getListenerMethod(), newWrapper,
				                     sei.getTarget(), sei.getTargetMethod(), sei.getEventName(), true);
				//ac.addInvalidWrapper(newWrapper, oldWrapper);
			}
        }
    }       

    protected void blockOldBeanService() {
        BeanReport br = ac.getBeanReport(oldWrapper.getBean());
        Vector oldBeanIncoming = br.getIncomingEvents();
        
        br = ac.getBeanReport(newWrapper.getBean());
        Vector newBeanIncoming = br.getIncomingEvents();
        Vector newBeanOutgoing = br.getOutgoingEvents();
        
        // block incoming events for the old bean. Those events are queued at the adapter.
        for (int i = 0; i < oldBeanIncoming.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)oldBeanIncoming.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setBlock(true);
        }
        
        // set new bean able to accept incoming events. Those evetns are queued at the adapter
        for (int i = 0; i < newBeanIncoming.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)newBeanIncoming.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setService(true);
        }
        for (int i = 0; i < newBeanOutgoing.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)newBeanOutgoing.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setService(true);
        }
    }    
    
    protected void unblockService(Wrapper aWrapper) {
        BeanReport br = ac.getBeanReport(aWrapper.getBean());
        Vector incomingEvents = br.getIncomingEvents();
        //System.out.println("****Incoming event size: "+ incomingEvents.size());
        for (int i = 0; i < incomingEvents.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)incomingEvents.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setBlock(false);
        }
        if (aWrapper == newWrapper) {
            Vector outgoingEvents = br.getOutgoingEvents();
            for (int i = 0; i < outgoingEvents.size(); i++) {
                SwapEventInfo sei = (SwapEventInfo)outgoingEvents.elementAt(i);
                ((SwapAdapter)sei.getAdapter()).setBlock(false);
            }
        }
    }
        
    protected void cleanup(Wrapper aWrapper) {
        /**
          * Since the Wrapper class does not store information of events in which 
          * it is the target. We have to find it out at AdapterCenter class, and
          * then clean them up at the source wrapper.
          */
        BeanReport br = ac.getBeanReport(aWrapper.getBean());
        //System.out.println("I am after the adapter center invocation");
        if (br.getIncomingEvents().size() > 0) {
            Vector v = br.getIncomingEvents();
            Vector tempV = (Vector)v.clone();
            for (int i = 0; i < tempV.size(); i++) {
                SwapEventInfo sei = (SwapEventInfo)tempV.elementAt(i);
                Wrapper source = sei.getSource();
                source.swapRemoveOneListener(sei);
            }
        }
        
        //System.out.println("I am at the position 2");
        /**
          * Now we remove adaptors in which aWrapper is the source. 
          */
        if (aWrapper == oldWrapper) {
            //System.out.println("I am at the position 3");
            aWrapper.swapRemoveListeners();
            //System.out.println("I am at the position 4");
            ac.removeOne(aWrapper, true);
            //System.out.println("I am at the position 5");
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).removeOne(aWrapper);
            //BeanBoxFrame.getCurrentBeanBox().removeOne(aWrapper);
        } else if(aWrapper == newWrapper) {
            aWrapper.swapRemoveListeners();
            aWrapper.listenForMice(true);
            ac.removeOne(aWrapper, false);
        }
        
        //System.out.println("I am at the position 1");               
        /**
          * It's time to unblock services at adaptors
          */
        if (aWrapper == oldWrapper) {
            br = ac.getBeanReport(newWrapper.getBean());
        } else if (aWrapper == newWrapper) {
            br = ac.getBeanReport(oldWrapper.getBean());
        }
        Vector incomingEvents = br.getIncomingEvents();
        Vector outgoingEvents = br.getOutgoingEvents();
        for (int i = 0; i < incomingEvents.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)incomingEvents.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setService(true);
            ((SwapAdapter)sei.getAdapter()).setBlock(false);
        }
        for (int i = 0; i < outgoingEvents.size(); i++) {
            SwapEventInfo sei = (SwapEventInfo)outgoingEvents.elementAt(i);
            ((SwapAdapter)sei.getAdapter()).setBlock(true);
            ((SwapAdapter)sei.getAdapter()).setBlock(false);
        }
        //System.out.println("I am at the bottom of clean up method");
    }
    
    public void swap() throws SwapException {
        NodeList nodeList = document.getElementsByTagName(preProcessTagName);
        
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == Node.ELEMENT_NODE) {
            handlePreProcess(nodeList.item(0));
        } else {
            throw new SwapException("SwapManager: Parse pre_process node failed");
        }     
        
        nodeList = document.getElementsByTagName(interactionPolicyTagName);
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == Node.ELEMENT_NODE) {
            //System.out.println("I am goint to handle interactions");
            handleInteraction(nodeList.item(0));
        } else {
            throw new SwapException("SwapManager: Parse interaction node failed");
        }
        
        nodeList = document.getElementsByTagName(statesPolicyTagName);
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == Node.ELEMENT_NODE) {
            handleState(nodeList.item(0));
        } else {
            throw new SwapException("SwapManager: Parse state_policy node failed");
        } 
        
        nodeList = document.getElementsByTagName(postProcessTagName);
        if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == Node.ELEMENT_NODE) {
            handlePostProcess(nodeList.item(0));
        } else {
            throw new SwapException("SwapManager: Parse post_process node failed");
        } 
    }
    
    public abstract void handlePreProcess(Node node) throws SwapException;
    
    public abstract void handlePostProcess(Node node) throws SwapException;
    
    public abstract void handleState(Node node) throws SwapException;
    
    public abstract void handleInteraction(Node node) throws SwapException;
    
    protected static final String preProcessTagName = "pre_process";
    protected static final String postProcessTagName = "post_process";
    protected static final String interactionPolicyTagName = "interaction_policy";
    protected static final String statesPolicyTagName = "state_policy";
        
}