package carleton.swapbox;

import java.util.*;
import java.io.*;
import java.beans.*;
import java.lang.reflect.Method;
import sun.beanbox.*;

public class AdapterCenter implements Serializable {
    
    protected int arraySize = 30;
    protected String[] names;
    protected Wrapper[] wrappers;
    protected Vector[] interactions;
    protected Wrapper[] newBeans;
    protected int[] invocations;
    protected static AdapterCenter _theInstance = null;
    
    protected AdapterCenter() {
        names = new String[arraySize];
        wrappers = new Wrapper[arraySize];
        interactions = new Vector[arraySize];
        newBeans = new Wrapper[arraySize];
        invocations = new int[arraySize];
        
        for (int i = 0; i < arraySize; ++i) {
            names[i] = null;
            wrappers[i] = null;
            interactions[i] = null;
            newBeans[i] = null;
            invocations[i] = 0;
        }
    }
    
    public static AdapterCenter getInstance() {
        if (_theInstance == null) {
            _theInstance = new AdapterCenter();
        }
        return _theInstance;
    }
    
    public synchronized void addEntry (SwapEventInfo sei) {
        //System.out.println("Add an swap event info");
        //System.out.println(sei);
        Wrapper s = sei.getSource();
        Wrapper t = sei.getTarget();
        
        for (int i = 0; i < arraySize; ++i) {
            if (wrappers[i] == s || wrappers[i] == t) {
                if (interactions[i] == null) {
                    interactions[i] = new Vector();
                }
                interactions[i].addElement(sei);
            }
        }
    }
	
	public synchronized void removeEntry (SwapEventInfo sei) {
		Wrapper s = sei.getSource();
		Wrapper t = sei.getTarget();
		
		for (int i = 0; i < arraySize; ++i) {
		    if (wrappers[i] == s || wrappers[i] ==t) {
		        if (interactions[i] != null) {
		            interactions[i].removeElement(sei);
		        }
		    }
		}
	}
	
	public void addInvalidWrapper(Wrapper newWrapper, Wrapper oldWrapper) {
	    for (int i = 0; i < arraySize; ++i) {
	        if (wrappers[i] == oldWrapper) {
	            newBeans[i] = newWrapper;
	        }
	    }
	}
	
	public String isInvalidWrapper (Wrapper w) {
	    for (int i = 0; i < arraySize; ++i) {
	        if (wrappers[i] == w && newBeans[i] != null) {
	            return getBeanName(newBeans[i]);
	        }
	    }
	    return null;
	}
    
    public SwapReport report (Object newBean, Object oldBean) {
        if (newBean == null || oldBean == null) {
            System.out.println("Nothing to report");
            return null;
        }else{
            return compare (newBean.getClass(), oldBean);
        }
    }
    
    public boolean isNameValid(String aName, Wrapper w){
        for (int i = 0; i < arraySize; ++i) {
            if (aName.equals(names[i])) {
                return false;
            }
        }
        
        int s = -1;
        for (int i = 0; i < arraySize; ++i) {
            if (names[i] == null) {
                s = i;
                break;
            }
        }
        if (s == -1) {
            int t = arraySize;
            arraySize *= 2;
            String[] oldN = names;
            Wrapper[] oldW = wrappers;
            Vector[] oldIT = interactions;
            Wrapper[] oldNB = newBeans;
            int[] oldIN = invocations;
            
            names = new String[arraySize];
            wrappers = new Wrapper[arraySize];
            interactions = new Vector[arraySize];
            newBeans = new Wrapper[arraySize];
            invocations = new int[arraySize];
            
            for (int i = 0; i < t; ++i) {
                names[i] = oldN[i];
                wrappers[i] = oldW[i];
                interactions[i] = oldIT[i];
                newBeans[i] = oldNB[i];
                invocations[i] = oldIN[i];
            }
            
            for (int i = t + 1; i < arraySize; ++i) {
                names[i] = null;
                wrappers[i] = null;
                interactions[i] = null;
                newBeans[i] = null;
                invocations[i] = 0;
            }
            
            s = t;
        }
        names[s] = aName;
        wrappers[s] = w;
        return true;
    }
    
    public String getBeanName(Wrapper w) {
        for (int i = 0; i < arraySize; ++i) {
            if (wrappers[i] == w) {
                return names[i];
            }
        }
        return null;
    }
    
    public synchronized void removeOne(Wrapper w, boolean isOld) {
        /**
          * Remove the wrapper w from the invalid wrapper list. The invalid wrappers
          * list is used for containing wrappers which are at the transition stage.
          * <p>
          * For the oldWrapper(isOld is true), the wrapper and name pair should be removed either.
          * This is the last step in a succcesful swap transaction. For the newWrapper, the wrapper
          * and name pair should keep intact. It is part of recover job for an unsuccessful
          * swap transaction.
          */
        // First remove interactions attached to other beans
        for (int i = 0; i < arraySize; ++i) {
            if (wrappers[i] == w && interactions[i] != null) {
                Vector v = interactions[i];
                for (int j = 0; j < v.size(); ++j) {
                    SwapEventInfo sei = (SwapEventInfo)v.elementAt(j);
                    Wrapper s = sei.getSource();
                    Wrapper t = sei.getTarget();
                    int k = 0;
                    while (k != i && k++ < arraySize) {
                        if (wrappers[k] == s || wrappers[k] == t) {
                            interactions[k].remove(sei);
                        }
                    }
                }
                break;
            }
        }      
        
        if (!isOld) {  // The bean is new bean, abort the transaction
            for (int i = 0; i < arraySize; ++i) {
                if (newBeans[i] == w) {
                    newBeans[i] = null;
                    for (int j = 0; j < arraySize; ++j) {
                        if (wrappers[j] == w) {
                            interactions[j] = null;
                            break;
                        }
                    }
                    break;
                }
            }
        } else {   // The bean is old bean, initialize the slot for the future use
            for (int i = 0; i < arraySize; ++i) {
                if (wrappers[i] == w) {
                    //System.out.println("The old bean name is: " + names[i]);
                    names[i] = null;
                    wrappers[i] = null;
                    interactions[i] = null;
                    newBeans[i] = null;
                    invocations[i] = 0;
                    break;
                }
            }
        }
                            
    }
    
     /**
     * Return true if class a is either equivalent to class b, or
     * if class a is a subclass of class b.
     * Note tht either or both "Class" objects may represent interfaces.
     */
    static boolean isSubclass(Class a, Class b) {
	// We rely on the fact that for any given java class or
        // primtitive type there is a unqiue Class object, so
	// we can use object equivalence in the comparisons.
	if (a == b) {
	    return true;
	}
	if (a == null || b == null) {
	    return false;
	}
	for (Class x = a; x != null; x = x.getSuperclass()) {
	    if (x == b) {	
		return true;
	    }
	    if (b.isInterface()) {
		Class interfaces[] = x.getInterfaces();
		for (int i = 0; i < interfaces.length; i++) {
		    if (interfaces[i] == b) {
			return true;
		    }
		}
	    }
	}
	return false;
    }
    
    private SwapReport compare (Class newBeanClass, Object oldBean) {
        //System.out.println("I am at begining of compare method");
        SwapReport aReport = new SwapReport();
        Vector eventSource = new Vector();
        Vector eventTarget = new Vector();
        boolean found;
        
        for (int i = 0; i < arraySize; ++i) {
            if (wrappers[i] != null && wrappers[i].getBean() == oldBean) {
                Vector its = interactions[i];
                if (its != null) {
                    for (int j = 0; j < its.size(); ++j) {
                        SwapEventInfo sei = (SwapEventInfo)its.elementAt(j);
                        if (sei.isSource(oldBean)) {
                            eventSource.addElement(sei);
                        } else if(sei.isTarget(oldBean)) {
                            eventTarget.addElement(sei);
                        }
                    }
                }
                break;
            }
        }
        
		for (int m = 0; m < eventTarget.size(); m++) {
			SwapEventInfo sei = (SwapEventInfo)eventTarget.elementAt(m);
			try {
		         MethodDescriptor mds[] = Introspector.getBeanInfo(newBeanClass).getMethodDescriptors();
		         Class eargs[] = sei.getTargetMethod().getParameterTypes();
		         Class eExceptions[] = sei.getTargetMethod().getExceptionTypes();
                 found = false;
                 
                 for (int i = 0; i < mds.length; i++) {
                    MethodDescriptor md = mds[i];
                    Class margs[] = md.getMethod().getParameterTypes();
                    Class mExceptions[] = md.getMethod().getExceptionTypes();
                    
                    if (!(sei.getTargetMethod().getName().equals(md.getName()))) {
                        continue;
                    }
                    if ((eargs.length != margs.length) || (eExceptions.length > mExceptions.length)) {
                        continue;
                    }
                    boolean match = true;
                    // check to see if formal parameter types agree
                    for (int j = 0; j < eargs.length; j++) {
                        if (!isSubclass(eargs[j], margs[j])) {
                            match = false;
                            break;
                        }
		            }
		            
		            // check to see if checked exception types agree
		            for (int j = 0; j < eExceptions.length; j++) {
		                if (!isSubclass(eExceptions[j], mExceptions[j])) {
		                    match = false;
		                    break;
		                }
	                }
	                if (match) {
	                    found = true;
	                    break;
	                }
	             }
	             
	             if (found) {
	                    aReport.addUnchangedEvent(sei);
	                    //matchMethods.addElement(md);
	             } else {
	                aReport.addChangedEvent(sei);
	             }
	        } catch (Exception ex) {
	            //new ErrorDialog(, "AdapterCenter: Unexpected exception: \n" + ex);
	            return null;
	        }
		}
        
        try{
            BeanInfo bi = Introspector.getBeanInfo (newBeanClass);
            EventSetDescriptor[] nesds = bi.getEventSetDescriptors();
            for (int i = 0; i < eventSource.size(); i++){
                SwapEventInfo sei = (SwapEventInfo)eventSource.elementAt(i);
                found = false;
                for (int j = 0; j < nesds.length && !found; j++){
                    if (nesds[j].getName().equals(sei.getEvent().getName())) {
                        found = true;
                        aReport.addUnchangedEvent(sei);
                    }
                }
                if (!found) {
                    aReport.addChangedEvent(sei);
                }
            }
        }catch (Exception e){
            System.out.println("Caught exception in AdapterCenter:\n" + e);
        }
        //System.out.println("I am at the end of compare method");
        return aReport;
    }
    
    public BeanReport getBeanReport(Object aBean) {
        BeanReport br = new BeanReport();
        
        for (int i = 0; i < arraySize; ++i) {
            //System.out.println("****name: " + names[i]);
            if (wrappers[i] != null && wrappers[i].getBean() == aBean) {
                Vector its = interactions[i];
                //System.out.println("****its size is: " + its.size());
                if (its != null) {
                    for (int j = 0; j < its.size(); ++j) {
                        SwapEventInfo sei = (SwapEventInfo)its.elementAt(j);
                        //System.out.println("****\n" + sei);
                        if (sei.isSource(aBean)) {
                            br.addOutgoingEvent(sei);
                            //System.out.println("*****add outgoing event\n" + sei);
                        } else if(sei.isTarget(aBean)) {
                            br.addIncomingEvent(sei);
                            //System.out.println("*****add incoming event\n" + sei);
                        }
                    }
                }
                break;
            }
        }
        return br;
    }
    
    public synchronized void invocationPlus (Object aBean) {
        for(int i = 0; i < arraySize; ++i) {
            if (wrappers[i] != null && wrappers[i].getBean() == aBean) {
                ++invocations[i];
                break;
            }
        }
    }
    
    public synchronized void invocationMinos (Object aBean) {
        for (int i = 0; i < arraySize; ++i) {
            if(wrappers[i] != null && wrappers[i].getBean() == aBean) {
                --invocations[i];
                break;
            }
        }
    }
    
    public boolean isBeanIdle (Object aBean) {
        for (int i = 0; i < arraySize; ++i) {
            if (wrappers[i] != null && wrappers[i].getBean() == aBean) {
                return (invocations[i] == 0);
            }
        }
        return false;
    }	
}
        

