package carleton.swapbox;

import java.io.*;
import java.util.*;
import java.lang.reflect.Method;
import java.beans.*;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.*; 
import sun.beanbox.*;

public class DefaultSwapManager extends AbstractSwapManager {
    private Vector newNames;
    private Vector oldNames;
    
    public DefaultSwapManager (Document document) {
        this.document = document;
        newNames = new Vector();
        oldNames = new Vector();
    }
    
    public void handlePreProcess(Node preProcessNode) throws SwapException {
        //System.out.println("I am at the begining of 1");
        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(false);
        Element element = (Element)preProcessNode;
        NodeList timeConstraint = element.getElementsByTagName("time");
        long time = 0;

        if (timeConstraint.getLength() == 1 && timeConstraint.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList timeText = timeConstraint.item(0).getChildNodes();
            if (timeText.getLength() == 1 && timeText.item(0).getNodeType() == Node.TEXT_NODE
                && timeText.item(0).getNodeValue() != null) {
                    
                try {
                    time = (new Long(timeText.item(0).getNodeValue())).longValue();
                } catch (NumberFormatException nfe) {
                    ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
                    throw new SwapException("SwapManager: Error when converting string to long" +
                                            "\n    The string is not in number format");
                }
            }
        } else {
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw new SwapException("SwapManager: Parsing timeConstraint failed");
        }     
    
         expire = false;
        (new Timer(this)).request(time, false);
        //System.out.println("I am at the end of 1");
    }
    
    protected String getOneElementValue(Element parentElement, String elementName) throws SwapException {
        String s = null;
        NodeList nl = parentElement.getElementsByTagName(elementName);
        if (nl.getLength() == 1 && nl.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList textNode = nl.item(0).getChildNodes();
            if (textNode.getLength() == 1 && textNode.item(0).getNodeType() == Node.TEXT_NODE) {
                s = textNode.item(0).getNodeValue();
            } else {
                throw new SwapException("DefaultSwapManger: Failed in parsing " + elementName);
            }
        } else {
            throw new SwapException("DefaultSwapManger: Failed in parsing " + elementName);
        }
        return s;
    }
    
    protected SwapEventInfo matchSEI(Element cmdElement, Vector seis) throws SwapException {
        SwapEventInfo sei;
        String eventSource, eventName, methodName;
        eventSource = getOneElementValue(cmdElement, "event_source");
        eventName = getOneElementValue(cmdElement, "event_name");
        
        NodeList nl = cmdElement.getElementsByTagName("old_method");
        if (nl.getLength() == 1 && nl.item(0).getNodeType() == Node.ELEMENT_NODE) {
            
            methodName = getOneElementValue((Element)nl.item(0), "method_name");
            NodeList xmlArgs = ((Element)nl.item(0)).getElementsByTagName("parameter_type");
            String[] xmlArgNames = null;
            
            if (xmlArgs.getLength() > 0) {
                xmlArgNames = new String[xmlArgs.getLength()];
                for (int k = 0; k < xmlArgs.getLength(); k++) {
                    NodeList textNode = xmlArgs.item(k).getChildNodes();
                    if (textNode.getLength() == 1 && textNode.item(0).getNodeType() == Node.TEXT_NODE) {
                        xmlArgNames[k] = textNode.item(0).getNodeValue();
                    } else {
                        throw new SwapException("DefaultSwapManger: Failed in parsing parameter_type");
                    }
                }
            }
            
            boolean match;
            for (int i = 0; i < seis.size(); i++) {
                match = true;
                sei = (SwapEventInfo)seis.elementAt(i);
                Class[] mdArgs = sei.getTargetMethod().getParameterTypes();
                if (ac.getBeanName(sei.getSource()).equals(eventSource) &&
                    sei.getEventName().equals(eventName) && 
                    sei.getTargetMethod().getName().equals(methodName) &&
                    mdArgs.length == xmlArgs.getLength()) {
                            
                    for (int j = 0; j < mdArgs.length; j++) {
                        if (!mdArgs[j].getName().equals(xmlArgNames[j])) {
                            match = false;
                            break;
                        }
                    }
                    if (match) {
                        return sei;
                    }
                }
            }
        }
        return null;
    }
    
    protected Method matchTargetMethod(Element cmdElement, MethodDescriptor[] nmds) throws SwapException {
        String methodName;
        Method nmd;
        
        NodeList nl = cmdElement.getElementsByTagName("new_method");
        if (nl.getLength() == 1 && nl.item(0).getNodeType() == Node.ELEMENT_NODE) {
            
            methodName = getOneElementValue((Element)nl.item(0), "method_name");
            NodeList xmlArgs = ((Element)nl.item(0)).getElementsByTagName("parameter_type");
            String[] xmlArgNames = null;
            
            if (xmlArgs.getLength() > 0) {
                xmlArgNames = new String[xmlArgs.getLength()];
                for (int k = 0; k < xmlArgs.getLength(); k++) {
                    NodeList textNode = xmlArgs.item(k).getChildNodes();
                    if (textNode.getLength() == 1 && textNode.item(0).getNodeType() == Node.TEXT_NODE) {
                        xmlArgNames[k] = textNode.item(0).getNodeValue();
                    } else {
                        throw new SwapException("DefaultSwapManger: Failed in parsing parameter_type");
                    }
                }
            }
            
            boolean match;
            for (int i = 0; i < nmds.length; i++) {
                match = true;
                nmd = nmds[i].getMethod();
                Class[] mdArgs = nmd.getParameterTypes();
                
                if (nmd.getName().equals(methodName) && mdArgs.length == xmlArgs.getLength()) {
                    for (int j = 0; j < mdArgs.length; j++) {
                        if (!mdArgs[j].getName().equals(xmlArgNames[j])) {
                            match = false;
                            break;
                        }
                    }
                    if (match) {
                        return nmd;
                    }
                }
            }
        }
        return null;
    }
    
    public void handleInteraction(Node node) throws SwapException {
        //System.out.println("I am at the beginnig of 2");
        SwapReport aReport = ac.report(newWrapper.getBean(), oldWrapper.getBean());
        Vector v = aReport.getChangedEvents();
        /*System.out.println("The unchanged events are: ");
        for (int i = 0; i < v.size(); ++i) {
            System.out.println(((SwapEventInfo)v.elementAt(i)).toString());
        }*/
        MethodDescriptor nmds[] = null;
        
        try {
            nmds = Introspector.getBeanInfo(
                                       newWrapper.getBean().getClass()).getMethodDescriptors();
        } catch (Exception e) {
            throw new SwapException("DefaultSwapManger: " + e.getMessage());
        }
        
        if (v.size() > 0) {
            SwapEventInfo sei;
            Method nmd;
            Element element = (Element)node;
            NodeList cmds = element.getElementsByTagName("change_TargetMethod");
            for (int i = 0; i < cmds.getLength(); i++) {
                sei = matchSEI((Element)cmds.item(i), v);
                nmd = matchTargetMethod((Element)cmds.item(i), nmds);
                //System.out.println("sei is: " + sei);
                //System.out.println("nmd is: " + nmd);
                if (sei != null && nmd != null) {
                    SwapHookupManager.hookup(sei.getEvent(), sei.getListenerMethod(), sei.getSource(),
                                     newWrapper, nmd, sei.getEventName(), true);
                }
            }
        }
        //System.out.println("I am going to enter the createListener method");
        createListenersForNewBean();
        //System.out.println("I am out of the createListener method");
        blockOldBeanService();
        //System.out.println("I am at the end of 2");
    }
    
    private void handleMappingRules(Node stateNode) throws SwapException {
        //System.out.println("I am at the beginging of 3");
        Element element = (Element)stateNode;
        NodeList states = element.getElementsByTagName("state");

        for (int i = 0; i < states.getLength(); i++) {
            if (states.item(i).getNodeType() == Node.ELEMENT_NODE) {
                Element ele = (Element)states.item(i);
                newNames.addElement(ele.getAttribute("newName"));
                oldNames.addElement(ele.getAttribute("oldName"));
            } else {
                throw new SwapException("SwapManager: Parsing XML file failed");
            }
        }
        if (newNames.size() != oldNames.size()) {
            throw new SwapException("SwapManager: State Transfer not in Pair");
        }
        
        PropertyDescriptor oldPs[], newPs[];
        try {
            BeanInfo bi = Introspector.getBeanInfo(oldWrapper.getBean().getClass());
            oldPs = bi.getPropertyDescriptors();
            bi = Introspector.getBeanInfo(newWrapper.getBean().getClass());
            newPs = bi.getPropertyDescriptors();
        } catch (IntrospectionException ex) {
            throw new SwapException("MappingRulesState: Couldn't introspect" + ex);
        }
        Class oldClass = oldWrapper.getBean().getClass();
        Class newClass = newWrapper.getBean().getClass();
        Method[] oldMethods = oldClass.getDeclaredMethods();
        Method[] newMethods = newClass.getDeclaredMethods();
        Method oldGetter = null;
        Method newSetter = null; 
        String newName = null;
        String oldName = null; 
        
        for (int i = 0; i < newNames.size(); i++) {
            /*oldName = (String)oldNames.elementAt(i);
            for (int j = 0; j < oldMethods.length; j++) {
                if (oldMethods[j].getName().equalsIgnoreCase("get" + oldName) ||
                    oldMethods[j].getName().equalsIgnoreCase("is" + oldName) ||
                    oldMethods[j].getName().equalsIgnoreCase("swapGet" + oldName)) {
                    oldGetter = oldMethods[j];
                    break;
                }
            }
            
            newName = (String)newNames.elementAt(i);
            for (int j = 0; j < newMethods.length; j++) {
                if (newMethods[j].getName().equalsIgnoreCase("set" + newName) ||
                    newMethods[j].getName().equalsIgnoreCase("swapSet" + newName)) {
                    newSetter = newMethods[j];
                    break;
                }
            }*/
            
            oldName = (String)oldNames.elementAt(i);
            for (int j = 0; j < oldPs.length; ++j) {
                if (oldPs[j].getName().equals(oldName)) {
                    oldGetter = oldPs[j].getReadMethod();
                    break;
                }
            }
            if (oldGetter == null) {
                for (int j = 0; j < oldMethods.length; j++) {
                    if (oldMethods[j].getName().equalsIgnoreCase("swapGet" + oldName)) {
                        oldGetter = oldMethods[j];
                        break;
                    }
                }
            }
            
            newName = (String)newNames.elementAt(i);
            for (int j = 0; j < newPs.length; ++j) {
                if (newPs[j].getName().equals(newName)) {
                    newSetter = newPs[j].getWriteMethod();
                    break;
                }
            }
            if (newSetter == null) {
                for (int j = 0; j < newMethods.length; j++) {
                    if (newMethods[j].getName().equalsIgnoreCase("swapSet" + newName)) {
                        newSetter = newMethods[j];
                        break;
                    }
                }
            }
            
            if (oldGetter == null) {
                throw new SwapException("SwapManager: There is no getter method for" +
                                        "\nstate named " + oldName + " at the old S-Module");
            }
            if (newSetter == null) {
                throw new SwapException("SwapManager: There is no setter method for" +
                                        "\nstate named " + newName + " at the new S-Module");
            }
                        
            try {
                Object oldArgs[] = {};
                Object newArgs[] = {oldGetter.invoke(oldWrapper.getBean(), oldArgs)};
                newSetter.invoke(newWrapper.getBean(), newArgs);
            } catch (Exception ex) {
                ex.printStackTrace();
                throw new SwapException("SwapManager: Transfering state failed" +
                                        "\n   " + ex.getMessage());
	        }
	        
	        oldGetter = null;
	        newSetter = null;
	        oldName   = null;
	        newName   = null;
        }
        
        synchronized (this) {
            if (expire) {
                unblockService(oldWrapper);
                cleanup(newWrapper);
                ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
                throw new SwapException("SwapManager: Time up. Swap Transaction aborted");
            }
        }
        //System.out.println("I am at the end of 3");
    }
    
    private void handleSerialization() throws SwapException {
        try {
            File tmpFile = new File("_tmpFile.dat");
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(tmpFile));
            System.out.println("I am at position 7");
            oldWrapper.writeNakedBean(oos);
            System.out.println("I am at position 6");
            oos.close();
            //tmpFile.close();
            System.out.println("I am at position 5");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(tmpFile));
            System.out.println("I am at position 4");
            tmpFile.delete();
            System.out.println("I am at position 3");
            Method[] newMethods = newWrapper.getBean().getClass().getMethods();
            boolean found = false;
            
            for (int i = 0; i < newMethods.length; i++) {
                if (newMethods[i].getName().equalsIgnoreCase("readObject")) {
                    Object args[] = {ois};
                    newMethods[i].invoke(newWrapper.getBean(), args);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new SwapException("SwapManager: There is no readObject at the new bean" +
                                        "De-serialization failed");
            }
        } catch (Exception e) {
            unblockService(oldWrapper);
            cleanup(newWrapper);
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw new SwapException("Handle serialization failed:\n" + e.getMessage());
        }
    }
    
    public void handleState(Node stateNode) throws SwapException {
        Element element = (Element)stateNode;
        NodeList ser = element.getElementsByTagName("Serialization");
        
        if (ser.getLength() == 1 && ser.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList serText = ser.item(0).getChildNodes();
            if (serText.getLength() == 1 && serText.item(0).getNodeType() == Node.TEXT_NODE 
                && serText.item(0).getNodeValue().equals("true")) {
                
                //handleSerialization();
                handleMappingRules(stateNode);
            } else {
                handleMappingRules(stateNode);
            }
        } else {
            unblockService(oldWrapper);
            cleanup(newWrapper);
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw new SwapException("SwapManager: Parse Serialization node failed");
        }    
    }
    
    public void handlePostProcess(Node node) throws SwapException {
        //System.out.println("I am at the beginning of 4");
        Element element = (Element)node;
        NodeList swapMethodNode = element.getElementsByTagName("swap_method");
        String swapMethodName = "";
        
        if (swapMethodNode.getLength() == 1 && swapMethodNode.item(0).getNodeType() == Node.ELEMENT_NODE) {
            NodeList swapMethodText = swapMethodNode.item(0).getChildNodes();
            if (swapMethodText.getLength() == 1 && swapMethodText.item(0).getNodeType() == Node.TEXT_NODE
                && swapMethodText.item(0).getNodeValue() != null) {
                    
                swapMethodName = swapMethodText.item(0).getNodeValue();
            }
        } else {
            unblockService(oldWrapper);
            cleanup(newWrapper);
            ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
            throw new SwapException("SwapManager: Parsing swap_method failed");
           
        }     
        
        Method[] newMethods = newWrapper.getBean().getClass().getMethods();
        boolean found = false;
        if (!swapMethodName.equalsIgnoreCase("null")) {
            for (int i = 0; i < newMethods.length; i++) {
                if (newMethods[i].getName().equalsIgnoreCase(swapMethodName)) {
                    try {
                        Object args[] = {};
                        newMethods[i].invoke(newWrapper.getBean(), args);
                        //System.out.println("****I am going to unblock new wrapper's service");
                        unblockService(newWrapper);
                    } catch (Exception ex) {
                        unblockService(oldWrapper);
                        cleanup(newWrapper);
                        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(true);
                        throw new SwapException("SwapManager: Invoke method at new Module failed" +
                                            "\n   " + ex.getMessage());
                    }
                    found = true;
                    break;
                }
            }
        
            if (!found) {
                throw new SwapException("SwapManager: There is no swapMethod() at the new S-Module");
            }
        }
        cleanup(oldWrapper);
        ((SwapBox)BeanBoxFrame.getCurrentBeanBox()).setEventsMenu(false);
        //System.out.println("I am at the end of 4");
    }
}
       
        
    
    