package carleton.swapbox;

import java.awt.*;
import java.util.Vector;
import java.io.*;
import sun.beanbox.*;

public class DisplayState extends SwapConfigState {
    private TextArea displayArea;
    
    public DisplayState(SwapConfigState scs) {
        previousState = scs;
        scs.setNextState(this);
        
        statePanel = new Panel();
        statePanel.setLayout(null);
		statePanel.setBackground(java.awt.Color.lightGray);
		statePanel.setBounds(12,12,409,385);
		
        displayArea = new TextArea();
        displayArea.setEditable(false);
		statePanel.add(displayArea);
		displayArea.setBounds(12,12,392,365);
		
		panelTitle = "Display XML Format Configuration";
		
		activate();
	}
	
	public String toString() {
	    return "This is an instance of DisplayState";
	}
	
	public SwapConfigState handleForwardEvent() { 
	    String defaultStoreFile = "untitled.xml";
	    // xmlString = getXMLString();
	    FileDialog fd = new FileDialog(editor, "Save Swap Config File", FileDialog.SAVE);
	    // the setDirectory() is not needed, except for a bug under Solaris...
	    fd.setDirectory(System.getProperty("user.dir"));
	    fd.setFile(defaultStoreFile);
	    fd.show();
	    String fname = fd.getFile();
	    if (fname == null) {
	        return null;
	    }
	    String dname = fd.getDirectory();
	    File file = new File(dname, fname);	  
	        
	    try {
	        // create the single ObjectOutputStream
	        FileWriter fileWriter = new FileWriter(file);
	        fileWriter.write(xmlString, 0, xmlString.length());
	        fileWriter.flush();
	        fileWriter.close();
	    } catch (Exception ex) {
	        new ErrorDialog (editor, "Error when save XML file");
	    }
	    return new TerminalState();
	}
	
	public SwapConfigState handleBackwardEvent() {
	    editor.getForwardButton().setLabel("Forward");
	    if (previousState != null) {
	        previousState.activate();
	    }
	    return previousState;
	}
	
	public String getXMLString() {
	    SwapConfigState scs = this;
	    
	    xmlString = "<?xml version='1.0' encoding='us-ascii'?>\n" + "\n<swap>";
	    while (scs.getPreviousState() != null) {
	        scs = scs.getPreviousState();
	        // System.out.println(scs.toString());
	    }
	    // System.out.println("The first SwapConfigState is: " + scs.toString());
	    while (scs != this) {
	        // System.out.println("The xmlString is: " + scs.getXMLString());
	        xmlString += scs.getXMLString();
	        scs = scs.getNextState();
	    }
	    //xmlString += "\n    <interaction></interaction>";
	    xmlString += "\n</swap>";
	    return xmlString;
	}
	
	public void activate() {
	    editor.getForwardButton().setLabel("Finish");
	    xmlString = getXMLString();
		displayArea.setText(xmlString);
	}
}