package carleton.swapbox;

import java.awt.*;
import java.beans.*;
import java.awt.event.*;
import java.util.*;
import sun.beanbox.*;

public class EventReportFrame extends Frame{
    java.awt.Panel panel1 = new java.awt.Panel();
	java.awt.Label incomingLabel = new java.awt.Label();
	java.awt.List incomingList = new java.awt.List(4);
	java.awt.TextArea detailText = new java.awt.TextArea();
	java.awt.List outgoingList = new java.awt.List(4);
	java.awt.Label outgoingLabel = new java.awt.Label();
	java.awt.Label detailLabel = new java.awt.Label();
	java.awt.Label titleField = new java.awt.Label();
	java.awt.Button exitButton = new java.awt.Button();
	private Wrapper w;
	private BeanReport br;
	private Vector incomingEvents;
	private Vector outgoingEvents;
	private String title = "Events Report on ";
	
	public EventReportFrame(Wrapper w){
		this.w = w;
		AdapterCenter ac = AdapterCenter.getInstance();
		br = ac.getBeanReport(w.getBean());
		
		setLayout(null);
		setBackground(java.awt.Color.lightGray);
		setSize(366,400);
		setVisible(false);
		
		panel1.setLayout(null);
		add(panel1);
		panel1.setBackground(java.awt.Color.lightGray);
		panel1.setBounds(0,60,360,288);
		
		incomingLabel.setText("Incoming Events");
		panel1.add(incomingLabel);
		incomingLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		incomingLabel.setBounds(12,0,110,32);
		
		panel1.add(incomingList);
		incomingList.setBounds(12,36,156,90);
		incomingList.addActionListener(new ListHandler());
		
		panel1.add(detailText);
		detailText.setBounds(12,180,336,96);
		
		panel1.add(outgoingList);
		outgoingList.setBounds(192,36,156,90);
		outgoingList.addActionListener(new ListHandler());
		
		outgoingLabel.setText("Outgoing Events");
		panel1.add(outgoingLabel);
		outgoingLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		outgoingLabel.setBounds(192,0,110,32);
		
		detailLabel.setText("Detailed Description");
		detailLabel.setAlignment(java.awt.Label.CENTER);
		panel1.add(detailLabel);
		detailLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		detailLabel.setBounds(120,144,132,32);
		
		String s = ac.getBeanName(w);
		if (s != null) {
		    title = title.concat(s);
		}
		titleField.setText(title);
		titleField.setAlignment(java.awt.Label.CENTER);
		add(titleField);
		titleField.setBackground(java.awt.Color.lightGray);
		titleField.setForeground(java.awt.Color.black);
		titleField.setFont(new Font("Dialog", Font.BOLD|Font.ITALIC, 14));
		titleField.setBounds(48,24,252,30);
		
		exitButton.setLabel("Exit");
		add(exitButton);
		exitButton.setBackground(java.awt.Color.lightGray);
		exitButton.setFont(new Font("Dialog", Font.BOLD, 14));
		exitButton.setBounds(132,350,84,41);
		exitButton.addActionListener(new ExitButtonHandler());
		
		setTitle("Event Report Frame");
		
		incomingEvents = br.getIncomingEvents();
		for (int i = 0; i < incomingEvents.size(); i++) {
		    incomingList.add(((SwapEventInfo)incomingEvents.elementAt(i)).getEventName());
		}
		outgoingEvents = br.getOutgoingEvents();
		for (int i = 0; i < outgoingEvents.size(); i++) {
		    outgoingList.add(((SwapEventInfo)outgoingEvents.elementAt(i)).getEventName());
		}
		
		setVisible(true);
		
		new WindowCloser(this);
	}
	
	private class ExitButtonHandler implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        dispose();
	    }
	}
	
	private class ListHandler implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        int i;
	        SwapEventInfo sei;
	        if (e.getSource() == incomingList) {
	            i = incomingList.getSelectedIndex();
	            sei = (SwapEventInfo)(incomingEvents.elementAt(i));
	            outgoingList.deselect(outgoingList.getSelectedIndex());
	            detailText.setText(sei.toString());
	        } else {
	            i = outgoingList.getSelectedIndex();
	            sei = (SwapEventInfo)(outgoingEvents.elementAt(i));
	            incomingList.deselect(incomingList.getSelectedIndex());
	            detailText.setText(sei.toString());
	        }
	    }
	}
}
	
	

