package carleton.swapbox;

import java.awt.*;
import java.lang.reflect.*;
import java.util.Vector;
import java.beans.*;
import sun.beanbox.*;
import org.xml.sax.*;
import org.w3c.dom.*; 
import javax.xml.parsers.*;

public class GeneralParesState extends SwapConfigState {
    
    private Label timeLabel = new java.awt.Label();
	private TextField timeInput = new java.awt.TextField();
	private List swapTypeList = new java.awt.List(0);
	private Label swapTypeLabel = new java.awt.Label();
	private Label swapMethodLabel = new java.awt.Label();
	private List swapMethodList = new java.awt.List(4);
    
    public GeneralParesState() {
        statePanel = new Panel();
        statePanel.setLayout(null);
		statePanel.setBackground(java.awt.Color.lightGray);
		statePanel.setBounds(12,12,409,385);
		
		timeLabel.setText("Time Constraint (msc):");
		statePanel.add(timeLabel);
		timeLabel.setFont(new Font("Dialog", Font.BOLD, 14));
		timeLabel.setBounds(36,36,156,43);
		
		statePanel.add(timeInput);
		timeInput.setBounds(204,36,155,36);
				
		statePanel.add(swapTypeList);
		swapTypeList.setBounds(204,96,156,60);
		swapTypeList.setMultipleMode(false);
		
		swapTypeList.add("Default");
		swapTypeList.add("Option1");
		swapTypeList.add("Option2");
		//putSwapManager();
		swapTypeList.select(0);
		
		swapTypeLabel.setText("Swap Type:");
		statePanel.add(swapTypeLabel);
		swapTypeLabel.setFont(new Font("Dialog", Font.BOLD, 14));
		swapTypeLabel.setBounds(96,96,96,43);
		
		swapMethodLabel.setText("Swap Method:");
		statePanel.add(swapMethodLabel);
		swapMethodLabel.setFont(new Font("Dialog", Font.BOLD, 14));
		swapMethodLabel.setBounds(84,192,108,43);
		
		statePanel.add(swapMethodList);
		swapMethodList.setBounds(204,192,156,96);
		swapMethodList.setMultipleMode(false);
		swapMethodList.add("Null");
		swapMethodList.select(0);
		try {
		    MethodDescriptor mds[] = Introspector.getBeanInfo(
		                    editor.getNewWrapper().getBean().getClass()).getMethodDescriptors();
		    Vector swapMethods = new Vector();
		    for (int i = 0; i < mds.length; i++) {
		        MethodDescriptor md = mds[i];
	            Class margs[] = md.getMethod().getParameterTypes();
	            Class mExceptions[] = md.getMethod().getExceptionTypes();
	            if (margs.length == 0  && mExceptions.length == 0
	                && md.getMethod().getReturnType() == Void.TYPE) {
	             
	                    swapMethods.addElement(md);
	            }
	        }
	        sortMethods(swapMethods);
	        for (int i = 0; i < swapMethods.size(); i++) {
	            swapMethodList.add(((MethodDescriptor)swapMethods.elementAt(i)).getName());
	        }
		} catch (IntrospectionException ie) {}
		
		panelTitle = "Config General Parameters";
		xmlString = "";
	}
	
	public String toString() {
	    return "This is an instance of GeneralParesState";
	}
	
	public SwapConfigState handleForwardEvent() {
        if (nextState == null) {
            try {
                SwapConfigState scs = new MappingRulesState(this);
                return scs;
            } catch (SwapException se) {
                new ErrorDialog (getEditor(), se.getMessage());
                return null;
            }
        } else {
            nextState.activate();
            return nextState;
        }
    }
    
    public SwapConfigState handleResetEvent() {
        timeInput.setText("");
        swapTypeList.select(0);
        swapMethodList.select(0);
        return null;
    }
    
    public String getXMLString() {
        String timeConstraint = timeInput.getText();
        xmlString = "";
        xmlString += "\n   <swap_type>" + swapTypeList.getSelectedItem() + "</swap_type>";
        if (timeConstraint != null) {
            xmlString += "\n   <pre_process>";
            xmlString += "\n       <time>" + timeConstraint.trim() + "</time>";
            xmlString += "\n   </pre_process>";
        }
        xmlString += "\n    <post_process>";
        xmlString += "\n        <swap_method>" + swapMethodList.getSelectedItem() + "</swap_method>";
        xmlString += "\n    </post_process>";
        return xmlString;
    }
    
    public void activate() {
        String timeConstraint = timeInput.getText();
        statePanel.remove(timeInput);
        timeInput = new TextField();
        statePanel.add(timeInput);
		timeInput.setBounds(204,36,155,36);
		timeInput.setText(timeConstraint);
    }
    
    private void sortMethods(Vector methods) {
        for (int i = methods.size()-2; i >= 0; i--) {
            for (int j = 0; j <= i; j++) {
                String s1 = ((MethodDescriptor)methods.elementAt(j)).getName();
                String s2 = ((MethodDescriptor)methods.elementAt(j+1)).getName();
                if (s1.compareTo(s2) > 0) {
                    Object tmp = methods.elementAt(j);
                    methods.setElementAt(methods.elementAt(j+1), j);
                    methods.setElementAt(tmp, j+1);
		        }
	        }
	    }
    }
}