package carleton.swapbox;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.io.*;
import java.lang.reflect.*;
import java.beans.*;
import sun.beanbox.*;

public class InteractionState extends SwapConfigState {
    private Label changedLabel = new Label();
	private List changedList = new List(0);
	private Label descriptionLabel = new Label();
	private TextArea textArea1 = new TextArea();
	private Label alternativeLabel = new Label();
	private List methodsList = new List(0);
	private Button changeButton = new Button();
	
	private Vector changedEvents = new Vector();
	Vector alternativeMethods = new Vector();
	private AdapterCenter ac;
	//private MethodDescriptor mds[], displayedMds[]; 
	
	public InteractionState(SwapConfigState scs) {
	    previousState = scs;
        scs.setNextState(this);
        ac = AdapterCenter.getInstance();
        /*try {
            mds = Introspector.getBeanInfo(editor.getNewWrapper().getBean().getClass()).getMethodDescriptors();
        } catch (Exception e) {}*/
        
	    statePanel = new Panel();
	    statePanel.setLayout(null);
		statePanel.setBackground(java.awt.Color.lightGray);
		statePanel.setBounds(12,12,409,385);
		
		changedLabel.setText("Changed Events");
		statePanel.add(changedLabel);
		changedLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		changedLabel.setBounds(48,24,100,40);
		
		statePanel.add(changedList);
		changedList.setBounds(36,72,120,108);
		changedList.addActionListener(new ChangedListHandler());
		changedList.setMultipleMode(false);
		SwapReport aReport = ac.report(editor.getNewWrapper().getBean(), 
		                                          editor.getOldWrapper().getBean());
		//System.out.println("aReport is: " + aReport);
		/*Vector v = aReport.getUnchangedEvents();
		for (int i = 0; i < v.size(); i++) {
		    System.out.println("A sei is: " + ((SwapEventInfo)v.elementAt(i)).toString());
		}*/
        changedEvents = aReport.getChangedEvents(); 
        //System.out.println("The size of the changedEvents is: " + changedEvents.size());
        for (int i = 0; i < changedEvents.size(); i++) {
		    changedList.add(((SwapEventInfo)changedEvents.elementAt(i)).getEventName());
		}
		
		descriptionLabel.setText("Description");
		statePanel.add(descriptionLabel);
		descriptionLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		descriptionLabel.setBounds(240,24,100,40);
		
		statePanel.add(textArea1);
		textArea1.setBounds(204,72,168,108);
		
		alternativeLabel.setText("Alternative Methods");
		statePanel.add(alternativeLabel);
		alternativeLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		alternativeLabel.setBounds(36,192,120,40);
		
		statePanel.add(methodsList);
		methodsList.setBounds(36,228,120,120);
		methodsList.setMultipleMode(false);
		/*Method[] methods = editor.getNewWrapper().getBean().getClass().getMethods();
		for (int i = 0; i < methods.length; i++) {
		    methodsList.add(methods[i].getName());
		}*/
		
		changeButton.setLabel("Change");
		statePanel.add(changeButton);
		changeButton.setBackground(java.awt.Color.lightGray);
		changeButton.setFont(new Font("Dialog", Font.BOLD, 12));
		changeButton.setBounds(240,264,82,36);
		changeButton.addActionListener(new ChangeButtonHandler());
		
		panelTitle = "Config Interactions";
		xmlString = "";
		
	}
	
	public String toString() {
	    return "This is an instance of InteractionState";
	}
	
	 public SwapConfigState handleForwardEvent() {
        if (nextState == null) {
            SwapConfigState scs = new DisplayState(this);
            return scs;
        } else {
            nextState.activate();
            return nextState;
        }
    }
    
    public SwapConfigState handleResetEvent() {
        // xmlString = "\n    <state_policy>";
        /*xmlString = "";
        newStatesList.select(0);
        oldStatesList.select(0);*/
        xmlString = "";
        return null;
    }
    
    public String getXMLString() {
        /*String temp = "\n    <state_policy>";
        if (serYESRadioButton.getState()) {
            temp += "\n       <Serialization>true</Serialization>";
        } else {
            temp += "\n       <Serialization>false</Serialization>";
        }
        temp += xmlString + "\n    </state_policy>";
        return temp;*/
        if (xmlString.equals("")) {
            xmlString += "\n    <interaction_policy></interaction_policy>";
        }
        return xmlString;
    }
    
    public void activate() {
        // xmlString = "\n    <state_policy>";
    }
    
    private class ChangeButtonHandler implements ActionListener {
	    public void actionPerformed (ActionEvent ae) {
	        SwapEventInfo sei;
	        MethodDescriptor newMethod;
	        if (changedEvents.size() != 0 && methodsList.getSelectedIndex() != -1) {
	            sei = (SwapEventInfo)changedEvents.elementAt(changedList.getSelectedIndex());
	            //newMethod = mds[methodsList.getSelectedIndex()];
	            newMethod = (MethodDescriptor)alternativeMethods.elementAt(methodsList.getSelectedIndex());
	            Class nmArgs[] = newMethod.getMethod().getParameterTypes();
	            //Class nmExceptions[] = newMethod.getMethod().getExceptionTypes();
	            Class omArgs[] = sei.getTargetMethod().getParameterTypes();
	            //Class nmExceptions[] = sei.getTargetMethod().getParameterTypes();
	            
	            xmlString += "\n    <interaction_policy>";
	            xmlString += "\n        <change_TargetMethod>";
	            xmlString += "\n            <event_source>" 
	                       + ac.getBeanName(sei.getSource()) + "</event_source>";
	            xmlString += "\n            <event_name>" + sei.getEventName() + "</event_name>";
	            xmlString += "\n            <old_method>";
	            xmlString += "\n                <method_name>" + sei.getTargetMethod().getName()
	                       + "</method_name>";
	            for (int i = 0; i < omArgs.length; i++) {
	                xmlString += "\n                <parameter_type>" + omArgs[i].getName() + "</parameter_type>";
	            }
	            xmlString += "\n            </old_method>";
	            xmlString += "\n            <new_method>";
	            xmlString += "\n                <method_name>" + newMethod.getMethod().getName()
	                       + "</method_name>";
	            for (int i = 0; i < nmArgs.length; i++) {
	                xmlString += "\n                <parameter_type>" + nmArgs[i].getName() + "</parameter_type>";
	            }
	            xmlString += "\n            </new_method>";
	            xmlString += "\n        </change_TargetMethod>";
	            xmlString += "\n    </interaction_policy>";
	        }
	    }
	}
	
	private class ChangedListHandler implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        // Vector alternativeMethods = new Vector();
	        SwapEventInfo sei = (SwapEventInfo)changedEvents.elementAt(changedList.getSelectedIndex());
	        textArea1.setText(sei.toString());
	        try {
	            MethodDescriptor mds[] = Introspector.getBeanInfo(
		                    editor.getNewWrapper().getBean().getClass()).getMethodDescriptors();
		        Class eargs[] = sei.getListenerMethod().getParameterTypes();
		        Class eExceptions[] = sei.getListenerMethod().getExceptionTypes();
		        
		        for (int i = 0; i < mds.length; i++) {
		            MethodDescriptor md = mds[i];
		            Class margs[] = md.getMethod().getParameterTypes();
		            Class mExceptions[] = md.getMethod().getExceptionTypes();
		            if (margs.length == 0  && mExceptions.length == 0 
		                && md.getMethod().getReturnType() == Void.TYPE) {
	             
	                    alternativeMethods.addElement(md);
	                }
	                
	                if ((eargs.length != margs.length) || (eExceptions.length > mExceptions.length)) {
	                    continue;
	                }
	                boolean match = true;
	                // check to see if formal parameter types agree
	                
	                for (int j = 0; j < eargs.length; j++) {
	                    if (!AdapterCenter.isSubclass(eargs[j], margs[j])) {
	                        match = false;
	                        break;
		                }
		            }
		            
		            // check to see if checked exception types agree
		            for (int j = 0; j < eExceptions.length; j++) {
		                if (!AdapterCenter.isSubclass(eExceptions[j], mExceptions[j])) {
		                    match = false;
		                    break;
		                }
	                }
	                if (match) {
	                    alternativeMethods.addElement(md);
		            }
	            }
	        } catch (Exception ex) {}
	   
	        sortMethods(alternativeMethods);
	        for (int i = 0; i < alternativeMethods.size(); i++) {
	            methodsList.add(((MethodDescriptor)alternativeMethods.elementAt(i)).getName());
	        }
	    }
	}
	
	private void sortMethods(Vector methods) {
        for (int i = methods.size()-2; i >= 0; i--) {
            for (int j = 0; j <= i; j++) {
                String s1 = ((MethodDescriptor)methods.elementAt(j)).getName();
                String s2 = ((MethodDescriptor)methods.elementAt(j+1)).getName();
                if (s1.compareTo(s2) > 0) {
                    Object tmp = methods.elementAt(j);
                    methods.setElementAt(methods.elementAt(j+1), j);
                    methods.setElementAt(tmp, j+1);
		        }
	        }
	    }
    }
}
		
		